/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.PropertiesBasedPrefixResolver;
import org.apache.jmeter.util.TidyException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XPathUtil {
    private static final Logger log = LoggerFactory.getLogger(XPathUtil.class);
    private static DocumentBuilderFactory documentBuilderFactory;

    private XPathUtil() {
    }

    private static synchronized DocumentBuilderFactory makeDocumentBuilderFactory(boolean validate, boolean whitespace, boolean namespace) {
        if (documentBuilderFactory == null || documentBuilderFactory.isValidating() != validate || documentBuilderFactory.isNamespaceAware() != namespace || documentBuilderFactory.isIgnoringElementContentWhitespace() != whitespace) {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(validate);
            documentBuilderFactory.setNamespaceAware(namespace);
            documentBuilderFactory.setIgnoringElementContentWhitespace(whitespace);
        }
        return documentBuilderFactory;
    }

    public static DocumentBuilder makeDocumentBuilder(boolean validate, boolean whitespace, boolean namespace, boolean downloadDTDs) throws ParserConfigurationException {
        DocumentBuilder builder = XPathUtil.makeDocumentBuilderFactory(validate, whitespace, namespace).newDocumentBuilder();
        builder.setErrorHandler(new MyErrorHandler(validate, false));
        if (!downloadDTDs) {
            EntityResolver er = new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
            };
            builder.setEntityResolver(er);
        }
        return builder;
    }

    public static Document makeDocument(InputStream stream, boolean validate, boolean whitespace, boolean namespace, boolean tolerant, boolean quiet, boolean showWarnings, boolean reportErrors, boolean isXml, boolean downloadDTDs) throws ParserConfigurationException, SAXException, IOException, TidyException {
        return XPathUtil.makeDocument(stream, validate, whitespace, namespace, tolerant, quiet, showWarnings, reportErrors, isXml, downloadDTDs, null);
    }

    public static Document makeDocument(InputStream stream, boolean validate, boolean whitespace, boolean namespace, boolean tolerant, boolean quiet, boolean showWarnings, boolean report_errors, boolean isXml, boolean downloadDTDs, OutputStream tidyOut) throws ParserConfigurationException, SAXException, IOException, TidyException {
        Document doc = tolerant ? XPathUtil.tidyDoc(stream, quiet, showWarnings, report_errors, isXml, tidyOut) : XPathUtil.makeDocumentBuilder(validate, whitespace, namespace, downloadDTDs).parse(stream);
        return doc;
    }

    private static Document tidyDoc(InputStream stream, boolean quiet, boolean showWarnings, boolean report_errors, boolean isXML, OutputStream out) throws TidyException {
        StringWriter sw = new StringWriter();
        Tidy tidy = XPathUtil.makeTidyParser(quiet, showWarnings, isXML, sw);
        Document doc = tidy.parseDOM(stream, out);
        doc.normalize();
        if (tidy.getParseErrors() > 0) {
            if (report_errors) {
                log.error("TidyException: {}", (Object)sw);
                throw new TidyException(tidy.getParseErrors(), tidy.getParseWarnings());
            }
            log.warn("Tidy errors: {}", (Object)sw);
        }
        return doc;
    }

    public static Tidy makeTidyParser(boolean quiet, boolean showWarnings, boolean isXml, StringWriter stringWriter) {
        Tidy tidy = new Tidy();
        tidy.setInputEncoding(StandardCharsets.UTF_8.name());
        tidy.setOutputEncoding(StandardCharsets.UTF_8.name());
        tidy.setQuiet(quiet);
        tidy.setShowWarnings(showWarnings);
        tidy.setMakeClean(true);
        tidy.setXmlTags(isXml);
        if (stringWriter != null) {
            tidy.setErrout(new PrintWriter(stringWriter));
        }
        return tidy;
    }

    private static String getValueForNode(Node node) {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException e) {
            sw.write(e.getMessageAndLocation());
        }
        return sw.toString();
    }

    public static NodeList selectNodeList(Document document, String xPathExpression) throws TransformerException {
        XObject xObject = XPathAPI.eval((Node)document, (String)xPathExpression, (PrefixResolver)XPathUtil.getPrefixResolver(document));
        return xObject.nodelist();
    }

    public static void putValuesForXPathInList(Document document, String xPathQuery, List<String> matchStrings, boolean fragment) throws TransformerException {
        XPathUtil.putValuesForXPathInList(document, xPathQuery, matchStrings, fragment, -1);
    }

    public static void putValuesForXPathInList(Document document, String xPathQuery, List<String> matchStrings, boolean fragment, int matchNumber) throws TransformerException {
        String val = null;
        XObject xObject = XPathAPI.eval((Node)document, (String)xPathQuery, (PrefixResolver)XPathUtil.getPrefixResolver(document));
        int objectType = xObject.getType();
        if (objectType == 4) {
            NodeList matches = xObject.nodelist();
            int length = matches.getLength();
            int indexToMatch = matchNumber;
            if (matchNumber == 0 && length > 0) {
                indexToMatch = JMeterUtils.getRandomInt(length) + 1;
            }
            for (int i = 0; i < length; ++i) {
                Node firstChild;
                Node match = matches.item(i);
                if (indexToMatch >= 0 && indexToMatch != i + 1) continue;
                val = match instanceof Element ? (fragment ? XPathUtil.getValueForNode(match) : ((firstChild = match.getFirstChild()) != null ? firstChild.getNodeValue() : match.getNodeValue())) : match.getNodeValue();
                matchStrings.add(val);
            }
        } else if (objectType == -1 || objectType == 0 || objectType == 600) {
            if (log.isWarnEnabled()) {
                log.warn("Unexpected object type: {} returned for: {}", (Object)xObject.getTypeString(), (Object)xPathQuery);
            }
        } else {
            val = xObject.toString();
            matchStrings.add(val);
        }
    }

    private static PrefixResolver getPrefixResolver(Document document) {
        return new PropertiesBasedPrefixResolver(document.getDocumentElement());
    }

    public static void validateXPath(Document document, String xpathString) throws TransformerException {
        if (XPathAPI.eval((Node)document, (String)xpathString, (PrefixResolver)XPathUtil.getPrefixResolver(document)) == null) {
            throw new IllegalArgumentException("xpath eval of '" + xpathString + "' was null");
        }
    }

    public static void computeAssertionResult(AssertionResult result, Document doc, String xPathExpression, boolean isNegated) {
        try {
            XObject xObject = XPathAPI.eval((Node)doc, (String)xPathExpression, (PrefixResolver)XPathUtil.getPrefixResolver(doc));
            switch (xObject.getType()) {
                case 4: {
                    NodeList nodeList = xObject.nodelist();
                    int len = nodeList != null ? nodeList.getLength() : 0;
                    log.debug("nodeList length {}", (Object)len);
                    if (len == 0) {
                        log.debug("nodeList is null or empty. No match by xpath expression: {}", (Object)xPathExpression);
                        result.setFailure(!isNegated);
                        result.setFailureMessage("No Nodes Matched " + xPathExpression);
                        return;
                    }
                    if (log.isDebugEnabled() && !isNegated) {
                        for (int i = 0; i < len; ++i) {
                            log.debug("nodeList[{}]: {}", (Object)i, (Object)nodeList.item(i));
                        }
                    }
                    result.setFailure(isNegated);
                    if (isNegated) {
                        result.setFailureMessage("Specified XPath was found... Turn off negate if this is not desired");
                    }
                    return;
                }
                case 1: {
                    if (!xObject.bool()) {
                        result.setFailure(!isNegated);
                        result.setFailureMessage("No Nodes Matched " + xPathExpression);
                    }
                    return;
                }
            }
            result.setFailure(true);
            result.setFailureMessage("Cannot understand: " + xPathExpression);
            return;
        }
        catch (TransformerException e) {
            result.setError(true);
            result.setFailureMessage("TransformerException: " + e.getMessage() + " for:" + xPathExpression);
            return;
        }
    }

    public static String formatXml(String xml) {
        try {
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            SAXSource xmlSource = new SAXSource(new InputSource(new StringReader(xml)));
            StringWriter stringWriter = new StringWriter();
            StreamResult res = new StreamResult(stringWriter);
            serializer.transform(xmlSource, res);
            return stringWriter.toString();
        }
        catch (Exception e) {
            return xml;
        }
    }

    static class MyErrorHandler
    implements ErrorHandler {
        private final boolean val;
        private final boolean tol;
        private final String type;

        MyErrorHandler(boolean validate, boolean tolerate) {
            this.val = validate;
            this.tol = tolerate;
            this.type = "Val=" + this.val + " Tol=" + this.tol;
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
            if (log.isInfoEnabled()) {
                log.info("Type={}. {}", (Object)this.type, (Object)ex.toString());
            }
            if (this.val && !this.tol) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            if (log.isWarnEnabled()) {
                log.warn("Type={}. {}", (Object)this.type, (Object)ex.toString());
            }
            if (this.val && !this.tol) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            log.error("Type={}. {}", (Object)this.type, (Object)ex.toString());
            if (this.val && !this.tol) {
                throw new SAXException(ex);
            }
        }
    }
}

