/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSocket;

public class HostNameSetter {
    private static final AtomicReference<HostNameSetter> CURRENT = new AtomicReference();
    private final WeakReference<Class<?>> cls;
    private final WeakReference<Method> setter;

    private HostNameSetter(Class<?> clazz, Method setter) {
        this.cls = new WeakReference(clazz);
        this.setter = setter == null ? null : new WeakReference<Method>(setter);
    }

    private static Method init(Class<?> cls) {
        Method s = null;
        try {
            s = cls.getMethod("setHost", String.class);
        }
        catch (Exception e) {
            HostNameSetter.initFail(e);
        }
        CURRENT.set(new HostNameSetter(cls, s));
        return s;
    }

    private static void initFail(Exception e) {
    }

    private Method reuse(Class<?> cls) {
        boolean setterNotSupported;
        boolean wrongClass;
        boolean bl = wrongClass = this.cls.get() != cls;
        if (wrongClass) {
            return HostNameSetter.init(cls);
        }
        boolean bl2 = setterNotSupported = this.setter == null;
        if (setterNotSupported) {
            return null;
        }
        Method s = (Method)this.setter.get();
        boolean setterLost = s == null;
        return setterLost ? HostNameSetter.init(cls) : s;
    }

    public static void setServerNameIndication(String hostname, SSLSocket sslsock) {
        Method setter;
        Class<?> cls = sslsock.getClass();
        HostNameSetter current = CURRENT.get();
        Method method = setter = current == null ? HostNameSetter.init(cls) : current.reuse(cls);
        if (setter != null) {
            try {
                setter.invoke((Object)sslsock, hostname);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                HostNameSetter.setServerNameIndicationFail(e);
            }
        }
    }

    private static void setServerNameIndicationFail(Exception e) {
    }
}

