/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.TransactionSampler;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleMonitor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testbeans.TestBeanHelper;
import org.apache.jmeter.testelement.AbstractScopedAssertion;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestIterationListener;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.FindTestElementsUpToRootTraverser;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterThreadMonitor;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.threads.SamplePackage;
import org.apache.jmeter.threads.TestCompiler;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.timers.TimerService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.jorphan.collections.SearchByClass;
import org.apache.jorphan.util.JMeterError;
import org.apache.jorphan.util.JMeterStopTestException;
import org.apache.jorphan.util.JMeterStopTestNowException;
import org.apache.jorphan.util.JMeterStopThreadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMeterThread
implements Runnable,
Interruptible {
    private static final Logger log = LoggerFactory.getLogger(JMeterThread.class);
    public static final String PACKAGE_OBJECT = "JMeterThread.pack";
    public static final String LAST_SAMPLE_OK = "JMeterThread.last_sample_ok";
    private static final String TRUE = Boolean.toString(true);
    private static final int RAMPUP_GRANULARITY = JMeterUtils.getPropDefault("jmeterthread.rampup.granularity", 1000);
    private static final float TIMER_FACTOR = JMeterUtils.getPropDefault("timer.factor", 1.0f);
    private static final TimerService TIMER_SERVICE = TimerService.getInstance();
    private static final float ONE_AS_FLOAT = 1.0f;
    private static final boolean APPLY_TIMER_FACTOR = Float.compare(TIMER_FACTOR, 1.0f) != 0;
    private final Controller threadGroupLoopController;
    private final HashTree testTree;
    private final TestCompiler compiler;
    private final JMeterThreadMonitor monitor;
    private final JMeterVariables threadVars;
    private final Collection<TestIterationListener> testIterationStartListeners;
    private final Collection<SampleMonitor> sampleMonitors;
    private final ListenerNotifier notifier;
    private String threadName;
    private int initialDelay = 0;
    private int threadNum = 0;
    private long startTime = 0L;
    private long endTime = 0L;
    private boolean scheduler = false;
    private AbstractThreadGroup threadGroup;
    private StandardJMeterEngine engine = null;
    private volatile boolean running;
    private volatile boolean onErrorStopTest;
    private volatile boolean onErrorStopTestNow;
    private volatile boolean onErrorStopThread;
    private volatile boolean onErrorStartNextLoop;
    private volatile Sampler currentSampler;
    private final ReentrantLock interruptLock = new ReentrantLock();

    public JMeterThread(HashTree test, JMeterThreadMonitor monitor, ListenerNotifier note) {
        this.monitor = monitor;
        this.threadVars = new JMeterVariables();
        this.testTree = test;
        this.compiler = new TestCompiler(this.testTree);
        this.threadGroupLoopController = (Controller)this.testTree.getArray()[0];
        SearchByClass threadListenerSearcher = new SearchByClass(TestIterationListener.class);
        test.traverse((HashTreeTraverser)threadListenerSearcher);
        this.testIterationStartListeners = threadListenerSearcher.getSearchResults();
        SearchByClass sampleMonitorSearcher = new SearchByClass(SampleMonitor.class);
        test.traverse((HashTreeTraverser)sampleMonitorSearcher);
        this.sampleMonitors = sampleMonitorSearcher.getSearchResults();
        this.notifier = note;
        this.running = true;
    }

    public void setInitialContext(JMeterContext context) {
        this.threadVars.putAll(context.getVariables());
    }

    public void setScheduled(boolean sche) {
        this.scheduler = sche;
    }

    public void setStartTime(long stime) {
        this.startTime = stime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setEndTime(long etime) {
        this.endTime = etime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    private void stopSchedulerIfNeeded() {
        long now = System.currentTimeMillis();
        long delay = now - this.endTime;
        if (delay >= 0L) {
            this.running = false;
            log.info("Stopping because end time detected by thread: {}", (Object)this.threadName);
        }
    }

    private void startScheduler() {
        long delay = this.startTime - System.currentTimeMillis();
        this.delayBy(delay, "startScheduler");
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JMeterContext threadContext = JMeterContextService.getContext();
        IterationListener iterationListener = null;
        try {
            iterationListener = this.initRun(threadContext);
            while (this.running) {
                Sampler sam = this.threadGroupLoopController.next();
                while (this.running && sam != null) {
                    this.processSampler(sam, null, threadContext);
                    threadContext.cleanAfterSample();
                    if (threadContext.isRestartNextLoop() || this.onErrorStartNextLoop && !TRUE.equals(threadContext.getVariables().get(LAST_SAMPLE_OK))) {
                        if (log.isDebugEnabled() && this.onErrorStartNextLoop && !threadContext.isRestartNextLoop()) {
                            log.debug("StartNextLoop option is on, Last sample failed, starting next loop");
                        }
                        this.triggerEndOfLoopOnParentControllers(sam, threadContext);
                        sam = null;
                        threadContext.getVariables().put(LAST_SAMPLE_OK, TRUE);
                        threadContext.setRestartNextLoop(false);
                        continue;
                    }
                    sam = this.threadGroupLoopController.next();
                }
                if (!this.threadGroupLoopController.isDone()) continue;
                this.running = false;
                log.info("Thread is done: {}", (Object)this.threadName);
            }
        }
        catch (JMeterStopTestException e) {
            if (log.isInfoEnabled()) {
                log.info("Stopping Test: {}", (Object)e.toString());
            }
            this.shutdownTest();
        }
        catch (JMeterStopTestNowException e) {
            if (log.isInfoEnabled()) {
                log.info("Stopping Test Now: {}", (Object)e.toString());
            }
            this.stopTestNow();
        }
        catch (JMeterStopThreadException e) {
            if (log.isInfoEnabled()) {
                log.info("Stop Thread seen for thread {}, reason: {}", (Object)this.getThreadName(), (Object)e.toString());
            }
        }
        catch (Exception | JMeterError e) {
            log.error("Test failed!", e);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        finally {
            this.currentSampler = null;
            try {
                this.interruptLock.lock();
                threadContext.clear();
                log.info("Thread finished: {}", (Object)this.threadName);
                this.threadFinished(iterationListener);
                this.monitor.threadFinished(this);
                JMeterContextService.removeContext();
            }
            finally {
                this.interruptLock.unlock();
            }
        }
    }

    private void triggerEndOfLoopOnParentControllers(Sampler sam, JMeterContext threadContext) {
        Sampler realSampler;
        TransactionSampler transactionSampler = null;
        if (sam instanceof TransactionSampler) {
            transactionSampler = (TransactionSampler)sam;
        }
        if ((realSampler = this.findRealSampler(sam)) == null) {
            throw new IllegalStateException("Got null subSampler calling findRealSampler for:" + (sam != null ? sam.getName() : "null") + ", sam:" + sam);
        }
        FindTestElementsUpToRootTraverser pathToRootTraverser = new FindTestElementsUpToRootTraverser(realSampler);
        this.testTree.traverse((HashTreeTraverser)pathToRootTraverser);
        List<Controller> controllersToReinit = pathToRootTraverser.getControllersToRoot();
        for (Controller parentController : controllersToReinit) {
            if (parentController instanceof AbstractThreadGroup) {
                AbstractThreadGroup tg = (AbstractThreadGroup)parentController;
                tg.startNextLoop();
                continue;
            }
            parentController.triggerEndOfLoop();
        }
        if (transactionSampler != null) {
            SamplePackage transactionPack = this.compiler.configureTransactionSampler(transactionSampler);
            this.doEndTransactionSampler(transactionSampler, null, transactionPack, threadContext);
        }
    }

    private Sampler findRealSampler(Sampler sampler) {
        Sampler realSampler = sampler;
        while (realSampler instanceof TransactionSampler) {
            realSampler = ((TransactionSampler)realSampler).getSubSampler();
        }
        return realSampler;
    }

    private SampleResult processSampler(Sampler current, Sampler parent, JMeterContext threadContext) {
        SampleResult transactionResult = null;
        try {
            TransactionSampler transactionSampler = null;
            if (current instanceof TransactionSampler) {
                transactionSampler = (TransactionSampler)current;
            }
            SamplePackage transactionPack = null;
            if (transactionSampler != null) {
                transactionPack = this.compiler.configureTransactionSampler(transactionSampler);
                if (transactionSampler.isTransactionDone()) {
                    transactionResult = this.doEndTransactionSampler(transactionSampler, parent, transactionPack, threadContext);
                    current = null;
                } else {
                    Sampler prev = current;
                    current = transactionSampler.getSubSampler();
                    if (current instanceof TransactionSampler) {
                        SampleResult res = this.processSampler(current, prev, threadContext);
                        threadContext.setCurrentSampler(prev);
                        current = null;
                        if (res != null) {
                            transactionSampler.addSubSamplerResult(res);
                        }
                    }
                }
            }
            if (current != null) {
                this.executeSamplePackage(current, transactionSampler, transactionPack, threadContext);
            }
            if (this.scheduler) {
                this.stopSchedulerIfNeeded();
            }
        }
        catch (JMeterStopTestException e) {
            if (log.isInfoEnabled()) {
                log.info("Stopping Test: {}", (Object)e.toString());
            }
            this.shutdownTest();
        }
        catch (JMeterStopTestNowException e) {
            if (log.isInfoEnabled()) {
                log.info("Stopping Test with interruption of current samplers: {}", (Object)e.toString());
            }
            this.stopTestNow();
        }
        catch (JMeterStopThreadException e) {
            if (log.isInfoEnabled()) {
                log.info("Stopping Thread: {}", (Object)e.toString());
            }
            this.stopThread();
        }
        catch (Exception e) {
            if (current != null) {
                log.error("Error while processing sampler: '{}'.", (Object)current.getName(), (Object)e);
            }
            log.error("Error while processing sampler.", (Throwable)e);
        }
        return transactionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSamplePackage(Sampler current, TransactionSampler transactionSampler, SamplePackage transactionPack, JMeterContext threadContext) {
        threadContext.setCurrentSampler(current);
        SamplePackage pack = this.compiler.configureSampler(current);
        this.runPreProcessors(pack.getPreProcessors());
        this.threadVars.putObject(PACKAGE_OBJECT, pack);
        this.delay(pack.getTimers());
        Sampler sampler = pack.getSampler();
        sampler.setThreadContext(threadContext);
        sampler.setThreadName(this.threadName);
        TestBeanHelper.prepare(sampler);
        this.currentSampler = sampler;
        if (!this.sampleMonitors.isEmpty()) {
            for (SampleMonitor sampleMonitor : this.sampleMonitors) {
                sampleMonitor.sampleStarting(sampler);
            }
        }
        SampleResult result = null;
        try {
            result = sampler.sample(null);
        }
        finally {
            if (!this.sampleMonitors.isEmpty()) {
                for (SampleMonitor sampleMonitor : this.sampleMonitors) {
                    sampleMonitor.sampleEnded(sampler);
                }
            }
        }
        this.currentSampler = null;
        if (result != null) {
            int n = this.threadGroup.getNumberOfThreads();
            int nbTotalActiveThreads = JMeterContextService.getNumberOfThreads();
            result.setGroupThreads(n);
            result.setAllThreads(nbTotalActiveThreads);
            result.setThreadName(this.threadName);
            SampleResult[] subResults = result.getSubResults();
            if (subResults != null) {
                for (SampleResult subResult : subResults) {
                    subResult.setGroupThreads(n);
                    subResult.setAllThreads(nbTotalActiveThreads);
                    subResult.setThreadName(this.threadName);
                }
            }
            threadContext.setPreviousResult(result);
            this.runPostProcessors(pack.getPostProcessors());
            this.checkAssertions(pack.getAssertions(), result, threadContext);
            List<SampleListener> sampleListeners = this.getSampleListeners(pack, transactionPack, transactionSampler);
            this.notifyListeners(sampleListeners, result);
            this.compiler.done(pack);
            if (transactionSampler != null) {
                transactionSampler.addSubSamplerResult(result);
            }
            if (result.isStopThread() || !result.isSuccessful() && this.onErrorStopThread) {
                this.stopThread();
            }
            if (result.isStopTest() || !result.isSuccessful() && this.onErrorStopTest) {
                this.shutdownTest();
            }
            if (result.isStopTestNow() || !result.isSuccessful() && this.onErrorStopTestNow) {
                this.stopTestNow();
            }
            if (result.isStartNextThreadLoop()) {
                threadContext.setRestartNextLoop(true);
            }
        } else {
            this.compiler.done(pack);
        }
    }

    private SampleResult doEndTransactionSampler(TransactionSampler transactionSampler, Sampler parent, SamplePackage transactionPack, JMeterContext threadContext) {
        SampleResult transactionResult = transactionSampler.getTransactionResult();
        transactionResult.setThreadName(this.threadName);
        transactionResult.setGroupThreads(this.threadGroup.getNumberOfThreads());
        transactionResult.setAllThreads(JMeterContextService.getNumberOfThreads());
        this.checkAssertions(transactionPack.getAssertions(), transactionResult, threadContext);
        if (!(parent instanceof TransactionSampler)) {
            this.notifyListeners(transactionPack.getSampleListeners(), transactionResult);
        }
        this.compiler.done(transactionPack);
        return transactionResult;
    }

    private List<SampleListener> getSampleListeners(SamplePackage samplePack, SamplePackage transactionPack, TransactionSampler transactionSampler) {
        List<SampleListener> sampleListeners = samplePack.getSampleListeners();
        if (transactionSampler != null) {
            ArrayList<SampleListener> onlySubSamplerListeners = new ArrayList<SampleListener>();
            List<SampleListener> transListeners = transactionPack.getSampleListeners();
            for (SampleListener listener : sampleListeners) {
                boolean found = false;
                for (SampleListener trans : transListeners) {
                    if (trans != listener) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                onlySubSamplerListeners.add(listener);
            }
            sampleListeners = onlySubSamplerListeners;
        }
        return sampleListeners;
    }

    private IterationListener initRun(JMeterContext threadContext) {
        threadContext.setVariables(this.threadVars);
        threadContext.setThreadNum(this.getThreadNum());
        threadContext.getVariables().put(LAST_SAMPLE_OK, TRUE);
        threadContext.setThread(this);
        threadContext.setThreadGroup(this.threadGroup);
        threadContext.setEngine(this.engine);
        this.testTree.traverse((HashTreeTraverser)this.compiler);
        if (this.scheduler) {
            this.startScheduler();
        }
        this.rampUpDelay();
        if (log.isInfoEnabled()) {
            log.info("Thread started: {}", (Object)Thread.currentThread().getName());
        }
        threadContext.setSamplingStarted(true);
        this.threadGroupLoopController.initialize();
        IterationListener iterationListener = new IterationListener();
        this.threadGroupLoopController.addIterationListener(iterationListener);
        this.threadStarted();
        return iterationListener;
    }

    private void threadStarted() {
        JMeterContextService.incrNumberOfThreads();
        this.threadGroup.incrNumberOfThreads();
        GuiPackage gp = GuiPackage.getInstance();
        if (gp != null) {
            gp.getMainFrame().updateCounts();
        }
        ThreadListenerTraverser startup = new ThreadListenerTraverser(true);
        this.testTree.traverse((HashTreeTraverser)startup);
    }

    private void threadFinished(LoopIterationListener iterationListener) {
        ThreadListenerTraverser shut = new ThreadListenerTraverser(false);
        this.testTree.traverse((HashTreeTraverser)shut);
        JMeterContextService.decrNumberOfThreads();
        this.threadGroup.decrNumberOfThreads();
        GuiPackage gp = GuiPackage.getInstance();
        if (gp != null) {
            gp.getMainFrame().updateCounts();
        }
        if (iterationListener != null) {
            this.threadGroupLoopController.removeIterationListener(iterationListener);
        }
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void stop() {
        this.running = false;
        log.info("Stopping: {}", (Object)this.threadName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean interrupt() {
        block11: {
            Sampler samp;
            block10: {
                this.interruptLock.lock();
                samp = this.currentSampler;
                if (!(samp instanceof Interruptible)) break block10;
                if (log.isWarnEnabled()) {
                    log.warn("Interrupting: {} sampler: {}", (Object)this.threadName, (Object)samp.getName());
                }
                try {
                    boolean found = ((Interruptible)((Object)samp)).interrupt();
                    if (!found) {
                        log.warn("No operation pending");
                    }
                    boolean bl = found;
                    return bl;
                }
                catch (Exception e) {
                    if (log.isWarnEnabled()) {
                        log.warn("Caught Exception interrupting sampler: {}", (Object)e.toString());
                    }
                    break block11;
                }
            }
            if (samp != null && log.isWarnEnabled()) {
                log.warn("Sampler is not Interruptible: {}", (Object)samp.getName());
            }
            break block11;
            finally {
                this.interruptLock.unlock();
            }
        }
        return false;
    }

    private void shutdownTest() {
        this.running = false;
        log.info("Shutdown Test detected by thread: {}", (Object)this.threadName);
        if (this.engine != null) {
            this.engine.askThreadsToStop();
        }
    }

    private void stopTestNow() {
        this.running = false;
        log.info("Stop Test Now detected by thread: {}", (Object)this.threadName);
        if (this.engine != null) {
            this.engine.stopTest();
        }
    }

    private void stopThread() {
        this.running = false;
        log.info("Stop Thread detected by thread: {}", (Object)this.threadName);
    }

    private void checkAssertions(List<Assertion> assertions, SampleResult parent, JMeterContext threadContext) {
        for (Assertion assertion : assertions) {
            TestBeanHelper.prepare((TestElement)((Object)assertion));
            if (assertion instanceof AbstractScopedAssertion) {
                AbstractScopedAssertion scopedAssertion = (AbstractScopedAssertion)((Object)assertion);
                String scope = scopedAssertion.fetchScope();
                if (scopedAssertion.isScopeParent(scope) || scopedAssertion.isScopeAll(scope) || scopedAssertion.isScopeVariable(scope)) {
                    this.processAssertion(parent, assertion);
                }
                if (!scopedAssertion.isScopeChildren(scope) && !scopedAssertion.isScopeAll(scope)) continue;
                SampleResult[] children = parent.getSubResults();
                boolean childError = false;
                for (SampleResult childSampleResult : children) {
                    this.processAssertion(childSampleResult, assertion);
                    if (childSampleResult.isSuccessful()) continue;
                    childError = true;
                }
                if (!childError || !parent.isSuccessful()) continue;
                AssertionResult assertionResult = new AssertionResult(((AbstractTestElement)((Object)assertion)).getName());
                assertionResult.setResultForFailure("One or more sub-samples failed");
                parent.addAssertionResult(assertionResult);
                parent.setSuccessful(false);
                continue;
            }
            this.processAssertion(parent, assertion);
        }
        threadContext.getVariables().put(LAST_SAMPLE_OK, Boolean.toString(parent.isSuccessful()));
    }

    private void processAssertion(SampleResult result, Assertion assertion) {
        AssertionResult assertionResult;
        try {
            assertionResult = assertion.getResult(result);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (JMeterError e) {
            log.error("Error processing Assertion.", (Throwable)e);
            assertionResult = new AssertionResult("Assertion failed! See log file.");
            assertionResult.setError(true);
            assertionResult.setFailureMessage(e.toString());
        }
        catch (Exception e) {
            log.error("Exception processing Assertion.", (Throwable)e);
            assertionResult = new AssertionResult("Assertion failed! See log file.");
            assertionResult.setError(true);
            assertionResult.setFailureMessage(e.toString());
        }
        result.setSuccessful(result.isSuccessful() && !assertionResult.isError() && !assertionResult.isFailure());
        result.addAssertionResult(assertionResult);
    }

    private void runPostProcessors(List<PostProcessor> extractors) {
        for (PostProcessor ex : extractors) {
            TestBeanHelper.prepare((TestElement)((Object)ex));
            ex.process();
        }
    }

    private void runPreProcessors(List<PreProcessor> preProcessors) {
        for (PreProcessor ex : preProcessors) {
            if (log.isDebugEnabled()) {
                log.debug("Running preprocessor: {}", (Object)((AbstractTestElement)((Object)ex)).getName());
            }
            TestBeanHelper.prepare((TestElement)((Object)ex));
            ex.process();
        }
    }

    private void delay(List<Timer> timers) {
        long totalDelay = 0L;
        for (Timer timer : timers) {
            TestBeanHelper.prepare((TestElement)((Object)timer));
            long delay = timer.delay();
            if (APPLY_TIMER_FACTOR && timer.isModifiable()) {
                if (log.isDebugEnabled()) {
                    log.debug("Applying TIMER_FACTOR:{} on timer:{} for thread:{}", new Object[]{Float.valueOf(TIMER_FACTOR), ((TestElement)((Object)timer)).getName(), this.getThreadName()});
                }
                delay = Math.round((float)delay * TIMER_FACTOR);
            }
            totalDelay += delay;
        }
        if (totalDelay > 0L) {
            try {
                if (this.scheduler) {
                    totalDelay = TIMER_SERVICE.adjustDelay(totalDelay, this.endTime);
                }
                TimeUnit.MILLISECONDS.sleep(totalDelay);
            }
            catch (InterruptedException e) {
                log.warn("The delay timer was interrupted - probably did not wait as long as intended.");
                Thread.currentThread().interrupt();
            }
        }
    }

    void notifyTestListeners() {
        this.threadVars.incIteration();
        for (TestIterationListener listener : this.testIterationStartListeners) {
            if (listener instanceof TestElement) {
                listener.testIterationStart(new LoopIterationEvent(this.threadGroupLoopController, this.threadVars.getIteration()));
                ((TestElement)((Object)listener)).recoverRunningVersion();
                continue;
            }
            listener.testIterationStart(new LoopIterationEvent(this.threadGroupLoopController, this.threadVars.getIteration()));
        }
    }

    private void notifyListeners(List<SampleListener> listeners, SampleResult result) {
        SampleEvent event = new SampleEvent(result, this.threadGroup.getName(), this.threadVars);
        this.notifier.notifyListeners(event, listeners);
    }

    public void setInitialDelay(int delay) {
        this.initialDelay = delay;
    }

    private void rampUpDelay() {
        this.delayBy(this.initialDelay, "RampUp");
    }

    protected final void delayBy(long delay, String type) {
        if (delay > 0L) {
            long now;
            long start = System.currentTimeMillis();
            long end = start + delay;
            long pause = RAMPUP_GRANULARITY;
            while (this.running && (now = System.currentTimeMillis()) < end) {
                long togo = end - now;
                if (togo < pause) {
                    pause = togo;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(pause);
                }
                catch (InterruptedException e) {
                    if (this.running) {
                        log.warn("{} delay for {} was interrupted. Waited {} milli-seconds out of {}", new Object[]{type, this.threadName, now - start, delay});
                    }
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    public void setThreadNum(int threadNum) {
        this.threadNum = threadNum;
    }

    public void setEngine(StandardJMeterEngine engine) {
        this.engine = engine;
    }

    public void setOnErrorStopTest(boolean b) {
        this.onErrorStopTest = b;
    }

    public void setOnErrorStopTestNow(boolean b) {
        this.onErrorStopTestNow = b;
    }

    public void setOnErrorStopThread(boolean b) {
        this.onErrorStopThread = b;
    }

    public void setOnErrorStartNextLoop(boolean b) {
        this.onErrorStartNextLoop = b;
    }

    public void setThreadGroup(AbstractThreadGroup group) {
        this.threadGroup = group;
    }

    public ListedHashTree getTestTree() {
        return (ListedHashTree)this.testTree;
    }

    public ListenerNotifier getNotifier() {
        return this.notifier;
    }

    private class IterationListener
    implements LoopIterationListener {
        private IterationListener() {
        }

        @Override
        public void iterationStart(LoopIterationEvent iterEvent) {
            JMeterThread.this.notifyTestListeners();
        }
    }

    private static class ThreadListenerTraverser
    implements HashTreeTraverser {
        private final boolean isStart;

        private ThreadListenerTraverser(boolean start) {
            this.isStart = start;
        }

        public void addNode(Object node, HashTree subTree) {
            if (node instanceof ThreadListener) {
                ThreadListener tl = (ThreadListener)node;
                if (this.isStart) {
                    tl.threadStarted();
                } else {
                    tl.threadFinished();
                }
            }
        }

        public void subtractNode() {
        }

        public void processPath() {
        }
    }
}

