/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.lang.reflect.Constructor;
import org.apache.jmeter.samplers.AsynchSampleSender;
import org.apache.jmeter.samplers.BatchSampleSender;
import org.apache.jmeter.samplers.DataStrippingSampleSender;
import org.apache.jmeter.samplers.DiskStoreSampleSender;
import org.apache.jmeter.samplers.HoldSampleSender;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleSender;
import org.apache.jmeter.samplers.StandardSampleSender;
import org.apache.jmeter.samplers.StatisticalSampleSender;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleSenderFactory {
    private static final Logger log = LoggerFactory.getLogger(SampleSenderFactory.class);
    private static final String MODE_STANDARD = "Standard";
    private static final String MODE_HOLD = "Hold";
    private static final String MODE_BATCH = "Batch";
    private static final String MODE_STATISTICAL = "Statistical";
    private static final String MODE_STRIPPED = "Stripped";
    private static final String MODE_STRIPPED_BATCH = "StrippedBatch";
    private static final String MODE_ASYNCH = "Asynch";
    private static final String MODE_STRIPPED_ASYNCH = "StrippedAsynch";
    private static final String MODE_DISKSTORE = "DiskStore";
    private static final String MODE_STRIPPED_DISKSTORE = "StrippedDiskStore";

    static SampleSender getInstance(RemoteSampleListener listener) {
        boolean holdSamples = JMeterUtils.getPropDefault("hold_samples", false);
        String type = JMeterUtils.getPropDefault("mode", MODE_STRIPPED_BATCH);
        if (holdSamples || type.equalsIgnoreCase(MODE_HOLD)) {
            if (holdSamples) {
                log.warn("Property hold_samples is deprecated and will be removed in upcomping version, use mode={} instead", (Object)MODE_HOLD);
            }
            HoldSampleSender h = new HoldSampleSender(listener);
            return h;
        }
        if (type.equalsIgnoreCase(MODE_BATCH)) {
            BatchSampleSender b = new BatchSampleSender(listener);
            return b;
        }
        if (type.equalsIgnoreCase(MODE_STRIPPED_BATCH)) {
            return new DataStrippingSampleSender(new BatchSampleSender(listener));
        }
        if (type.equalsIgnoreCase(MODE_STATISTICAL)) {
            StatisticalSampleSender s = new StatisticalSampleSender(listener);
            return s;
        }
        if (type.equalsIgnoreCase(MODE_STANDARD)) {
            StandardSampleSender s = new StandardSampleSender(listener);
            return s;
        }
        if (type.equalsIgnoreCase(MODE_STRIPPED)) {
            return new DataStrippingSampleSender(listener);
        }
        if (type.equalsIgnoreCase(MODE_ASYNCH)) {
            return new AsynchSampleSender(listener);
        }
        if (type.equalsIgnoreCase(MODE_STRIPPED_ASYNCH)) {
            return new DataStrippingSampleSender(new AsynchSampleSender(listener));
        }
        if (type.equalsIgnoreCase(MODE_DISKSTORE)) {
            return new DiskStoreSampleSender(listener);
        }
        if (type.equalsIgnoreCase(MODE_STRIPPED_DISKSTORE)) {
            return new DataStrippingSampleSender(new DiskStoreSampleSender(listener));
        }
        SampleSender s = null;
        try {
            Class<?> clazz = Class.forName(type);
            Constructor<?> cons = clazz.getConstructor(RemoteSampleListener.class);
            s = (SampleSender)cons.newInstance(listener);
        }
        catch (Exception e) {
            log.error("Unable to create a sample sender from class:'{}', search for mode property in jmeter.properties for correct configuration options", (Object)type);
            throw new IllegalArgumentException("Unable to create a sample sender from mode or class:'" + type + "', search for mode property in jmeter.properties for correct configuration options, message:" + e.getMessage(), e);
        }
        return s;
    }
}

