/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.processor.AbstractSummaryConsumer;
import org.apache.jmeter.report.processor.ErrorsSummaryConsumer;
import org.apache.jmeter.report.processor.ListResultData;
import org.apache.jmeter.report.processor.Top5ErrorsSummaryData;
import org.apache.jmeter.report.processor.ValueResultData;
import org.apache.jmeter.util.JMeterUtils;

public class Top5ErrorsBySamplerConsumer
extends AbstractSummaryConsumer<Top5ErrorsSummaryData> {
    static final int MAX_NUMBER_OF_ERRORS_IN_TOP = 5;
    private boolean ignoreTCFromTop5ErrorsBySampler;

    public Top5ErrorsBySamplerConsumer() {
        super(false);
    }

    private void aggregateSample(Sample sample, Top5ErrorsSummaryData data, boolean isOverall) {
        if (isOverall && sample.isController()) {
            return;
        }
        if (this.ignoreTCFromTop5ErrorsBySampler && sample.isController()) {
            return;
        }
        if (!sample.getSuccess()) {
            data.registerError(this.getError(sample));
            data.incErrors();
        }
        data.incTotal();
    }

    private String getError(Sample sample) {
        String responseCode = sample.getResponseCode();
        String responseMessage = sample.getResponseMessage();
        String key = responseCode + (!StringUtils.isEmpty((CharSequence)responseMessage) ? "/" + StringEscapeUtils.escapeJson((String)responseMessage) : "");
        if (ErrorsSummaryConsumer.isSuccessCode(responseCode)) {
            String msg;
            key = "Assertion failed";
            if (ErrorsSummaryConsumer.ASSERTION_RESULTS_FAILURE_MESSAGE && !StringUtils.isEmpty((CharSequence)(msg = sample.getFailureMessage()))) {
                key = StringEscapeUtils.escapeJson((String)msg);
            }
        }
        return key;
    }

    @Override
    protected void updateData(AbstractSummaryConsumer.SummaryInfo info, Sample sample) {
        Top5ErrorsSummaryData data;
        AbstractSummaryConsumer.SummaryInfo overallInfo = this.getOverallInfo();
        Top5ErrorsSummaryData overallData = (Top5ErrorsSummaryData)overallInfo.getData();
        if (overallData == null) {
            overallData = new Top5ErrorsSummaryData();
            overallInfo.setData(overallData);
        }
        if ((data = (Top5ErrorsSummaryData)info.getData()) == null) {
            data = new Top5ErrorsSummaryData();
            info.setData(data);
        }
        if (!sample.isEmptyController()) {
            this.aggregateSample(sample, data, false);
            this.aggregateSample(sample, overallData, true);
        }
    }

    @Override
    protected ListResultData createDataResult(String key, Top5ErrorsSummaryData data) {
        ListResultData result = new ListResultData();
        long errors = data.getErrors();
        if (errors > 0L || key == null) {
            int i;
            result.addResult(new ValueResultData(key != null ? key : JMeterUtils.getResString("reportgenerator_top5_total")));
            long total = data.getTotal();
            result.addResult(new ValueResultData(total));
            result.addResult(new ValueResultData(errors));
            Object[][] top5 = data.getTop5ErrorsMetrics();
            int numberOfValues = 0;
            for (i = 0; i < top5.length; ++i) {
                result.addResult(new ValueResultData(top5[i][0]));
                result.addResult(new ValueResultData(top5[i][1]));
                ++numberOfValues;
            }
            for (i = numberOfValues; i < 5; ++i) {
                result.addResult(new ValueResultData(""));
                result.addResult(new ValueResultData(""));
            }
        }
        return result;
    }

    @Override
    protected String getKeyFromSample(Sample sample) {
        return sample.getName();
    }

    @Override
    protected ListResultData createResultTitles() {
        ListResultData titles = new ListResultData();
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_top5_label")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_top5_sample_count")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_top5_error_count")));
        for (int i = 0; i < 5; ++i) {
            titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_top5_error_label")));
            titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_top5_error_count")));
        }
        return titles;
    }

    public void setIgnoreTransactionController(boolean ignoreTCFromTop5ErrorsBySampler) {
        this.ignoreTCFromTop5ErrorsBySampler = ignoreTCFromTop5ErrorsBySampler;
    }
}

