/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action.template;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.action.template.Template;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateManager {
    private static final String TEMPLATE_FILES = JMeterUtils.getPropDefault("template.files", "/bin/templates/templates.xml");
    private static final Logger log = LoggerFactory.getLogger(TemplateManager.class);
    private static final TemplateManager SINGLETON = new TemplateManager();
    private final Map<String, Template> allTemplates;
    private final XStream xstream = this.initXStream();

    public static TemplateManager getInstance() {
        return SINGLETON;
    }

    private TemplateManager() {
        this.allTemplates = this.readTemplates();
    }

    private XStream initXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver(){

            protected DocumentBuilderFactory createDocumentBuilderFactory() {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                }
                catch (ParserConfigurationException e) {
                    throw new StreamException((Throwable)e);
                }
                factory.setExpandEntityReferences(false);
                return factory;
            }
        });
        xstream.alias("template", Template.class);
        xstream.alias("templates", Templates.class);
        xstream.useAttributeFor(Template.class, "isTestPlan");
        xstream.addImplicitMap(Templates.class, "templates", Template.class, "name");
        return xstream;
    }

    public void addTemplate(Template template) {
        this.allTemplates.put(template.getName(), template);
    }

    public TemplateManager reset() {
        this.allTemplates.clear();
        this.allTemplates.putAll(this.readTemplates());
        return this;
    }

    public String[] getTemplateNames() {
        return this.allTemplates.keySet().toArray(new String[this.allTemplates.size()]);
    }

    private Map<String, Template> readTemplates() {
        String[] templateFiles;
        LinkedHashMap<String, Template> temps = new LinkedHashMap<String, Template>();
        for (String templateFile : templateFiles = TEMPLATE_FILES.split(",")) {
            if (StringUtils.isEmpty((CharSequence)templateFile)) continue;
            File f = new File(JMeterUtils.getJMeterHome(), templateFile);
            try {
                if (f.exists() && f.canRead()) {
                    if (log.isInfoEnabled()) {
                        log.info("Reading templates from: {}", (Object)f.getAbsolutePath());
                    }
                    File parent = f.getParentFile();
                    LinkedHashMap templates = ((Templates)this.xstream.fromXML(f)).templates;
                    for (Template t : templates.values()) {
                        if (t.getFileName().startsWith("/")) continue;
                        t.setParent(parent);
                    }
                    temps.putAll(templates);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn("Ignoring template file:'{}' as it does not exist or is not readable", (Object)f.getAbsolutePath());
            }
            catch (Exception ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn("Ignoring template file:'{}', an error occured parsing the file", (Object)f.getAbsolutePath(), (Object)ex);
            }
        }
        return temps;
    }

    public Template getTemplateByName(String selectedTemplate) {
        return this.allTemplates.get(selectedTemplate);
    }

    private static class Templates {
        private final LinkedHashMap<String, Template> templates = new LinkedHashMap();

        private Templates() {
        }
    }
}

