/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.csv;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.csv.CSVReader;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nonnull;

public class CSVIterator
implements Iterator<ICommonsList<String>> {
    private final CSVReader m_aReader;
    private ICommonsList<String> m_aNextLine;

    public CSVIterator(@Nonnull CSVReader cSVReader) throws IOException {
        ValueEnforcer.notNull(cSVReader, "Reader");
        this.m_aReader = cSVReader;
        this.m_aNextLine = cSVReader.readNext();
    }

    @Override
    public boolean hasNext() {
        return this.m_aNextLine != null;
    }

    @Override
    @Nonnull
    public ICommonsList<String> next() {
        ICommonsList<String> iCommonsList = this.m_aNextLine;
        try {
            this.m_aNextLine = this.m_aReader.readNext();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to read next CSV line", iOException);
        }
        return iCommonsList;
    }
}

