/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader.errorhandler;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.Token;
import com.helger.css.reader.errorhandler.CSSParseError;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CollectingCSSParseErrorHandler
implements ICSSParseErrorHandler {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<CSSParseError> m_aErrors = new CommonsArrayList();

    @Override
    public void onCSSParseError(@Nonnull ParseException parseException, @Nullable Token token) throws ParseException {
        this.m_aRWLock.writeLocked(() -> {
            if (parseException.expectedTokenSequences == null) {
                this.m_aErrors.add((Object)new CSSParseError(parseException.getMessage()));
            } else {
                this.m_aErrors.add((Object)new CSSParseError(parseException.currentToken, parseException.expectedTokenSequences, parseException.tokenImage, token));
            }
        });
    }

    @Override
    public void onCSSUnexpectedRule(@Nonnull Token token, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) throws ParseException {
        this.m_aRWLock.writeLocked(() -> this.m_aErrors.add((Object)CSSParseError.createUnexpectedRule(token, string, string2)));
    }

    @Override
    public void onCSSBrowserCompliantSkip(@Nullable ParseException parseException, @Nonnull Token token, @Nonnull Token token2) throws ParseException {
        this.m_aRWLock.writeLocked(() -> this.m_aErrors.add((Object)CSSParseError.createBrowserCompliantSkip(parseException, token, token2)));
    }

    @Override
    public void onIllegalCharacter(char c) {
        this.m_aRWLock.writeLocked(() -> this.m_aErrors.add((Object)CSSParseError.createIllegalCharacter(c)));
    }

    @Nonnegative
    public boolean hasParseErrors() {
        return this.m_aRWLock.readLocked(() -> this.m_aErrors.isNotEmpty());
    }

    @Nonnegative
    public int getParseErrorCount() {
        return this.m_aRWLock.readLocked(() -> this.m_aErrors.size());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSParseError> getAllParseErrors() {
        return (ICommonsList)this.m_aRWLock.readLocked(() -> (ICommonsList)this.m_aErrors.getClone());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("errors", this.m_aErrors).toString();
    }
}

