/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.MIME;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultClientConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.BufferedHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.CharArrayBuffer;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.protocol.http.control.Authorization;
import org.apache.jmeter.protocol.http.control.CacheManager;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.control.DNSCacheManager;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.sampler.HTTPHCAbstractImpl;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HttpClientDefaultParameters;
import org.apache.jmeter.protocol.http.sampler.HttpWebdav;
import org.apache.jmeter.protocol.http.sampler.LazySchemeSocketFactory;
import org.apache.jmeter.protocol.http.sampler.MeasuringConnectionManager;
import org.apache.jmeter.protocol.http.util.EncoderCache;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.protocol.http.util.HTTPFileArg;
import org.apache.jmeter.protocol.http.util.SlowHC4SocketFactory;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.JsseSSLManager;
import org.apache.jmeter.util.SSLManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPHC4Impl
extends HTTPHCAbstractImpl {
    private static final int MAX_BODY_RETAIN_SIZE = JMeterUtils.getPropDefault((String)"httpclient4.max_body_retain_size", (int)32768);
    private static final Logger log = LoggerFactory.getLogger(HTTPHC4Impl.class);
    private static final int RETRY_COUNT = JMeterUtils.getPropDefault((String)"httpclient4.retrycount", (int)0);
    private static final boolean REQUEST_SENT_RETRY_ENABLED = JMeterUtils.getPropDefault((String)"httpclient4.request_sent_retry_enabled", (boolean)false);
    private static final int IDLE_TIMEOUT = JMeterUtils.getPropDefault((String)"httpclient4.idletimeout", (int)0);
    private static final int VALIDITY_AFTER_INACTIVITY_TIMEOUT = JMeterUtils.getPropDefault((String)"httpclient4.validate_after_inactivity", (int)1700);
    private static final int TIME_TO_LIVE = JMeterUtils.getPropDefault((String)"httpclient4.time_to_live", (int)2000);
    private static final boolean BASIC_AUTH_PREEMPTIVE = JMeterUtils.getPropDefault((String)"httpclient4.auth.preemptive", (boolean)true);
    private static final String CONTEXT_METRICS = "jmeter_metrics";
    private static final Pattern PORT_PATTERN = Pattern.compile("\\d+");
    private static final ConnectionKeepAliveStrategy IDLE_STRATEGY = new DefaultConnectionKeepAliveStrategy(){

        public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
            long duration = super.getKeepAliveDuration(response, context);
            if (duration <= 0L && IDLE_TIMEOUT > 0) {
                log.debug("Setting keepalive to {}", (Object)IDLE_TIMEOUT);
                return IDLE_TIMEOUT;
            }
            return duration;
        }
    };
    private static final HttpResponseInterceptor METRICS_SAVER = (response, context) -> {
        HttpConnectionMetrics metrics = ((HttpConnection)context.getAttribute("http.connection")).getMetrics();
        context.setAttribute(CONTEXT_METRICS, (Object)metrics);
    };
    private static final HttpRequestInterceptor METRICS_RESETTER = (request, context) -> {
        HttpConnectionMetrics metrics = ((HttpConnection)context.getAttribute("http.connection")).getMetrics();
        metrics.reset();
    };
    private static final String[] HEADERS_TO_SAVE = new String[]{"content-length", "content-encoding", "content-md5"};
    private static final HttpResponseInterceptor RESPONSE_CONTENT_ENCODING = new ResponseContentEncoding(){

        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            org.apache.http.Header ceheader;
            ArrayList<org.apache.http.Header[]> headersToSave = null;
            HttpEntity entity = response.getEntity();
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            RequestConfig requestConfig = clientContext.getRequestConfig();
            if (requestConfig.isContentCompressionEnabled() && entity != null && entity.getContentLength() != 0L && (ceheader = entity.getContentEncoding()) != null) {
                headersToSave = new ArrayList<org.apache.http.Header[]>(3);
                for (String name : HEADERS_TO_SAVE) {
                    org.apache.http.Header[] hdr = response.getHeaders(name);
                    headersToSave.add(hdr);
                }
            }
            super.process(response, (HttpContext)clientContext);
            if (headersToSave != null) {
                Iterator iterator = headersToSave.iterator();
                while (iterator.hasNext()) {
                    org.apache.http.Header[] headers;
                    for (org.apache.http.Header headerToRestore : headers = (org.apache.http.Header[])iterator.next()) {
                        if (response.containsHeader(headerToRestore.getName())) break;
                        response.addHeader(headerToRestore);
                    }
                }
            }
        }
    };
    private static final ThreadLocal<Map<HttpClientKey, CloseableHttpClient>> HTTPCLIENTS_CACHE_PER_THREAD_AND_HTTPCLIENTKEY = InheritableThreadLocal.withInitial(() -> new HashMap(5));
    private static final Scheme SLOW_HTTP;
    private static final HttpParams DEFAULT_HTTP_PARAMS;
    private static final String USER_TOKEN = "__jmeter.USER_TOKEN__";
    static final String SAMPLER_RESULT_TOKEN = "__jmeter.SAMPLER_RESULT__";
    private static final String HTTPCLIENT_TOKEN = "__jmeter.HTTPCLIENT_TOKEN__";
    private volatile HttpUriRequest currentRequest;
    private volatile boolean resetSSLContext;

    protected HTTPHC4Impl(HTTPSamplerBase testElement) {
        super(testElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected HTTPSampleResult sample(URL url, String method, boolean areFollowingRedirect, int frameDepth) {
        if (log.isDebugEnabled()) {
            log.debug("Start : sample {} method {} followingRedirect {} depth {}", new Object[]{url, method, areFollowingRedirect, frameDepth});
        }
        HTTPSampleResult res = this.createSampleResult(url, method);
        CloseableHttpClient httpClient = this.setupClient(url);
        Object httpRequest = null;
        try {
            URI uri = url.toURI();
            if (method.equals("POST")) {
                httpRequest = new HttpPost(uri);
            } else if (method.equals("GET")) {
                httpRequest = !areFollowingRedirect && (!this.hasArguments() && this.getSendFileAsPostBody() || this.getSendParameterValuesAsPostBody()) ? new HttpGetWithEntity(uri) : new HttpGet(uri);
            } else if (method.equals("PUT")) {
                httpRequest = new HttpPut(uri);
            } else if (method.equals("HEAD")) {
                httpRequest = new HttpHead(uri);
            } else if (method.equals("TRACE")) {
                httpRequest = new HttpTrace(uri);
            } else if (method.equals("OPTIONS")) {
                httpRequest = new HttpOptions(uri);
            } else if (method.equals("DELETE")) {
                httpRequest = new HttpDelete(uri);
            } else if (method.equals("PATCH")) {
                httpRequest = new HttpPatch(uri);
            } else if (HttpWebdav.isWebdavMethod(method)) {
                httpRequest = new HttpWebdav(method, uri);
            } else {
                throw new IllegalArgumentException("Unexpected method: '" + method + "'");
            }
            this.setupRequest(url, (HttpRequestBase)httpRequest, res);
        }
        catch (Exception e) {
            res.sampleStart();
            res.sampleEnd();
            this.errorResult(e, res);
            return res;
        }
        BasicHttpContext localContext = new BasicHttpContext();
        this.setupClientContextBeforeSample((HttpContext)localContext);
        res.sampleStart();
        CacheManager cacheManager = this.getCacheManager();
        if (cacheManager != null && "GET".equalsIgnoreCase(method) && cacheManager.inCache(url)) {
            return this.updateSampleResultForResourceInCache(res);
        }
        CloseableHttpResponse httpResponse = null;
        try {
            HttpEntity entity;
            this.currentRequest = httpRequest;
            this.handleMethod(method, res, (HttpRequestBase)httpRequest, (HttpContext)localContext);
            localContext.setAttribute(SAMPLER_RESULT_TOKEN, (Object)res);
            httpResponse = this.executeRequest(httpClient, (HttpRequestBase)httpRequest, (HttpContext)localContext, url);
            HttpRequest request = (HttpRequest)localContext.getAttribute("http.request");
            this.extractClientContextAfterSample((HttpContext)localContext);
            InetAddress localAddr = (InetAddress)httpRequest.getParams().getParameter("http.route.local-address");
            if (localAddr != null) {
                request.addHeader("X-LocalAddress", localAddr.toString());
            }
            res.setRequestHeaders(this.getConnectionHeaders(request));
            org.apache.http.Header contentType = httpResponse.getLastHeader("Content-Type");
            if (contentType != null) {
                String ct = contentType.getValue();
                res.setContentType(ct);
                res.setEncodingAndType(ct);
            }
            if ((entity = httpResponse.getEntity()) != null) {
                res.setResponseData(this.readResponse((SampleResult)res, entity.getContent(), entity.getContentLength()));
            }
            res.sampleEnd();
            this.currentRequest = null;
            StatusLine statusLine = httpResponse.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            res.setResponseCode(Integer.toString(statusCode));
            res.setResponseMessage(statusLine.getReasonPhrase());
            res.setSuccessful(this.isSuccessCode(statusCode));
            res.setResponseHeaders(this.getResponseHeaders((HttpResponse)httpResponse, (HttpContext)localContext));
            if (res.isRedirect()) {
                org.apache.http.Header headerLocation = httpResponse.getLastHeader("Location");
                if (headerLocation == null) {
                    throw new IllegalArgumentException("Missing location header in redirect for " + httpRequest.getRequestLine());
                }
                String redirectLocation = headerLocation.getValue();
                res.setRedirectLocation(redirectLocation);
            }
            HttpConnectionMetrics metrics = (HttpConnectionMetrics)localContext.getAttribute(CONTEXT_METRICS);
            long headerBytes = (long)res.getResponseHeaders().length() + (long)httpResponse.getAllHeaders().length + 1L + 2L;
            long totalBytes = metrics.getReceivedBytesCount();
            res.setHeadersSize((int)headerBytes);
            res.setBodySize(totalBytes - headerBytes);
            res.setSentBytes(metrics.getSentBytesCount());
            if (log.isDebugEnabled()) {
                log.debug("ResponseHeadersSize={} Content-Length={} Total={}", new Object[]{res.getHeadersSize(), res.getBodySizeAsLong(), (long)res.getHeadersSize() + res.getBodySizeAsLong()});
            }
            if (this.getAutoRedirects()) {
                HttpUriRequest req = (HttpUriRequest)localContext.getAttribute("http.request");
                HttpHost target = (HttpHost)localContext.getAttribute("http.target_host");
                URI redirectURI = req.getURI();
                if (redirectURI.isAbsolute()) {
                    res.setURL(redirectURI.toURL());
                } else {
                    res.setURL(new URL(new URL(target.toURI()), redirectURI.toString()));
                }
            }
            this.saveConnectionCookies((HttpResponse)httpResponse, res.getURL(), this.getCookieManager());
            if (cacheManager != null) {
                cacheManager.saveDetails((HttpResponse)httpResponse, res);
            }
            res = this.resultProcessing(areFollowingRedirect, frameDepth, res);
        }
        catch (IOException e) {
            log.debug("IOException", (Throwable)e);
            if (res.getEndTime() == 0L) {
                res.sampleEnd();
            }
            if (res.getRequestHeaders() != null) {
                log.debug("Overwriting request old headers: {}", (Object)res.getRequestHeaders());
            }
            res.setRequestHeaders(this.getConnectionHeaders((HttpRequest)localContext.getAttribute("http.request")));
            this.errorResult(e, res);
            HTTPSampleResult hTTPSampleResult = res;
            JOrphanUtils.closeQuietly((Closeable)httpResponse);
            this.currentRequest = null;
            JMeterContextService.getContext().getSamplerContext().remove(HTTPCLIENT_TOKEN);
            return hTTPSampleResult;
        }
        catch (RuntimeException e2) {
            log.debug("RuntimeException", (Throwable)e2);
            if (res.getEndTime() == 0L) {
                res.sampleEnd();
            }
            this.errorResult(e2, res);
            HTTPSampleResult hTTPSampleResult = res;
            {
                catch (Throwable throwable) {
                    JOrphanUtils.closeQuietly(httpResponse);
                    this.currentRequest = null;
                    JMeterContextService.getContext().getSamplerContext().remove(HTTPCLIENT_TOKEN);
                    throw throwable;
                }
            }
            JOrphanUtils.closeQuietly((Closeable)httpResponse);
            this.currentRequest = null;
            JMeterContextService.getContext().getSamplerContext().remove(HTTPCLIENT_TOKEN);
            return hTTPSampleResult;
        }
        JOrphanUtils.closeQuietly((Closeable)httpResponse);
        this.currentRequest = null;
        JMeterContextService.getContext().getSamplerContext().remove(HTTPCLIENT_TOKEN);
        return res;
    }

    private void extractClientContextAfterSample(HttpContext localContext) {
        Object userToken = localContext.getAttribute("http.user-token");
        if (userToken != null) {
            log.debug("Extracted from HttpContext user token:{} storing it as JMeter variable:{}", userToken, (Object)USER_TOKEN);
            JMeterVariables jMeterVariables = JMeterContextService.getContext().getVariables();
            if (jMeterVariables != null) {
                jMeterVariables.putObject(USER_TOKEN, userToken);
            }
        }
    }

    private void setupClientContextBeforeSample(HttpContext localContext) {
        Object userToken = null;
        JMeterVariables jMeterVariables = JMeterContextService.getContext().getVariables();
        if (jMeterVariables != null) {
            userToken = jMeterVariables.getObject(USER_TOKEN);
        }
        if (userToken != null) {
            log.debug("Found user token:{} as JMeter variable:{}, storing it in HttpContext", userToken, (Object)USER_TOKEN);
            localContext.setAttribute("http.user-token", userToken);
        } else {
            String userId = Thread.currentThread().getName();
            log.debug("Storing in HttpContext the user token: {}", (Object)userId);
            localContext.setAttribute("http.user-token", (Object)userId);
        }
    }

    protected void handleMethod(String method, HTTPSampleResult result, HttpRequestBase httpRequest, HttpContext localContext) throws IOException {
        if (httpRequest instanceof HttpPost) {
            String postBody = this.sendPostData((HttpPost)httpRequest);
            result.setQueryString(postBody);
        } else if (httpRequest instanceof HttpEntityEnclosingRequestBase) {
            String entityBody = this.sendEntityData((HttpEntityEnclosingRequestBase)httpRequest);
            result.setQueryString(entityBody);
        }
    }

    protected HTTPSampleResult createSampleResult(URL url, String method) {
        HTTPSampleResult res = new HTTPSampleResult();
        res.setSampleLabel(url.toString());
        res.setHTTPMethod(method);
        res.setURL(url);
        return res;
    }

    private CloseableHttpResponse executeRequest(CloseableHttpClient httpClient, HttpRequestBase httpRequest, HttpContext localContext, URL url) throws IOException, ClientProtocolException {
        AuthManager authManager = this.getAuthManager();
        if (authManager != null) {
            Authorization authorization;
            Subject subject = authManager.getSubjectForUrl(url);
            if (subject != null) {
                try {
                    return Subject.doAs(subject, () -> httpClient.execute((HttpUriRequest)httpRequest, localContext));
                }
                catch (PrivilegedActionException e) {
                    log.error("Can't execute httpRequest with subject: {}", (Object)subject, (Object)e);
                    throw new RuntimeException("Can't execute httpRequest with subject:" + subject, e);
                }
            }
            if (BASIC_AUTH_PREEMPTIVE && (authorization = authManager.getAuthForURL(url)) != null && AuthManager.Mechanism.BASIC_DIGEST.equals((Object)authorization.getMechanism())) {
                HttpHost target = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(target, (AuthScheme)basicAuth);
                localContext.setAttribute("http.auth.auth-cache", (Object)authCache);
            }
        }
        return httpClient.execute((HttpUriRequest)httpRequest, localContext);
    }

    private CloseableHttpClient setupClient(URL url) {
        boolean useProxy;
        Map<HttpClientKey, CloseableHttpClient> mapHttpClientPerHttpClientKey = HTTPCLIENTS_CACHE_PER_THREAD_AND_HTTPCLIENTKEY.get();
        String host = url.getHost();
        String proxyHost = this.getProxyHost();
        int proxyPort = this.getProxyPortInt();
        String proxyPass = this.getProxyPass();
        String proxyUser = this.getProxyUser();
        boolean useStaticProxy = HTTPHC4Impl.isStaticProxy(host);
        boolean useDynamicProxy = this.isDynamicProxy(proxyHost, proxyPort);
        boolean bl = useProxy = useStaticProxy || useDynamicProxy;
        if (!useDynamicProxy) {
            proxyHost = PROXY_HOST;
            proxyPort = PROXY_PORT;
            proxyUser = PROXY_USER;
            proxyPass = PROXY_PASS;
        }
        HttpClientKey key = new HttpClientKey(url, useProxy, proxyHost, proxyPort, proxyUser, proxyPass);
        Object httpClient = null;
        boolean concurrentDwn = this.testElement.isConcurrentDwn();
        if (concurrentDwn) {
            httpClient = (CloseableHttpClient)JMeterContextService.getContext().getSamplerContext().get(HTTPCLIENT_TOKEN);
        }
        if (httpClient == null) {
            httpClient = mapHttpClientPerHttpClientKey.get(key);
        }
        if (httpClient != null && this.resetSSLContext && "https".equalsIgnoreCase(url.getProtocol())) {
            ((AbstractHttpClient)httpClient).clearRequestInterceptors();
            ((AbstractHttpClient)httpClient).clearResponseInterceptors();
            httpClient.getConnectionManager().closeIdleConnections(1L, TimeUnit.MICROSECONDS);
            httpClient = null;
            JsseSSLManager sslMgr = (JsseSSLManager)SSLManager.getInstance();
            sslMgr.resetContext();
            this.resetSSLContext = false;
        }
        if (httpClient == null) {
            DefaultedHttpParams clientParams = new DefaultedHttpParams((HttpParams)new BasicHttpParams(), DEFAULT_HTTP_PARAMS);
            DNSCacheManager resolver = this.testElement.getDNSResolver();
            if (resolver == null) {
                resolver = SystemDefaultDnsResolver.INSTANCE;
            }
            MeasuringConnectionManager connManager = new MeasuringConnectionManager(HTTPHC4Impl.createSchemeRegistry(), resolver, TIME_TO_LIVE, VALIDITY_AFTER_INACTIVITY_TIMEOUT);
            if (concurrentDwn) {
                try {
                    int maxConcurrentDownloads = Integer.parseInt(this.testElement.getConcurrentPool());
                    connManager.setDefaultMaxPerRoute(Math.max(maxConcurrentDownloads, connManager.getDefaultMaxPerRoute()));
                }
                catch (NumberFormatException maxConcurrentDownloads) {
                    // empty catch block
                }
            }
            httpClient = new DefaultHttpClient(connManager, (HttpParams)clientParams){

                protected HttpRequestRetryHandler createHttpRequestRetryHandler() {
                    return new StandardHttpRequestRetryHandler(RETRY_COUNT, REQUEST_SENT_RETRY_ENABLED);
                }
            };
            if (IDLE_TIMEOUT > 0) {
                ((AbstractHttpClient)httpClient).setKeepAliveStrategy(IDLE_STRATEGY);
            }
            ((AbstractHttpClient)httpClient).setReuseStrategy((ConnectionReuseStrategy)DefaultClientConnectionReuseStrategy.INSTANCE);
            ((AbstractHttpClient)httpClient).addResponseInterceptor(RESPONSE_CONTENT_ENCODING);
            ((AbstractHttpClient)httpClient).addResponseInterceptor(METRICS_SAVER);
            ((AbstractHttpClient)httpClient).addRequestInterceptor(METRICS_RESETTER);
            SchemeRegistry schemeRegistry = httpClient.getConnectionManager().getSchemeRegistry();
            if (SLOW_HTTP != null) {
                schemeRegistry.register(SLOW_HTTP);
            }
            if (useProxy) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                clientParams.setParameter("http.route.default-proxy", (Object)proxy);
                if (proxyUser.length() > 0) {
                    ((AbstractHttpClient)httpClient).getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUser, proxyPass, LOCALHOST, PROXY_DOMAIN));
                }
            }
            clientParams.setParameter("http.protocol.cookie-policy", (Object)"ignoreCookies");
            if (log.isDebugEnabled()) {
                log.debug("Created new HttpClient: @" + System.identityHashCode(httpClient) + " " + key.toString());
            }
            mapHttpClientPerHttpClientKey.put(key, (CloseableHttpClient)httpClient);
        } else if (log.isDebugEnabled()) {
            log.debug("Reusing the HttpClient: @" + System.identityHashCode(httpClient) + " " + key.toString());
        }
        if (concurrentDwn) {
            JMeterContextService.getContext().getSamplerContext().put(HTTPCLIENT_TOKEN, httpClient);
        }
        this.setConnectionAuthorization((CloseableHttpClient)httpClient, url, this.getAuthManager(), key);
        return httpClient;
    }

    private static SchemeRegistry createSchemeRegistry() {
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        registry.register(new Scheme("https", 443, (SchemeSocketFactory)new LazySchemeSocketFactory()));
        return registry;
    }

    protected void setupRequest(URL url, HttpRequestBase httpRequest, HTTPSampleResult res) throws IOException {
        int cto;
        HttpParams requestParams = httpRequest.getParams();
        InetAddress inetAddr = this.getIpSourceAddress();
        if (inetAddr != null) {
            requestParams.setParameter("http.route.local-address", (Object)inetAddr);
        } else if (localAddress != null) {
            requestParams.setParameter("http.route.local-address", (Object)localAddress);
        } else {
            requestParams.removeParameter("http.route.local-address");
        }
        int rto = this.getResponseTimeout();
        if (rto > 0) {
            requestParams.setIntParameter("http.socket.timeout", rto);
        }
        if ((cto = this.getConnectTimeout()) > 0) {
            requestParams.setIntParameter("http.connection.timeout", cto);
        }
        requestParams.setBooleanParameter("http.protocol.handle-redirects", this.getAutoRedirects());
        if (this.getUseKeepAlive()) {
            httpRequest.setHeader("Connection", "keep-alive");
        } else {
            httpRequest.setHeader("Connection", "close");
        }
        this.setConnectionHeaders(httpRequest, url, this.getHeaderManager(), this.getCacheManager());
        String cookies = this.setConnectionCookie((HttpRequest)httpRequest, url, this.getCookieManager());
        if (res != null) {
            res.setCookies(cookies);
        }
    }

    protected void setDefaultRequestHeaders(HttpRequest request) {
    }

    private String getResponseHeaders(HttpResponse response, HttpContext localContext) {
        org.apache.http.Header[] rh = response.getAllHeaders();
        StringBuilder headerBuf = new StringBuilder(40 * (rh.length + 1));
        headerBuf.append(response.getStatusLine());
        headerBuf.append("\n");
        for (org.apache.http.Header responseHeader : rh) {
            this.writeResponseHeader(headerBuf, responseHeader);
        }
        return headerBuf.toString();
    }

    private void writeResponseHeader(StringBuilder headerBuffer, org.apache.http.Header responseHeader) {
        if (responseHeader instanceof BufferedHeader) {
            CharArrayBuffer buffer = ((BufferedHeader)responseHeader).getBuffer();
            headerBuffer.append(buffer.buffer(), 0, buffer.length()).append('\n');
        } else {
            headerBuffer.append(responseHeader.getName()).append(": ").append(responseHeader.getValue()).append('\n');
        }
    }

    protected String setConnectionCookie(HttpRequest request, URL url, CookieManager cookieManager) {
        String cookieHeader = null;
        if (cookieManager != null && (cookieHeader = cookieManager.getCookieHeaderForURL(url)) != null) {
            request.setHeader("Cookie", cookieHeader);
        }
        return cookieHeader;
    }

    protected void setConnectionHeaders(HttpRequestBase request, URL url, HeaderManager headerManager, CacheManager cacheManager) {
        CollectionProperty headers;
        if (headerManager != null && (headers = headerManager.getHeaders()) != null) {
            for (JMeterProperty jMeterProperty : headers) {
                Header header = (Header)jMeterProperty.getObjectValue();
                String n = header.getName();
                if ("Content-Length".equalsIgnoreCase(n)) continue;
                String v = header.getValue();
                if ("Host".equalsIgnoreCase(n)) {
                    int port = this.getPortFromHostHeader(v, url.getPort());
                    v = v.replaceFirst(":\\d+$", "");
                    if (port != -1 && port == url.getDefaultPort()) {
                        port = -1;
                    }
                    request.getParams().setParameter("http.virtual-host", (Object)new HttpHost(v, port));
                    continue;
                }
                request.addHeader(n, v);
            }
        }
        if (cacheManager != null) {
            cacheManager.setHeaders(url, request);
        }
    }

    private int getPortFromHostHeader(String hostHeaderValue, int defaultValue) {
        String portString;
        String[] hostParts = hostHeaderValue.split(":");
        if (hostParts.length > 1 && PORT_PATTERN.matcher(portString = hostParts[hostParts.length - 1]).matches()) {
            return Integer.parseInt(portString);
        }
        return defaultValue;
    }

    private String getConnectionHeaders(HttpRequest method) {
        if (method != null) {
            org.apache.http.Header[] requestHeaders;
            StringBuilder hdrs = new StringBuilder(150);
            for (org.apache.http.Header requestHeader : requestHeaders = method.getAllHeaders()) {
                if ("Cookie".equalsIgnoreCase(requestHeader.getName())) continue;
                this.writeResponseHeader(hdrs, requestHeader);
            }
            return hdrs.toString();
        }
        return "";
    }

    private void setConnectionAuthorization(CloseableHttpClient client, URL url, AuthManager authManager, HttpClientKey key) {
        CredentialsProvider credentialsProvider = ((AbstractHttpClient)client).getCredentialsProvider();
        if (authManager != null) {
            if (authManager.hasAuthForURL(url)) {
                authManager.setupCredentials((HttpClient)client, url, credentialsProvider, LOCALHOST);
            } else {
                credentialsProvider.clear();
            }
        } else {
            Credentials credentials = null;
            AuthScope authScope = null;
            if (key.hasProxy && !StringUtils.isEmpty((CharSequence)key.proxyUser)) {
                authScope = new AuthScope(key.proxyHost, key.proxyPort);
                credentials = credentialsProvider.getCredentials(authScope);
            }
            credentialsProvider.clear();
            if (credentials != null) {
                credentialsProvider.setCredentials(authScope, credentials);
            }
        }
    }

    protected String sendPostData(HttpPost post) throws IOException {
        boolean haveContentEncoding;
        StringBuilder postedBody = new StringBuilder(1000);
        HTTPFileArg[] files = this.getHTTPFiles();
        String contentEncoding = this.getContentEncodingOrNull();
        boolean bl = haveContentEncoding = contentEncoding != null;
        if (this.getUseMultipartForPost()) {
            Charset charset = null;
            charset = haveContentEncoding ? Charset.forName(contentEncoding) : MIME.DEFAULT_CHARSET;
            if (log.isDebugEnabled()) {
                log.debug("Building multipart with:getDoBrowserCompatibleMultipart(): {}, with charset:{}, haveContentEncoding:{}", new Object[]{this.getDoBrowserCompatibleMultipart(), charset, haveContentEncoding});
            }
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setCharset(charset);
            if (this.getDoBrowserCompatibleMultipart()) {
                multipartEntityBuilder.setLaxMode();
            } else {
                multipartEntityBuilder.setStrictMode();
            }
            for (JMeterProperty jMeterProperty : this.getArguments()) {
                String parameterName;
                HTTPArgument arg = (HTTPArgument)jMeterProperty.getObjectValue();
                if (arg.isSkippable(parameterName = arg.getName())) continue;
                StringBody stringBody = new StringBody(arg.getValue(), ContentType.create((String)"text/plain", (Charset)charset));
                FormBodyPart formPart = FormBodyPartBuilder.create((String)parameterName, (ContentBody)stringBody).build();
                multipartEntityBuilder.addPart(formPart);
            }
            ViewableFileBody[] fileBodies = new ViewableFileBody[files.length];
            for (int i = 0; i < files.length; ++i) {
                HTTPFileArg file = files[i];
                ViewableFileBody[] reservedFile = FileServer.getFileServer().getResolvedFile(file.getPath());
                fileBodies[i] = new ViewableFileBody((File)reservedFile, file.getMimeType());
                multipartEntityBuilder.addPart(file.getParamName(), (ContentBody)fileBodies[i]);
            }
            HttpEntity entity = multipartEntityBuilder.build();
            post.setEntity(entity);
            if (entity.isRepeatable()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                for (ViewableFileBody fileBody : fileBodies) {
                    fileBody.hideFileData = true;
                }
                entity.writeTo((OutputStream)bos);
                for (ViewableFileBody fileBody : fileBodies) {
                    fileBody.hideFileData = false;
                }
                bos.flush();
                postedBody.append(bos.toString(contentEncoding == null ? "US-ASCII" : contentEncoding));
                bos.close();
            } else {
                postedBody.append("<Multipart was not repeatable, cannot view what was sent>");
            }
        } else {
            boolean hasContentTypeHeader;
            org.apache.http.Header contentTypeHeader = post.getFirstHeader("Content-Type");
            boolean bl2 = hasContentTypeHeader = contentTypeHeader != null && contentTypeHeader.getValue() != null && contentTypeHeader.getValue().length() > 0;
            if (!this.hasArguments() && this.getSendFileAsPostBody()) {
                HTTPFileArg file = files[0];
                if (!hasContentTypeHeader) {
                    if (file.getMimeType() != null && file.getMimeType().length() > 0) {
                        post.setHeader("Content-Type", file.getMimeType());
                    } else {
                        post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                    }
                }
                FileEntity fileRequestEntity = new FileEntity(new File(file.getPath()), (ContentType)null);
                post.setEntity((HttpEntity)fileRequestEntity);
                postedBody.append("<actual file content, not shown here>");
            } else {
                if (haveContentEncoding) {
                    post.getParams().setParameter("http.protocol.content-charset", (Object)contentEncoding);
                }
                if (this.getSendParameterValuesAsPostBody()) {
                    if (!hasContentTypeHeader) {
                        HTTPFileArg file;
                        HTTPFileArg hTTPFileArg = file = files.length > 0 ? files[0] : null;
                        if (file != null && file.getMimeType() != null && file.getMimeType().length() > 0) {
                            post.setHeader("Content-Type", file.getMimeType());
                        } else {
                            post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                        }
                    }
                    StringBuilder postBody = new StringBuilder();
                    for (JMeterProperty jMeterProperty : this.getArguments()) {
                        HTTPArgument arg = (HTTPArgument)jMeterProperty.getObjectValue();
                        if (haveContentEncoding) {
                            postBody.append(arg.getEncodedValue(contentEncoding));
                            continue;
                        }
                        postBody.append(arg.getEncodedValue());
                    }
                    StringEntity requestEntity = new StringEntity(postBody.toString(), contentEncoding);
                    post.setEntity((HttpEntity)requestEntity);
                    postedBody.append(postBody.toString());
                } else {
                    if (!hasContentTypeHeader) {
                        post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                    }
                    PropertyIterator args = this.getArguments().iterator();
                    ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                    String urlContentEncoding = contentEncoding;
                    if (urlContentEncoding == null || urlContentEncoding.length() == 0) {
                        urlContentEncoding = EncoderCache.URL_ARGUMENT_ENCODING;
                    }
                    while (args.hasNext()) {
                        String parameterName;
                        HTTPArgument arg = (HTTPArgument)args.next().getObjectValue();
                        if (arg.isSkippable(parameterName = arg.getName())) continue;
                        String parameterValue = arg.getValue();
                        if (!arg.isAlwaysEncoded()) {
                            parameterName = URLDecoder.decode(parameterName, urlContentEncoding);
                            parameterValue = URLDecoder.decode(parameterValue, urlContentEncoding);
                        }
                        nvps.add(new BasicNameValuePair(parameterName, parameterValue));
                    }
                    UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nvps, urlContentEncoding);
                    post.setEntity((HttpEntity)entity);
                    if (entity.isRepeatable()) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        post.getEntity().writeTo((OutputStream)bos);
                        bos.flush();
                        postedBody.append(bos.toString(contentEncoding != null ? contentEncoding : SampleResult.DEFAULT_HTTP_ENCODING));
                        bos.close();
                    } else {
                        postedBody.append("<RequestEntity was not repeatable, cannot view what was sent>");
                    }
                }
            }
        }
        return postedBody.toString();
    }

    protected String sendEntityData(HttpEntityEnclosingRequestBase entity) throws IOException {
        boolean hasEntityBody = false;
        HTTPFileArg[] files = this.getHTTPFiles();
        HTTPFileArg file = files.length > 0 ? files[0] : null;
        String contentTypeValue = null;
        if (file != null && file.getMimeType() != null && file.getMimeType().length() > 0) {
            contentTypeValue = file.getMimeType();
            entity.setHeader("Content-Type", contentTypeValue);
        }
        String charset = this.getContentEncoding(HTTP.DEF_CONTENT_CHARSET.name());
        if (!this.hasArguments() && this.getSendFileAsPostBody()) {
            hasEntityBody = true;
            File reservedFile = FileServer.getFileServer().getResolvedFile(files[0].getPath());
            FileEntity fileRequestEntity = new FileEntity(reservedFile);
            entity.setEntity((HttpEntity)fileRequestEntity);
        } else if (this.getSendParameterValuesAsPostBody()) {
            hasEntityBody = true;
            Arguments arguments = this.getArguments();
            StringBuilder entityBodyContent = new StringBuilder(arguments.getArgumentCount() * 15);
            for (JMeterProperty jMeterProperty : arguments) {
                HTTPArgument arg = (HTTPArgument)jMeterProperty.getObjectValue();
                if (charset != null) {
                    entityBodyContent.append(arg.getEncodedValue(charset));
                    continue;
                }
                entityBodyContent.append(arg.getEncodedValue());
            }
            StringEntity requestEntity = new StringEntity(entityBodyContent.toString(), charset);
            entity.setEntity((HttpEntity)requestEntity);
        }
        if (hasEntityBody) {
            HttpEntity entityEntry = entity.getEntity();
            StringBuilder entityBody = null;
            if (entityEntry.isRepeatable()) {
                entityBody = new StringBuilder(1000);
                try (InputStream in = entityEntry.getContent();
                     BoundedInputStream bounded = new BoundedInputStream(in, (long)MAX_BODY_RETAIN_SIZE);){
                    entityBody.append(IOUtils.toString((InputStream)bounded));
                }
                if (entityEntry.getContentLength() > (long)MAX_BODY_RETAIN_SIZE) {
                    entityBody.append("<actual file content shortened>");
                }
            } else {
                entityBody = new StringBuilder(65);
                entityBody.append("<RequestEntity was not repeatable, cannot view what was sent>");
            }
            return entityBody.toString();
        }
        return "";
    }

    private String getContentEncodingOrNull() {
        return this.getContentEncoding(null);
    }

    private String getContentEncoding(String dflt) {
        String ce = this.getContentEncoding();
        if (HTTPHC4Impl.isNullOrEmptyTrimmed(ce)) {
            return dflt;
        }
        return ce;
    }

    private void saveConnectionCookies(HttpResponse method, URL u, CookieManager cookieManager) {
        if (cookieManager != null) {
            org.apache.http.Header[] hdrs;
            for (org.apache.http.Header hdr : hdrs = method.getHeaders("set-cookie")) {
                cookieManager.addCookieFromHeader(hdr.getValue(), u);
            }
        }
    }

    @Override
    protected void notifyFirstSampleAfterLoopRestart() {
        log.debug("notifyFirstSampleAfterLoopRestart");
        this.resetSSLContext = !USE_CACHED_SSL_CONTEXT;
    }

    @Override
    protected void threadFinished() {
        log.debug("Thread Finished");
        this.closeThreadLocalConnections();
    }

    private void closeThreadLocalConnections() {
        Map<HttpClientKey, CloseableHttpClient> mapHttpClientPerHttpClientKey = HTTPCLIENTS_CACHE_PER_THREAD_AND_HTTPCLIENTKEY.get();
        if (mapHttpClientPerHttpClientKey != null) {
            for (CloseableHttpClient cl : mapHttpClientPerHttpClientKey.values()) {
                ((AbstractHttpClient)cl).clearRequestInterceptors();
                ((AbstractHttpClient)cl).clearResponseInterceptors();
                JOrphanUtils.closeQuietly((Closeable)cl);
                cl.getConnectionManager().shutdown();
            }
            mapHttpClientPerHttpClientKey.clear();
        }
    }

    public boolean interrupt() {
        HttpUriRequest request = this.currentRequest;
        if (request != null) {
            this.currentRequest = null;
            try {
                request.abort();
            }
            catch (UnsupportedOperationException e) {
                log.warn("Could not abort pending request", (Throwable)e);
            }
        }
        return request != null;
    }

    static {
        log.info("HTTP request retry count = {}", (Object)RETRY_COUNT);
        DEFAULT_HTTP_PARAMS = new SyncBasicHttpParams();
        DEFAULT_HTTP_PARAMS.setBooleanParameter("http.connection.stalecheck", false);
        DEFAULT_HTTP_PARAMS.setIntParameter("http.protocol.max-redirects", HTTPSamplerBase.MAX_REDIRECTS);
        DefaultHttpClient.setDefaultHttpParams((HttpParams)DEFAULT_HTTP_PARAMS);
        String file = JMeterUtils.getProperty((String)"hc.parameters.file");
        if (file != null) {
            HttpClientDefaultParameters.load(file, DEFAULT_HTTP_PARAMS);
        }
        if (CPS_HTTP > 0) {
            log.info("Setting up HTTP SlowProtocol, cps={}", (Object)CPS_HTTP);
            SLOW_HTTP = new Scheme("http", 80, (SchemeSocketFactory)new SlowHC4SocketFactory(CPS_HTTP));
        } else {
            SLOW_HTTP = null;
        }
        if (localAddress != null) {
            DEFAULT_HTTP_PARAMS.setParameter("http.route.local-address", (Object)localAddress);
        }
    }

    private static class ViewableFileBody
    extends FileBody {
        private boolean hideFileData = false;

        public ViewableFileBody(File file, String mimeType) {
            super(file, mimeType);
        }

        public void writeTo(OutputStream out) throws IOException {
            if (this.hideFileData) {
                out.write("<actual file content, not shown here>".getBytes());
            } else {
                super.writeTo(out);
            }
        }
    }

    private static final class HttpClientKey {
        private final String target;
        private final boolean hasProxy;
        private final String proxyHost;
        private final int proxyPort;
        private final String proxyUser;
        private final String proxyPass;
        private final int hashCode;

        public HttpClientKey(URL url, boolean hasProxy, String proxyHost, int proxyPort, String proxyUser, String proxyPass) {
            this.target = url.getProtocol() + "://" + url.getAuthority();
            this.hasProxy = hasProxy;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyUser = proxyUser;
            this.proxyPass = proxyPass;
            this.hashCode = this.getHash();
        }

        private int getHash() {
            int hash = 17;
            hash = hash * 31 + (this.hasProxy ? 1 : 0);
            if (this.hasProxy) {
                hash = hash * 31 + this.getHash(this.proxyHost);
                hash = hash * 31 + this.proxyPort;
                hash = hash * 31 + this.getHash(this.proxyUser);
                hash = hash * 31 + this.getHash(this.proxyPass);
            }
            hash = hash * 31 + this.target.hashCode();
            return hash;
        }

        private int getHash(String s) {
            return s == null ? 0 : s.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof HttpClientKey)) {
                return false;
            }
            HttpClientKey other = (HttpClientKey)obj;
            if (this.hasProxy) {
                return this.hasProxy == other.hasProxy && this.proxyPort == other.proxyPort && this.proxyHost.equals(other.proxyHost) && this.proxyUser.equals(other.proxyUser) && this.proxyPass.equals(other.proxyPass) && this.target.equals(other.target);
            }
            return this.hasProxy == other.hasProxy && this.target.equals(other.target);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.target);
            if (this.hasProxy) {
                sb.append(" via ");
                sb.append(this.proxyUser);
                sb.append('@');
                sb.append(this.proxyHost);
                sb.append(':');
                sb.append(this.proxyPort);
            }
            return sb.toString();
        }
    }

    public static final class HttpDelete
    extends HttpEntityEnclosingRequestBase {
        public HttpDelete(URI uri) {
            this.setURI(uri);
        }

        public String getMethod() {
            return "DELETE";
        }
    }

    public static final class HttpGetWithEntity
    extends HttpEntityEnclosingRequestBase {
        public HttpGetWithEntity(URI uri) {
            this.setURI(uri);
        }

        public String getMethod() {
            return "GET";
        }
    }
}

