/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.gui.Replaceable;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jorphan.util.JOrphanUtils;

public class HeaderManager
extends ConfigTestElement
implements Serializable,
Replaceable {
    private static final long serialVersionUID = 240L;
    public static final String HEADERS = "HeaderManager.headers";
    private static final String[] COLUMN_RESOURCE_NAMES = new String[]{"name", "value"};
    private static final int COLUMN_COUNT = COLUMN_RESOURCE_NAMES.length;

    public HeaderManager() {
        this.setProperty((JMeterProperty)new CollectionProperty(HEADERS, new ArrayList()));
    }

    public void clear() {
        super.clear();
        this.setProperty((JMeterProperty)new CollectionProperty(HEADERS, new ArrayList()));
    }

    public CollectionProperty getHeaders() {
        return (CollectionProperty)this.getProperty(HEADERS);
    }

    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    public String getColumnName(int column) {
        return COLUMN_RESOURCE_NAMES[column];
    }

    public Class<? extends String> getColumnClass(int column) {
        return COLUMN_RESOURCE_NAMES[column].getClass();
    }

    public Header getHeader(int row) {
        return (Header)this.getHeaders().get(row).getObjectValue();
    }

    public void save(String headFile) throws IOException {
        File file = new File(headFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir") + File.separator + headFile);
        }
        try (FileWriter fw = new FileWriter(file);
             PrintWriter writer = new PrintWriter(fw);){
            writer.println("# JMeter generated Header file");
            CollectionProperty hdrs = this.getHeaders();
            for (int i = 0; i < hdrs.size(); ++i) {
                JMeterProperty hdr = hdrs.get(i);
                Header head = (Header)hdr.getObjectValue();
                writer.println(head.toString());
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addFile(String headerFile) throws IOException {
        file = new File(headerFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir") + File.separator + headerFile);
        }
        if (!file.canRead()) {
            throw new IOException("The file you specified cannot be read.");
        }
        fr = new FileReader(file);
        var4_4 = null;
        try {
            reader = new BufferedReader(fr);
            var6_8 = null;
            while (true) {
                ** try [egrp 1[TRYBLOCK] [3, 4 : 94->214)] { 
lbl13:
                // 1 sources

                break;
lbl14:
                // 1 sources

                catch (Throwable var7_11) {
                    var6_8 = var7_11;
                    throw var7_11;
                }
                break;
            }
        }
        catch (Throwable var5_7) {
            var4_4 = var5_7;
            throw var5_7;
        }
        while ((line = reader.readLine()) != null) {
            try {
                if (line.startsWith("#")) ** continue;
                if (JOrphanUtils.isBlank((String)line)) continue;
                st = JOrphanUtils.split((String)line, (String)"\t", (String)" ");
                name = 0;
                value = 1;
                header = new Header(st[name], st[value]);
                this.getHeaders().addItem((Object)header);
            }
            catch (Exception e) {
                throw new IOException("Error parsing header line\n\t'" + line + "'\n\t" + e);
            }
        }
        return;
lbl34:
        // 1 sources

        finally {
            if (reader != null) {
                if (var6_8 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable var7_10) {
                        var6_8.addSuppressed(var7_10);
                    }
                } else {
                    reader.close();
                }
            }
        }
        finally {
            if (fr != null) {
                if (var4_4 != null) {
                    try {
                        fr.close();
                    }
                    catch (Throwable var5_6) {
                        var4_4.addSuppressed(var5_6);
                    }
                } else {
                    fr.close();
                }
            }
        }
    }

    public void add(Header h) {
        this.getHeaders().addItem((Object)h);
    }

    public void add() {
        this.getHeaders().addItem((Object)new Header());
    }

    public void remove(int index) {
        this.getHeaders().remove(index);
    }

    public int size() {
        return this.getHeaders().size();
    }

    public Header get(int i) {
        return (Header)this.getHeaders().get(i).getObjectValue();
    }

    public void removeHeaderNamed(String name) {
        ArrayList<Integer> removeIndices = new ArrayList<Integer>();
        for (int i = this.getHeaders().size() - 1; i >= 0; --i) {
            Header header = (Header)this.getHeaders().get(i).getObjectValue();
            if (header == null || !header.getName().equalsIgnoreCase(name)) continue;
            removeIndices.add(i);
        }
        for (Integer indice : removeIndices) {
            this.getHeaders().remove(indice.intValue());
        }
    }

    @Deprecated
    public HeaderManager merge(TestElement element, boolean preferLocalValues) {
        return this.merge(element);
    }

    public HeaderManager merge(TestElement element) {
        if (!(element instanceof HeaderManager)) {
            throw new IllegalArgumentException("Cannot merge type:" + this.getClass().getName() + " with type:" + element.getClass().getName());
        }
        HeaderManager merged = (HeaderManager)this.clone();
        HeaderManager other = (HeaderManager)element;
        for (int i = 0; i < other.getHeaders().size(); ++i) {
            Header otherHeader = other.get(i);
            boolean found = false;
            for (int j = 0; j < merged.getHeaders().size(); ++j) {
                Header mergedHeader = merged.get(j);
                if (!mergedHeader.getName().equalsIgnoreCase(otherHeader.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            merged.add(otherHeader);
        }
        merged.setName(merged.getName() + ":" + other.getName());
        return merged;
    }

    public int replace(String regex, String replaceBy, boolean caseSensitive) throws Exception {
        CollectionProperty hdrs = this.getHeaders();
        int totalReplaced = 0;
        for (int i = 0; i < hdrs.size(); ++i) {
            Object[] result;
            int nbReplaced;
            JMeterProperty hdr = hdrs.get(i);
            Header head = (Header)hdr.getObjectValue();
            String value = head.getValue();
            if (StringUtils.isEmpty((CharSequence)value) || (nbReplaced = ((Integer)(result = JOrphanUtils.replaceAllWithRegex((String)value, (String)regex, (String)replaceBy, (boolean)caseSensitive))[1]).intValue()) <= 0) continue;
            String replacedText = (String)result[0];
            head.setValue(replacedText);
            totalReplaced += nbReplaced;
        }
        return totalReplaced;
    }
}

