/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.protocol.http.gui.HTTPArgumentsPanel;
import org.apache.jmeter.protocol.http.gui.HTTPFileArgsPanel;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledChoice;
import org.apache.jorphan.gui.JLabeledTextField;

public class UrlConfigGui
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 240L;
    private static final int TAB_PARAMETERS = 0;
    private int tabRawBodyIndex = 1;
    private int tabFileUploadIndex = 2;
    private static final Font FONT_DEFAULT = UIManager.getDefaults().getFont("TextField.font");
    private static final Font FONT_SMALL = new Font("SansSerif", 0, (int)Math.round((double)FONT_DEFAULT.getSize() * 0.8));
    private HTTPArgumentsPanel argsPanel;
    private HTTPFileArgsPanel filesPanel;
    private JLabeledTextField domain;
    private JLabeledTextField port;
    private JLabeledTextField protocol;
    private JLabeledTextField contentEncoding;
    private JLabeledTextField path;
    private JCheckBox followRedirects;
    private JCheckBox autoRedirects;
    private JCheckBox useKeepAlive;
    private JCheckBox useMultipartForPost;
    private JCheckBox useBrowserCompatibleMultipartMode;
    private JLabeledChoice method;
    private final boolean notConfigOnly;
    private JSyntaxTextArea postBodyContent;
    private ValidationTabbedPane postContentTabbedPane;
    private boolean showRawBodyPane;
    private boolean showFileUploadPane;

    public UrlConfigGui() {
        this(true);
    }

    public UrlConfigGui(boolean showSamplerFields) {
        this(showSamplerFields, true);
    }

    public UrlConfigGui(boolean showSamplerFields, boolean showRawBodyPane) {
        this(showSamplerFields, showRawBodyPane, false);
    }

    public UrlConfigGui(boolean showSamplerFields, boolean showRawBodyPane, boolean showFileUploadPane) {
        this.notConfigOnly = showSamplerFields;
        this.showRawBodyPane = showRawBodyPane;
        this.showFileUploadPane = showFileUploadPane;
        this.init();
    }

    public void clear() {
        this.domain.setText("");
        if (this.notConfigOnly) {
            this.followRedirects.setSelected(true);
            this.autoRedirects.setSelected(false);
            this.method.setText("GET");
            this.useKeepAlive.setSelected(true);
            this.useMultipartForPost.setSelected(false);
            this.useBrowserCompatibleMultipartMode.setSelected(false);
        }
        this.path.setText("");
        this.port.setText("");
        this.protocol.setText("");
        this.contentEncoding.setText("");
        this.argsPanel.clear();
        if (this.showFileUploadPane) {
            this.filesPanel.clear();
        }
        if (this.showRawBodyPane) {
            this.postBodyContent.setInitialText("");
        }
        this.postContentTabbedPane.setSelectedIndex(0, false);
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        element.setName(this.getName());
        element.setProperty("TestElement.gui_class", this.getClass().getName());
        element.setProperty("TestElement.test_class", element.getClass().getName());
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        Arguments args;
        boolean useRaw;
        boolean bl = useRaw = this.postContentTabbedPane.getSelectedIndex() == this.tabRawBodyIndex;
        if (useRaw) {
            args = new Arguments();
            String text = this.postBodyContent.getText();
            HTTPArgument arg = new HTTPArgument("", text.replaceAll("\n", "\r\n"), false);
            arg.setAlwaysEncoded(false);
            args.addArgument((Argument)arg);
        } else {
            args = (Arguments)this.argsPanel.createTestElement();
            HTTPArgument.convertArgumentsToHTTP(args);
            if (this.showFileUploadPane) {
                this.filesPanel.modifyTestElement(element);
            }
        }
        element.setProperty("HTTPSampler.postBodyRaw", useRaw, false);
        element.setProperty((JMeterProperty)new TestElementProperty("HTTPsampler.Arguments", (TestElement)args));
        element.setProperty("HTTPSampler.domain", this.domain.getText());
        element.setProperty("HTTPSampler.port", this.port.getText());
        element.setProperty("HTTPSampler.protocol", this.protocol.getText());
        element.setProperty("HTTPSampler.contentEncoding", this.contentEncoding.getText());
        element.setProperty("HTTPSampler.path", this.path.getText());
        if (this.notConfigOnly) {
            element.setProperty("HTTPSampler.method", this.method.getText());
            element.setProperty((JMeterProperty)new BooleanProperty("HTTPSampler.follow_redirects", this.followRedirects.isSelected()));
            element.setProperty((JMeterProperty)new BooleanProperty("HTTPSampler.auto_redirects", this.autoRedirects.isSelected()));
            element.setProperty((JMeterProperty)new BooleanProperty("HTTPSampler.use_keepalive", this.useKeepAlive.isSelected()));
            element.setProperty((JMeterProperty)new BooleanProperty("HTTPSampler.DO_MULTIPART_POST", this.useMultipartForPost.isSelected()));
            element.setProperty("HTTPSampler.BROWSER_COMPATIBLE_MULTIPART", this.useBrowserCompatibleMultipartMode.isSelected(), false);
        }
    }

    private static String computePostBody(Arguments arguments) {
        return UrlConfigGui.computePostBody(arguments, false);
    }

    private static String computePostBody(Arguments arguments, boolean crlfToLF) {
        StringBuilder postBody = new StringBuilder();
        for (JMeterProperty argument : arguments) {
            HTTPArgument arg = (HTTPArgument)argument.getObjectValue();
            String value = arg.getValue();
            if (crlfToLF) {
                value = value.replaceAll("\r\n", "\n");
            }
            postBody.append(value);
        }
        return postBody.toString();
    }

    public void configure(TestElement el) {
        this.setName(el.getName());
        Arguments arguments = (Arguments)el.getProperty("HTTPsampler.Arguments").getObjectValue();
        boolean useRaw = el.getPropertyAsBoolean("HTTPSampler.postBodyRaw", false);
        if (useRaw) {
            String postBody = UrlConfigGui.computePostBody(arguments, true);
            this.postBodyContent.setInitialText(postBody);
            this.postBodyContent.setCaretPosition(0);
            this.postContentTabbedPane.setSelectedIndex(this.tabRawBodyIndex, false);
        } else {
            this.argsPanel.configure((TestElement)arguments);
            this.postContentTabbedPane.setSelectedIndex(0, false);
            if (this.showFileUploadPane) {
                this.filesPanel.configure(el);
            }
        }
        this.domain.setText(el.getPropertyAsString("HTTPSampler.domain"));
        String portString = el.getPropertyAsString("HTTPSampler.port");
        if (portString.equals("0")) {
            this.port.setText("");
        } else {
            this.port.setText(portString);
        }
        this.protocol.setText(el.getPropertyAsString("HTTPSampler.protocol"));
        this.contentEncoding.setText(el.getPropertyAsString("HTTPSampler.contentEncoding"));
        this.path.setText(el.getPropertyAsString("HTTPSampler.path"));
        if (this.notConfigOnly) {
            this.method.setText(el.getPropertyAsString("HTTPSampler.method"));
            this.followRedirects.setSelected(el.getPropertyAsBoolean("HTTPSampler.follow_redirects"));
            this.autoRedirects.setSelected(el.getPropertyAsBoolean("HTTPSampler.auto_redirects"));
            this.useKeepAlive.setSelected(el.getPropertyAsBoolean("HTTPSampler.use_keepalive"));
            this.useMultipartForPost.setSelected(el.getPropertyAsBoolean("HTTPSampler.DO_MULTIPART_POST"));
            this.useBrowserCompatibleMultipartMode.setSelected(el.getPropertyAsBoolean("HTTPSampler.BROWSER_COMPATIBLE_MULTIPART", false));
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel webRequestPanel = new JPanel();
        webRequestPanel.setLayout(new BorderLayout());
        webRequestPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_request")));
        webRequestPanel.add(this.getPathPanel(), "North");
        webRequestPanel.add((Component)this.getParameterPanel(), "Center");
        this.add((Component)this.getWebServerPanel(), "North");
        this.add((Component)webRequestPanel, "Center");
    }

    protected final JPanel getWebServerPanel() {
        this.protocol = new JLabeledTextField(JMeterUtils.getResString((String)"protocol"), 4);
        this.port = new JLabeledTextField(JMeterUtils.getResString((String)"web_server_port"), 7);
        this.domain = new JLabeledTextField(JMeterUtils.getResString((String)"web_server_domain"), 40);
        HorizontalPanel webServerPanel = new HorizontalPanel();
        webServerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_server")));
        webServerPanel.add((Component)this.protocol);
        webServerPanel.add((Component)this.domain);
        webServerPanel.add((Component)this.port);
        return webServerPanel;
    }

    protected Component getPathPanel() {
        this.path = new JLabeledTextField(JMeterUtils.getResString((String)"path"), 80);
        this.contentEncoding = new JLabeledTextField(JMeterUtils.getResString((String)"content_encoding"), 7);
        if (this.notConfigOnly) {
            this.method = new JLabeledChoice(JMeterUtils.getResString((String)"method"), HTTPSamplerBase.getValidMethodsAsArray(), true, false);
            this.method.addChangeListener((ChangeListener)this);
        }
        if (this.notConfigOnly) {
            this.followRedirects = new JCheckBox(JMeterUtils.getResString((String)"follow_redirects"));
            this.followRedirects.setFont(null);
            this.followRedirects.setSelected(true);
            this.followRedirects.addChangeListener(this);
            this.autoRedirects = new JCheckBox(JMeterUtils.getResString((String)"follow_redirects_auto"));
            this.autoRedirects.setFont(null);
            this.autoRedirects.addChangeListener(this);
            this.autoRedirects.setSelected(false);
            this.useKeepAlive = new JCheckBox(JMeterUtils.getResString((String)"use_keepalive"));
            this.useKeepAlive.setFont(null);
            this.useKeepAlive.setSelected(true);
            this.useMultipartForPost = new JCheckBox(JMeterUtils.getResString((String)"use_multipart_for_http_post"));
            this.useMultipartForPost.setFont(null);
            this.useMultipartForPost.setSelected(false);
            this.useBrowserCompatibleMultipartMode = new JCheckBox(JMeterUtils.getResString((String)"use_multipart_mode_browser"));
            this.useBrowserCompatibleMultipartMode.setFont(null);
            this.useBrowserCompatibleMultipartMode.setSelected(false);
        }
        HorizontalPanel pathPanel = new HorizontalPanel();
        pathPanel.setPreferredSize(new Dimension(80, 30));
        if (this.notConfigOnly) {
            pathPanel.add((Component)this.method);
        }
        pathPanel.add((Component)this.path);
        pathPanel.add((Component)this.contentEncoding);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add((Component)pathPanel);
        if (this.notConfigOnly) {
            JPanel optionPanel = new JPanel(new FlowLayout(0));
            optionPanel.setFont(FONT_SMALL);
            optionPanel.add(this.autoRedirects);
            optionPanel.add(this.followRedirects);
            optionPanel.add(this.useKeepAlive);
            optionPanel.add(this.useMultipartForPost);
            optionPanel.add(this.useBrowserCompatibleMultipartMode);
            optionPanel.setMinimumSize(optionPanel.getPreferredSize());
            panel.add(optionPanel);
        }
        return panel;
    }

    protected JTabbedPane getParameterPanel() {
        this.postContentTabbedPane = new ValidationTabbedPane();
        this.argsPanel = new HTTPArgumentsPanel();
        this.postContentTabbedPane.add(JMeterUtils.getResString((String)"post_as_parameters"), (Component)((Object)this.argsPanel));
        int indx = 0;
        if (this.showRawBodyPane) {
            this.tabRawBodyIndex = ++indx;
            this.postBodyContent = JSyntaxTextArea.getInstance((int)30, (int)50);
            this.postContentTabbedPane.add(JMeterUtils.getResString((String)"post_body"), (Component)JTextScrollPane.getInstance((JSyntaxTextArea)this.postBodyContent));
        }
        if (this.showFileUploadPane) {
            this.tabFileUploadIndex = ++indx;
            this.filesPanel = new HTTPFileArgsPanel();
            this.postContentTabbedPane.add(JMeterUtils.getResString((String)"post_files_upload"), this.filesPanel);
        }
        return this.postContentTabbedPane;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.autoRedirects) {
            if (this.autoRedirects.isSelected()) {
                this.followRedirects.setSelected(false);
            }
        } else if (e.getSource() == this.followRedirects) {
            if (this.followRedirects.isSelected()) {
                this.autoRedirects.setSelected(false);
            }
        } else if (e.getSource() == this.method) {
            boolean isPostMethod = "POST".equals(this.method.getText());
            this.useMultipartForPost.setEnabled(isPostMethod);
        }
    }

    void convertParametersToRaw() {
        this.postBodyContent.setInitialText(UrlConfigGui.computePostBody((Arguments)this.argsPanel.createTestElement()));
        this.postBodyContent.setCaretPosition(0);
    }

    boolean canConvertParameters() {
        Arguments arguments = (Arguments)this.argsPanel.createTestElement();
        for (int i = 0; i < arguments.getArgumentCount(); ++i) {
            if (StringUtils.isEmpty((CharSequence)arguments.getArgument(i).getName())) continue;
            return false;
        }
        return true;
    }

    boolean noData(int oldSelectedIndex) {
        if (oldSelectedIndex == this.tabRawBodyIndex) {
            return StringUtils.isEmpty((CharSequence)this.postBodyContent.getText().trim());
        }
        boolean noData = true;
        Arguments element = (Arguments)this.argsPanel.createTestElement();
        if (this.showFileUploadPane) {
            noData &= !this.filesPanel.hasData();
        }
        return noData && StringUtils.isEmpty((CharSequence)UrlConfigGui.computePostBody(element));
    }

    class ValidationTabbedPane
    extends JTabbedPane {
        private static final long serialVersionUID = 7014311238367882880L;

        ValidationTabbedPane() {
        }

        @Override
        public void setSelectedIndex(int index) {
            this.setSelectedIndex(index, true);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setSelectedIndex(int index, boolean check) {
            int oldSelectedIndex = this.getSelectedIndex();
            if (!check || oldSelectedIndex == -1) {
                super.setSelectedIndex(index);
                return;
            }
            if (index == oldSelectedIndex) return;
            if (UrlConfigGui.this.noData(oldSelectedIndex)) {
                UrlConfigGui.this.argsPanel.clear();
                UrlConfigGui.this.postBodyContent.setInitialText("");
                if (UrlConfigGui.this.showFileUploadPane) {
                    UrlConfigGui.this.filesPanel.clear();
                }
                super.setSelectedIndex(index);
                return;
            }
            boolean filePanelHasData = false;
            if (UrlConfigGui.this.showFileUploadPane) {
                filePanelHasData = UrlConfigGui.this.filesPanel.hasData();
            }
            if (oldSelectedIndex == UrlConfigGui.this.tabRawBodyIndex) {
                if (index == 0 && UrlConfigGui.this.postBodyContent.getText().equals(UrlConfigGui.computePostBody((Arguments)UrlConfigGui.this.argsPanel.createTestElement()).trim())) {
                    super.setSelectedIndex(index);
                    return;
                }
                JOptionPane.showConfirmDialog(this, JMeterUtils.getResString((String)"web_cannot_switch_tab"), JMeterUtils.getResString((String)"warning"), -1, 0);
                return;
            }
            if (oldSelectedIndex == 0 && index == UrlConfigGui.this.tabFileUploadIndex || oldSelectedIndex == UrlConfigGui.this.tabFileUploadIndex && index == 0) {
                super.setSelectedIndex(index);
                return;
            }
            if (oldSelectedIndex == 0 && !filePanelHasData && UrlConfigGui.this.canConvertParameters()) {
                Object[] options = new Object[]{JMeterUtils.getResString((String)"confirm"), JMeterUtils.getResString((String)"cancel")};
                int n = JOptionPane.showOptionDialog(this, JMeterUtils.getResString((String)"web_parameters_lost_message"), JMeterUtils.getResString((String)"warning"), 1, 3, null, options, options[1]);
                if (n != 0) return;
                UrlConfigGui.this.convertParametersToRaw();
                super.setSelectedIndex(index);
                return;
            }
            String messageKey = filePanelHasData ? "web_cannot_switch_tab" : "web_cannot_convert_parameters_to_raw";
            JOptionPane.showConfirmDialog(this, JMeterUtils.getResString((String)messageKey), JMeterUtils.getResString((String)"warning"), -1, 0);
        }
    }
}

