/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.reflect;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.jorphan.reflect.ClassFilter;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassFinder {
    private static final Logger log = LoggerFactory.getLogger(ClassFinder.class);
    private static final String DOT_JAR = ".jar";
    private static final String DOT_CLASS = ".class";
    private static final int DOT_CLASS_LEN = ".class".length();

    private ClassFinder() {
    }

    public static List<String> findClassesThatExtend(String[] paths, Class<?>[] superClasses) throws IOException {
        return ClassFinder.findClassesThatExtend(paths, superClasses, false);
    }

    private static String[] addJarsInPath(String[] paths) {
        HashSet<String> fullList = new HashSet<String>();
        for (String path : paths) {
            String[] jars;
            File dir;
            fullList.add(path);
            if (path.endsWith(DOT_JAR) || !(dir = new File(path)).exists() || !dir.isDirectory() || (jars = dir.list((f, name) -> name.endsWith(DOT_JAR))) == null) continue;
            Collections.addAll(fullList, jars);
        }
        return fullList.toArray(new String[fullList.size()]);
    }

    public static List<String> findClassesThatExtend(String[] strPathsOrJars, Class<?>[] superClasses, boolean innerClasses) throws IOException {
        return ClassFinder.findClassesThatExtend(strPathsOrJars, superClasses, innerClasses, null, null);
    }

    public static List<String> findClassesThatExtend(String[] strPathsOrJars, Class<?>[] superClasses, boolean innerClasses, String contains, String notContains) throws IOException {
        return ClassFinder.findClassesThatExtend(strPathsOrJars, superClasses, innerClasses, contains, notContains, false);
    }

    public static List<String> findAnnotatedClasses(String[] strPathsOrJars, Class<? extends Annotation>[] annotations, boolean innerClasses) throws IOException {
        return ClassFinder.findClassesThatExtend(strPathsOrJars, annotations, innerClasses, null, null, true);
    }

    public static List<String> findAnnotatedClasses(String[] strPathsOrJars, Class<? extends Annotation>[] annotations) throws IOException {
        return ClassFinder.findClassesThatExtend(strPathsOrJars, annotations, false, null, null, true);
    }

    public static List<String> findClassesThatExtend(String[] searchPathsOrJars, Class<?>[] classNames, boolean innerClasses, String contains, String notContains, boolean annotations) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("searchPathsOrJars : " + Arrays.toString(searchPathsOrJars));
            log.debug("superclass : " + Arrays.toString(classNames));
            log.debug("innerClasses : " + innerClasses + " annotations: " + annotations);
            log.debug("contains: " + contains + " notContains: " + notContains);
        }
        ClassFilter filter = null;
        if (annotations) {
            Class<?>[] annoclassNames = classNames;
            filter = new AnnoClassFilter(annoclassNames, innerClasses);
        } else {
            filter = new ExtendsClassFilter(classNames, innerClasses, contains, notContains);
        }
        return ClassFinder.findClasses(searchPathsOrJars, filter);
    }

    public static List<String> findClasses(String[] searchPathsOrJars, ClassFilter filter) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("searchPathsOrJars : " + Arrays.toString(searchPathsOrJars));
        }
        String[] strPathsOrJars = ClassFinder.addJarsInPath(searchPathsOrJars);
        for (int k = 0; k < strPathsOrJars.length; ++k) {
            strPathsOrJars[k] = ClassFinder.fixPathEntry(strPathsOrJars[k]);
        }
        List<String> listPaths = ClassFinder.getClasspathMatches(strPathsOrJars);
        if (log.isDebugEnabled()) {
            for (String path : listPaths) {
                log.debug("listPaths : " + path);
            }
        }
        TreeSet<String> listClasses = new TreeSet<String>();
        for (String path : listPaths) {
            ClassFinder.findClassesInOnePath(path, listClasses, filter);
        }
        if (log.isDebugEnabled()) {
            log.debug("listClasses.size()=" + listClasses.size());
            for (String clazz : listClasses) {
                log.debug("listClasses : " + clazz);
            }
        }
        return new ArrayList<String>(listClasses);
    }

    private static List<String> getClasspathMatches(String[] strPathsOrJars) {
        String javaClassPath = System.getProperty("java.class.path");
        StringTokenizer stPaths = new StringTokenizer(javaClassPath, File.pathSeparator);
        if (log.isDebugEnabled()) {
            log.debug("Classpath = " + javaClassPath);
            for (int i = 0; i < strPathsOrJars.length; ++i) {
                log.debug("strPathsOrJars[" + i + "] : " + strPathsOrJars[i]);
            }
        }
        ArrayList<String> listPaths = new ArrayList<String>();
        String strPath = null;
        while (stPaths.hasMoreTokens()) {
            strPath = ClassFinder.fixPathEntry(stPaths.nextToken());
            if (strPathsOrJars == null) {
                log.debug("Adding: " + strPath);
                listPaths.add(strPath);
                continue;
            }
            boolean found = false;
            for (int i = 0; i < strPathsOrJars.length; ++i) {
                if (!strPath.endsWith(strPathsOrJars[i])) continue;
                found = true;
                log.debug("Adding " + strPath + " found at " + i);
                listPaths.add(strPath);
                break;
            }
            if (found) continue;
            log.debug("Did not find: " + strPath);
        }
        return listPaths;
    }

    private static String fixPathEntry(String path) {
        if (path == null) {
            return null;
        }
        if (path.equals(".")) {
            return System.getProperty("user.dir");
        }
        String resultPath = path;
        if (path.length() > 3 && path.matches("[a-z]:\\\\.*")) {
            resultPath = path.substring(0, 1).toUpperCase(Locale.ROOT) + path.substring(1);
        }
        resultPath = resultPath.trim().replace('\\', '/');
        resultPath = JOrphanUtils.substitute(resultPath, "//", "/");
        while (resultPath.endsWith("/")) {
            resultPath = resultPath.substring(0, resultPath.length() - 1);
        }
        return resultPath;
    }

    private static boolean isChildOf(Class<?>[] parentClasses, String strClassName, ClassLoader contextClassLoader) {
        try {
            Class<?> c = Class.forName(strClassName, false, contextClassLoader);
            if (!c.isInterface() && !Modifier.isAbstract(c.getModifiers())) {
                for (Class<?> parentClass : parentClasses) {
                    if (!parentClass.isAssignableFrom(c)) continue;
                    return true;
                }
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError | UnsupportedClassVersionError | VerifyError e) {
            log.debug(e.getLocalizedMessage(), e);
        }
        return false;
    }

    private static boolean hasAnnotationOnMethod(Class<? extends Annotation>[] annotations, String classInQuestion, ClassLoader contextClassLoader) {
        try {
            Class<?> c = Class.forName(classInQuestion, false, contextClassLoader);
            for (Method method : c.getMethods()) {
                for (Class<? extends Annotation> annotation : annotations) {
                    if (!method.isAnnotationPresent(annotation)) continue;
                    return true;
                }
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError | UnsupportedClassVersionError | VerifyError ignored) {
            log.debug(ignored.getLocalizedMessage(), ignored);
        }
        return false;
    }

    private static String fixClassName(String strClassName) {
        strClassName = strClassName.replace('\\', '.');
        strClassName = strClassName.replace('/', '.');
        strClassName = strClassName.substring(0, strClassName.length() - DOT_CLASS_LEN);
        return strClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findClassesInOnePath(String strPath, Set<String> listClasses, ClassFilter filter) throws IOException {
        File file = new File(strPath);
        if (file.isDirectory()) {
            ClassFinder.findClassesInPathsDir(strPath, file, listClasses, filter);
        } else if (file.exists()) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    String fixedClassName;
                    String strEntry = entries.nextElement().toString();
                    if (!strEntry.endsWith(DOT_CLASS) || !filter.accept(fixedClassName = ClassFinder.fixClassName(strEntry))) continue;
                    listClasses.add(fixedClassName);
                }
            }
            catch (IOException e) {
                log.warn("Can not open the jar " + strPath + " " + e.getLocalizedMessage(), (Throwable)e);
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static void findClassesInPathsDir(String strPathElement, File dir, Set<String> listClasses, ClassFilter filter) throws IOException {
        String[] list = dir.list();
        if (list == null) {
            log.warn(dir.getAbsolutePath() + " is not a folder");
            return;
        }
        for (String aList : list) {
            String path;
            String className;
            File file = new File(dir, aList);
            if (file.isDirectory()) {
                ClassFinder.findClassesInPathsDir(strPathElement, file, listClasses, filter);
                continue;
            }
            if (!aList.endsWith(DOT_CLASS) || !file.exists() || file.length() == 0L || !filter.accept(className = (path = file.getPath()).substring(strPathElement.length() + 1, path.lastIndexOf(46)).replace(File.separator.charAt(0), '.'))) continue;
            listClasses.add(className);
        }
    }

    private static class AnnoClassFilter
    implements ClassFilter {
        private final boolean inner;
        private final Class<? extends Annotation>[] annotations;
        private final transient ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();

        AnnoClassFilter(Class<? extends Annotation>[] annotations, boolean inner) {
            this.annotations = annotations;
            this.inner = inner;
        }

        @Override
        public boolean accept(String className) {
            return (!className.contains("$") || this.inner) && ClassFinder.hasAnnotationOnMethod(this.annotations, className, this.contextClassLoader);
        }
    }

    private static class ExtendsClassFilter
    implements ClassFilter {
        private final Class<?>[] parents;
        private final boolean inner;
        private final String contains;
        private final String notContains;
        private final transient ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();

        ExtendsClassFilter(Class<?>[] parents, boolean inner, String contains, String notContains) {
            this.parents = parents;
            this.inner = inner;
            this.contains = contains;
            this.notContains = notContains;
        }

        @Override
        public boolean accept(String className) {
            if (this.contains != null && !className.contains(this.contains)) {
                return false;
            }
            if (this.notContains != null && className.contains(this.notContains)) {
                return false;
            }
            return (!className.contains("$") || this.inner) && ClassFinder.isChildOf(this.parents, className, this.contextClassLoader);
        }
    }
}

