/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.filter;

import javax.servlet.http.HttpServletRequest;
import jodd.io.FastCharArrayWriter;
import jodd.lagarto.LagartoParser;
import jodd.lagarto.TagAdapter;
import jodd.lagarto.TagWriter;
import jodd.lagarto.filter.LagartoServletFilter;

public abstract class SimpleLagartoServletFilter
extends LagartoServletFilter {
    @Override
    protected final char[] parse(char[] content, HttpServletRequest request) {
        LagartoParsingProcessor lpp = this.createParsingProcessor();
        if (lpp == null) {
            return content;
        }
        lpp.init(content);
        return lpp.parse(request);
    }

    protected abstract LagartoParsingProcessor createParsingProcessor();

    protected static abstract class LagartoParsingProcessor {
        protected LagartoParser lagartoParser;
        protected FastCharArrayWriter fastCharArrayWriter;
        protected TagWriter tagWriter;
        protected boolean emitStrings;

        protected LagartoParsingProcessor(boolean emitStrings) {
            this.emitStrings = emitStrings;
        }

        public void init(char[] content) {
            this.lagartoParser = new LagartoParser(content, this.emitStrings);
            this.fastCharArrayWriter = new FastCharArrayWriter();
            this.tagWriter = new TagWriter((Appendable)this.fastCharArrayWriter);
        }

        public char[] parse(HttpServletRequest request) {
            return this.parse(this.tagWriter, request);
        }

        protected abstract char[] parse(TagWriter var1, HttpServletRequest var2);

        public char[] invokeLagarto(TagAdapter tagAdapter) {
            this.lagartoParser.parse(tagAdapter);
            return this.fastCharArrayWriter.toCharArray();
        }
    }
}

