/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.io.FileNameUtil;
import jodd.io.FileUtil;
import jodd.io.StreamGobbler;
import jodd.io.StreamUtil;
import jodd.util.RuntimeUtil;
import jodd.util.StringPool;
import jodd.util.StringUtil;
import jodd.util.SystemUtil;

public class CommandLine {
    public static final int OK = 0;
    protected final String command;
    protected final List<String> args = new ArrayList<String>();
    protected Map<String, String> env = null;
    protected File workingDirectory;
    protected String outPrefix = "out> ";
    protected String errPrefix = "err> ";
    protected OutputStream out = System.out;
    protected OutputStream err = System.err;
    protected boolean newShell = false;

    protected CommandLine(String command) {
        this.command = command;
    }

    public static CommandLine cmd(String command) {
        return new CommandLine(command);
    }

    public CommandLine workingDirectory(File workDirectory) {
        this.workingDirectory = workDirectory;
        return this;
    }

    public CommandLine workingDirectory(String workDirectory) {
        this.workingDirectory = new File(workDirectory);
        return this;
    }

    public CommandLine arg(String argument) {
        this.args.add(argument);
        return this;
    }

    public CommandLine args(String ... arguments) {
        if (arguments != null && arguments.length > 0) {
            Collections.addAll(this.args, arguments);
        }
        return this;
    }

    public CommandLine outPrefix(String prefix) {
        this.outPrefix = prefix;
        return this;
    }

    public CommandLine errPrefix(String prefix) {
        this.errPrefix = prefix;
        return this;
    }

    public CommandLine out(OutputStream out) {
        this.out = out;
        return this;
    }

    public CommandLine err(OutputStream err) {
        this.err = err;
        return this;
    }

    public CommandLine env(String key, String value) {
        if (this.env == null) {
            this.env = new HashMap<String, String>();
        }
        this.env.put(key, value);
        return this;
    }

    public CommandLine newShell(boolean newShell) {
        this.newShell = newShell;
        return this;
    }

    protected List<String> resolveShellExecutor(String command) {
        ArrayList<String> newCommand = new ArrayList<String>();
        File commandFile = new File(command);
        if (SystemUtil.isHostMac()) {
            if (this.isSH(command)) {
                newCommand.add("sh");
            } else if (!commandFile.canExecute() || FileNameUtil.hasExtension(commandFile.getAbsolutePath())) {
                if (FileUtil.isExistingFile(commandFile)) {
                    newCommand.add("open");
                } else {
                    newCommand.add("sh");
                    newCommand.add("-c");
                }
            }
        } else if (SystemUtil.isHostAix() || SystemUtil.isHostLinux() || SystemUtil.isHostSolaris() || SystemUtil.isHostUnix()) {
            String shebang = this.resolveShebangLine(commandFile);
            newCommand.add(shebang);
            if (shebang.equals("sh")) {
                newCommand.add("-c");
            }
        } else if (SystemUtil.isHostWindows()) {
            newCommand.add("cmd");
            newCommand.add("/c");
        }
        newCommand.add(command);
        return newCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String resolveShebangLine(File commandFile) {
        String shebang = "sh";
        if (commandFile.exists() && !commandFile.isDirectory() && commandFile.length() > 0L) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(commandFile));
                shebang = reader.readLine();
                shebang = shebang.substring(shebang.indexOf(47));
            }
            catch (Exception exception) {
                StreamUtil.close(reader);
                catch (Throwable throwable) {
                    StreamUtil.close(reader);
                    throw throwable;
                }
            }
            StreamUtil.close(reader);
        }
        return shebang;
    }

    protected boolean isSH(String command) {
        return FileNameUtil.getExtension(command).equals("sh");
    }

    protected List<String> prepareCommands() {
        ArrayList<String> commands = new ArrayList<String>(this.args.size() + 1);
        if (this.newShell) {
            commands.addAll(this.resolveShellExecutor(this.command));
        } else {
            commands.add(this.command);
        }
        commands.addAll(this.args);
        return commands;
    }

    public RuntimeUtil.ProcessResult execute() throws IOException, InterruptedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.out = this.err = baos;
        List<String> commands = this.prepareCommands();
        baos.write(StringUtil.join(commands, ' ').getBytes());
        baos.write(StringPool.BYTES_NEW_LINE);
        int exitCode = this.execute(commands);
        return new RuntimeUtil.ProcessResult(exitCode, baos.toString());
    }

    private int execute(List<String> commands) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(commands);
        if (this.env != null) {
            processBuilder.environment().putAll(this.env);
        }
        processBuilder.directory(this.workingDirectory);
        Process process = processBuilder.start();
        StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream(), this.out, this.outPrefix);
        StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream(), this.err, this.errPrefix);
        outputGobbler.start();
        errorGobbler.start();
        int result = process.waitFor();
        outputGobbler.waitFor();
        errorGobbler.waitFor();
        return result;
    }
}

