/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.mongodb.sampler;

import com.mongodb.DB;
import org.apache.jmeter.protocol.mongodb.config.MongoSourceElement;
import org.apache.jmeter.protocol.mongodb.mongo.EvalResultHandler;
import org.apache.jmeter.protocol.mongodb.mongo.MongoDB;
import org.apache.jmeter.protocol.mongodb.sampler.MongoScriptRunner;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testbeans.TestBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoScriptSampler
extends AbstractSampler
implements TestBean {
    private static final long serialVersionUID = -7789012234636439896L;
    private static final Logger log = LoggerFactory.getLogger(MongoScriptSampler.class);
    public static final String SOURCE = "MongoScriptSampler.source";
    public static final String DATABASE = "MongoScriptSampler.database";
    public static final String USERNAME = "MongoScriptSampler.username";
    public static final String PASSWORD = "MongoScriptSampler.password";
    public static final String SCRIPT = "MongoScriptSampler.script";

    public MongoScriptSampler() {
        this.trace("MongoScriptSampler()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SampleResult sample(Entry e) {
        this.trace("sample()");
        SampleResult res = new SampleResult();
        String data = this.getScript();
        res.setSampleLabel(this.getTitle());
        res.setResponseCodeOK();
        res.setResponseCode("200");
        res.setSuccessful(true);
        res.setResponseMessageOK();
        res.setSamplerData(data);
        res.setDataType("text");
        res.setContentType("text/plain");
        res.sampleStart();
        try {
            MongoDB mongoDB = MongoSourceElement.getMongoDB(this.getSource());
            MongoScriptRunner runner = new MongoScriptRunner();
            DB db = mongoDB.getDB(this.getDatabase(), this.getUsername(), this.getPassword());
            res.latencyEnd();
            Object result = runner.evaluate(db, data);
            EvalResultHandler handler = new EvalResultHandler();
            String resultAsString = handler.handle(result);
            res.setResponseData(resultAsString.getBytes());
        }
        catch (Exception ex) {
            res.setResponseCode("500");
            res.setSuccessful(false);
            res.setResponseMessage(ex.toString());
            res.setResponseData(ex.getMessage().getBytes());
        }
        finally {
            res.sampleEnd();
        }
        return res;
    }

    public String getTitle() {
        return this.getName();
    }

    public String getScript() {
        return this.getPropertyAsString(SCRIPT);
    }

    public void setScript(String script) {
        this.setProperty(SCRIPT, script);
    }

    public String getDatabase() {
        return this.getPropertyAsString(DATABASE);
    }

    public void setDatabase(String database) {
        this.setProperty(DATABASE, database);
    }

    public String getUsername() {
        return this.getPropertyAsString(USERNAME);
    }

    public void setUsername(String username) {
        this.setProperty(USERNAME, username);
    }

    public String getPassword() {
        return this.getPropertyAsString(PASSWORD);
    }

    public void setPassword(String password) {
        this.setProperty(PASSWORD, password);
    }

    public String getSource() {
        return this.getPropertyAsString(SOURCE);
    }

    public void setSource(String source) {
        this.setProperty(SOURCE, source);
    }

    private void trace(String s) {
        if (log.isDebugEnabled()) {
            log.debug(Thread.currentThread().getName() + " (" + this.getTitle() + " " + s + " " + ((Object)((Object)this)).toString());
        }
    }
}

