/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.mongodb.mongo;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import java.util.List;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class MongoDB {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private Mongo mongo = null;

    public MongoDB(List<ServerAddress> serverAddresses, MongoClientOptions mongoOptions) {
        this.mongo = new MongoClient(serverAddresses, mongoOptions);
    }

    public DB getDB(String database, String username, String password) {
        DB db;
        boolean authenticated;
        if (log.isDebugEnabled()) {
            log.debug("username: " + username + ", password: " + password + ", database: " + database);
        }
        if (!(authenticated = (db = this.mongo.getDB(database)).isAuthenticated()) && username != null && password != null && username.length() > 0 && password.length() > 0) {
            authenticated = db.authenticate(username, password.toCharArray());
        }
        if (log.isDebugEnabled()) {
            log.debug("authenticated: " + authenticated);
        }
        return db;
    }

    public void clear() {
        if (log.isDebugEnabled()) {
            log.debug("clearing");
        }
        this.mongo.close();
        this.mongo = null;
    }
}

