/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.ldap.config.gui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.ldap.config.gui.LDAPArgument;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.TestElementProperty;

public class LDAPArguments
extends ConfigTestElement
implements Serializable {
    private static final long serialVersionUID = 240L;
    public static final String ARGUMENTS = "Arguments.arguments";

    public LDAPArguments() {
        this.setProperty((JMeterProperty)new CollectionProperty(ARGUMENTS, new ArrayList()));
    }

    public CollectionProperty getArguments() {
        return (CollectionProperty)this.getProperty(ARGUMENTS);
    }

    public void clear() {
        super.clear();
        this.setProperty((JMeterProperty)new CollectionProperty(ARGUMENTS, new ArrayList()));
    }

    public void setArguments(List<Object> arguments) {
        this.setProperty((JMeterProperty)new CollectionProperty(ARGUMENTS, arguments));
    }

    public Map<String, String> getArgumentsAsMap() {
        PropertyIterator iter = this.getArguments().iterator();
        HashMap<String, String> argMap = new HashMap<String, String>();
        while (iter.hasNext()) {
            LDAPArgument arg = (LDAPArgument)iter.next().getObjectValue();
            argMap.put(arg.getName(), arg.getValue());
        }
        return argMap;
    }

    public void addArgument(String name, String value, String opcode) {
        this.addArgument(new LDAPArgument(name, value, opcode, null));
    }

    public void addArgument(LDAPArgument arg) {
        TestElementProperty newArg = new TestElementProperty(arg.getName(), (TestElement)arg);
        if (this.isRunningVersion()) {
            this.setTemporary((JMeterProperty)newArg);
        }
        this.getArguments().addItem((Object)newArg);
    }

    public void addArgument(String name, String value, String opcode, String metadata) {
        this.addArgument(new LDAPArgument(name, value, opcode, metadata));
    }

    public PropertyIterator iterator() {
        return this.getArguments().iterator();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        PropertyIterator iter = this.getArguments().iterator();
        while (iter.hasNext()) {
            LDAPArgument arg = (LDAPArgument)iter.next().getObjectValue();
            String metaData = arg.getMetaData();
            str.append(arg.getName());
            if (metaData == null) {
                str.append("=");
            } else {
                str.append(metaData);
            }
            str.append(arg.getValue());
            if (!iter.hasNext()) continue;
            str.append("&");
        }
        return str.toString();
    }

    public void removeArgument(int row) {
        if (row < this.getArguments().size()) {
            this.getArguments().remove(row);
        }
    }

    public void removeArgument(LDAPArgument arg) {
        PropertyIterator iter = this.getArguments().iterator();
        while (iter.hasNext()) {
            LDAPArgument item = (LDAPArgument)iter.next().getObjectValue();
            if (!arg.equals(item)) continue;
            iter.remove();
        }
    }

    public void removeArgument(String argName) {
        PropertyIterator iter = this.getArguments().iterator();
        while (iter.hasNext()) {
            LDAPArgument arg = (LDAPArgument)iter.next().getObjectValue();
            if (!arg.getName().equals(argName)) continue;
            iter.remove();
        }
    }

    public void removeAllArguments() {
        this.getArguments().clear();
    }

    public void addEmptyArgument() {
        this.addArgument(new LDAPArgument("", "", "", null));
    }

    public int getArgumentCount() {
        return this.getArguments().size();
    }

    public LDAPArgument getArgument(int row) {
        LDAPArgument argument = null;
        if (row < this.getArguments().size()) {
            argument = (LDAPArgument)this.getArguments().get(row).getObjectValue();
        }
        return argument;
    }
}

