/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jdbc.config;

import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.protocol.jdbc.config.DataSourceElement;
import org.apache.jmeter.testbeans.BeanInfoSupport;
import org.apache.jmeter.testbeans.gui.TypeEditor;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceElementBeanInfo
extends BeanInfoSupport {
    private static final Logger log = LoggerFactory.getLogger(DataSourceElementBeanInfo.class);
    private static final Map<String, Integer> TRANSACTION_ISOLATION_MAP = new HashMap<String, Integer>(5);

    public DataSourceElementBeanInfo() {
        super(DataSourceElement.class);
        this.createPropertyGroup("varName", new String[]{"dataSource"});
        this.createPropertyGroup("pool", new String[]{"poolMax", "timeout", "trimInterval", "autocommit", "transactionIsolation", "initQuery"});
        this.createPropertyGroup("keep-alive", new String[]{"keepAlive", "connectionAge", "checkQuery"});
        this.createPropertyGroup("database", new String[]{"dbUrl", "driver", "username", "password"});
        PropertyDescriptor p = this.property("dataSource");
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "");
        p = this.property("poolMax");
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "0");
        p = this.property("timeout");
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "10000");
        p = this.property("trimInterval");
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "60000");
        p = this.property("autocommit");
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", Boolean.TRUE);
        p = this.property("transactionIsolation");
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "DEFAULT");
        p.setValue("notExpression", Boolean.TRUE);
        Set<String> modesSet = TRANSACTION_ISOLATION_MAP.keySet();
        String[] modes = modesSet.toArray(new String[modesSet.size()]);
        p.setValue("tags", modes);
        p = this.property("initQuery", TypeEditor.TextAreaEditor);
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "");
        p = this.property("keepAlive");
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", Boolean.TRUE);
        p = this.property("connectionAge");
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "5000");
        p = this.property("checkQuery", TypeEditor.ComboStringEditor);
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "");
        p.setValue("tags", this.getListCheckQuery());
        p = this.property("dbUrl");
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "");
        p = this.property("driver", TypeEditor.ComboStringEditor);
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "");
        p.setValue("tags", this.getListJDBCDriverClass());
        p = this.property("username");
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "");
        p = this.property("password", TypeEditor.PasswordEditor);
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "");
    }

    public static int getTransactionIsolationMode(String tag) {
        if (!StringUtils.isEmpty((CharSequence)tag)) {
            Integer isolationMode = TRANSACTION_ISOLATION_MAP.get(tag);
            if (isolationMode == null) {
                try {
                    return Integer.parseInt(tag);
                }
                catch (NumberFormatException e) {
                    log.warn("Illegal transaction isolation configuration '" + tag + "'");
                }
            } else {
                return isolationMode;
            }
        }
        return -1;
    }

    private String[] getListJDBCDriverClass() {
        return JOrphanUtils.split((String)JMeterUtils.getPropDefault((String)"jdbc.config.jdbc.driver.class", (String)""), (String)"|");
    }

    private String[] getListCheckQuery() {
        return JOrphanUtils.split((String)JMeterUtils.getPropDefault((String)"jdbc.config.check.query", (String)""), (String)"|");
    }

    static {
        TRANSACTION_ISOLATION_MAP.put("DEFAULT", -1);
        TRANSACTION_ISOLATION_MAP.put("TRANSACTION_NONE", 0);
        TRANSACTION_ISOLATION_MAP.put("TRANSACTION_READ_COMMITTED", 2);
        TRANSACTION_ISOLATION_MAP.put("TRANSACTION_READ_UNCOMMITTED", 1);
        TRANSACTION_ISOLATION_MAP.put("TRANSACTION_REPEATABLE_READ", 4);
        TRANSACTION_ISOLATION_MAP.put("TRANSACTION_SERIALIZABLE", 8);
    }
}

