/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.sampler;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.protocol.java.sampler.AbstractJavaSamplerClient;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerClient;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerContext;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class JavaSampler
extends AbstractSampler
implements TestListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 232L;
    public static final String CLASSNAME = "classname";
    public static final String ARGUMENTS = "arguments";
    private transient JavaSamplerClient javaClient = null;
    private transient JavaSamplerContext context = null;
    private static final Set<JavaSampler> allSamplers = new HashSet<JavaSampler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaSampler() {
        this.setArguments(new Arguments());
        Set<JavaSampler> set = allSamplers;
        synchronized (set) {
            allSamplers.add(this);
        }
    }

    public void setArguments(Arguments args) {
        this.setProperty((JMeterProperty)new TestElementProperty(ARGUMENTS, (TestElement)args));
    }

    public Arguments getArguments() {
        return (Arguments)this.getProperty(ARGUMENTS).getObjectValue();
    }

    private void releaseJavaClient() {
        if (this.javaClient != null) {
            this.javaClient.teardownTest(this.context);
        }
        this.javaClient = null;
        this.context = null;
    }

    public void setClassname(String classname) {
        this.setProperty(CLASSNAME, classname);
    }

    public String getClassname() {
        return this.getPropertyAsString(CLASSNAME);
    }

    public SampleResult sample(Entry entry) {
        SampleResult result;
        Arguments args = this.getArguments();
        args.addArgument("TestElement.name", this.getName());
        this.context = new JavaSamplerContext(args);
        if (this.javaClient == null) {
            log.debug(this.whoAmI() + "Creating Java Client");
            this.createJavaClient();
            this.javaClient.setupTest(this.context);
        }
        if ((result = this.createJavaClient().runTest(this.context)) != null && result.getSampleLabel().length() == 0) {
            result.setSampleLabel(this.getName());
        }
        return result;
    }

    private JavaSamplerClient createJavaClient() {
        if (this.javaClient == null) {
            try {
                Class<?> javaClass = Class.forName(this.getClassname().trim(), false, Thread.currentThread().getContextClassLoader());
                this.javaClient = (JavaSamplerClient)javaClass.newInstance();
                this.context = new JavaSamplerContext(this.getArguments());
                if (log.isDebugEnabled()) {
                    log.debug(this.whoAmI() + "\tCreated:\t" + this.getClassname() + "@" + Integer.toHexString(this.javaClient.hashCode()));
                }
            }
            catch (Exception e) {
                log.error(this.whoAmI() + "\tException creating: " + this.getClassname(), (Throwable)e);
                this.javaClient = new ErrorSamplerClient();
            }
        }
        return this.javaClient;
    }

    private String whoAmI() {
        StringBuilder sb = new StringBuilder();
        sb.append(Thread.currentThread().getName());
        sb.append("@");
        sb.append(Integer.toHexString(this.hashCode()));
        sb.append("-");
        sb.append(this.getName());
        return sb.toString();
    }

    public void testStarted() {
        log.debug(this.whoAmI() + "\ttestStarted");
    }

    public void testStarted(String host) {
        log.debug(this.whoAmI() + "\ttestStarted(" + host + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnded() {
        log.debug(this.whoAmI() + "\ttestEnded");
        Set<JavaSampler> set = allSamplers;
        synchronized (set) {
            Iterator<JavaSampler> i = allSamplers.iterator();
            while (i.hasNext()) {
                JavaSampler sampler = i.next();
                sampler.releaseJavaClient();
                i.remove();
            }
        }
    }

    public void testEnded(String host) {
        this.testEnded();
    }

    public void testIterationStart(LoopIterationEvent event) {
    }

    class ErrorSamplerClient
    extends AbstractJavaSamplerClient {
        ErrorSamplerClient() {
        }

        public SampleResult runTest(JavaSamplerContext p_context) {
            log.debug(JavaSampler.this.whoAmI() + "\trunTest");
            Thread.yield();
            SampleResult results = new SampleResult();
            results.setSuccessful(false);
            results.setResponseData("Class not found: " + JavaSampler.this.getClassname(), null);
            results.setSampleLabel("ERROR: " + JavaSampler.this.getClassname());
            return results;
        }
    }
}

