/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.net.BindException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.gui.LogicControllerGui;
import org.apache.jmeter.control.gui.TreeNodeWrapper;
import org.apache.jmeter.engine.util.ValueReplacer;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.UnsharedComponent;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.http.control.RecordingController;
import org.apache.jmeter.protocol.http.proxy.ProxyControl;
import org.apache.jmeter.protocol.http.proxy.gui.RecorderDialog;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFactory;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.JLabeledTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyControlGui
extends LogicControllerGui
implements JMeterGUIComponent,
ActionListener,
ItemListener,
KeyListener,
UnsharedComponent {
    private static final Logger log = LoggerFactory.getLogger(ProxyControlGui.class);
    private static final long serialVersionUID = 232L;
    private static final String NEW_LINE = "\n";
    private static final String SPACE = " ";
    private static final String USE_DEFAULT_HTTP_IMPL = "";
    private static final String SUGGESTED_EXCLUSIONS = JMeterUtils.getPropDefault((String)"proxy.excludes.suggested", (String)"(?i).*\\.(bmp|css|js|gif|ico|jpe?g|png|swf|woff|woff2)");
    private JTextField portField;
    private JLabeledTextField sslDomains;
    private JCheckBox httpHeaders;
    private JComboBox<String> groupingMode;
    private JCheckBox addAssertions;
    private JCheckBox useKeepAlive;
    private JCheckBox regexMatch;
    private JComboBox<String> samplerTypeName;
    private JCheckBox samplerRedirectAutomatically;
    private JCheckBox samplerFollowRedirects;
    private JCheckBox samplerDownloadImages;
    private JTextField defaultEncoding;
    private JComboBox<String> httpSampleNamingMode;
    private JTextField prefixHTTPSampleName;
    private JTextField proxyPauseHTTPSample;
    private JTextField contentTypeInclude;
    private JTextField contentTypeExclude;
    private JComboBox<Object> targetNodes;
    private JCheckBox notifyChildSamplerListenerOfFilteredSamplersCB;
    private DefaultComboBoxModel<Object> targetNodesModel;
    private ProxyControl model;
    private JTable excludeTable;
    private PowerTableModel excludeModel;
    private JTable includeTable;
    private PowerTableModel includeModel;
    private static final String CHANGE_TARGET = "change_target";
    private JButton stop;
    private JButton start;
    private JButton restart;
    private transient RecorderDialog recorderDialog;
    private Component labelDefaultEncoding;
    private static final String ACTION_STOP = "stop";
    private static final String ACTION_START = "start";
    private static final String ACTION_RESTART = "restart";
    static final String ENABLE_RESTART = "enable_restart";
    private static final String ADD_INCLUDE = "add_include";
    private static final String ADD_EXCLUDE = "add_exclude";
    private static final String DELETE_INCLUDE = "delete_include";
    private static final String DELETE_EXCLUDE = "delete_exclude";
    private static final String ADD_TO_INCLUDE_FROM_CLIPBOARD = "include_clipboard";
    private static final String ADD_TO_EXCLUDE_FROM_CLIPBOARD = "exclude_clipboard";
    private static final String ADD_SUGGESTED_EXCLUDES = "exclude_suggested";
    static final String HTTP_SAMPLER_NAMING_MODE = "proxy_http_sampler_naming_mode";
    static final String PREFIX_HTTP_SAMPLER_NAME = "proxy_prefix_http_sampler_name";
    static final String PROXY_PAUSE_HTTP_SAMPLER = "proxy_pause_http_sampler";
    private static final String INCLUDE_COL = "patterns_to_include";
    private static final String EXCLUDE_COL = "patterns_to_exclude";
    private static final String PORT_FIELD_NAME = "portField";

    public ProxyControlGui() {
        log.debug("Creating ProxyControlGui");
        this.init();
        try {
            this.recorderDialog = new RecorderDialog(this);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
    }

    public TestElement createTestElement() {
        this.model = this.makeProxyControl();
        log.debug("creating/configuring model = {}", (Object)this.model);
        this.modifyTestElement((TestElement)this.model);
        return this.model;
    }

    protected ProxyControl makeProxyControl() {
        return new ProxyControl();
    }

    public void modifyTestElement(TestElement el) {
        GuiUtils.stopTableEditing((JTable)this.excludeTable);
        GuiUtils.stopTableEditing((JTable)this.includeTable);
        this.configureTestElement(el);
        if (el instanceof ProxyControl) {
            this.model = (ProxyControl)el;
            this.model.setPort(this.portField.getText());
            this.model.setSslDomains(this.sslDomains.getText());
            this.setIncludeListInProxyControl(this.model);
            this.setExcludeListInProxyControl(this.model);
            this.model.setCaptureHttpHeaders(this.httpHeaders.isSelected());
            this.model.setGroupingMode(this.groupingMode.getSelectedIndex());
            this.model.setAssertions(this.addAssertions.isSelected());
            if (this.samplerTypeName.getSelectedIndex() < HTTPSamplerFactory.getImplementations().length) {
                this.model.setSamplerTypeName(HTTPSamplerFactory.getImplementations()[this.samplerTypeName.getSelectedIndex()]);
            } else {
                this.model.setSamplerTypeName(USE_DEFAULT_HTTP_IMPL);
            }
            this.model.setSamplerRedirectAutomatically(this.samplerRedirectAutomatically.isSelected());
            this.model.setSamplerFollowRedirects(this.samplerFollowRedirects.isSelected());
            this.model.setUseKeepAlive(this.useKeepAlive.isSelected());
            this.model.setSamplerDownloadImages(this.samplerDownloadImages.isSelected());
            this.model.setHTTPSampleNamingMode(this.httpSampleNamingMode.getSelectedIndex());
            this.model.setDefaultEncoding(this.defaultEncoding.getText());
            this.model.setPrefixHTTPSampleName(this.prefixHTTPSampleName.getText());
            this.model.setProxyPauseHTTPSample(this.proxyPauseHTTPSample.getText());
            this.model.setNotifyChildSamplerListenerOfFilteredSamplers(this.notifyChildSamplerListenerOfFilteredSamplersCB.isSelected());
            this.model.setRegexMatch(this.regexMatch.isSelected());
            this.model.setContentTypeInclude(this.contentTypeInclude.getText());
            this.model.setContentTypeExclude(this.contentTypeExclude.getText());
            TreeNodeWrapper nw = (TreeNodeWrapper)this.targetNodes.getSelectedItem();
            if (nw == null) {
                this.model.setTarget(null);
            } else {
                this.model.setTarget(nw.getTreeNode());
            }
        }
    }

    protected void setIncludeListInProxyControl(ProxyControl element) {
        List<String> includeList = this.getDataList(this.includeModel, INCLUDE_COL);
        element.setIncludeList(includeList);
    }

    protected void setExcludeListInProxyControl(ProxyControl element) {
        List<String> excludeList = this.getDataList(this.excludeModel, EXCLUDE_COL);
        element.setExcludeList(excludeList);
    }

    private List<String> getDataList(PowerTableModel pModel, String colName) {
        String[] dataArray = pModel.getData().getColumn(colName);
        LinkedList<String> list = new LinkedList<String>();
        for (String data : dataArray) {
            list.add(data);
        }
        return list;
    }

    public String getLabelResource() {
        return "proxy_title";
    }

    public Collection<String> getMenuCategories() {
        return Arrays.asList("menu_non_test_elements");
    }

    public void configure(TestElement element) {
        log.debug("Configuring gui with {}", (Object)element);
        super.configure(element);
        this.model = (ProxyControl)element;
        this.portField.setText(this.model.getPortString());
        this.sslDomains.setText(this.model.getSslDomains());
        this.httpHeaders.setSelected(this.model.getCaptureHttpHeaders());
        this.groupingMode.setSelectedIndex(this.model.getGroupingMode());
        this.addAssertions.setSelected(this.model.getAssertions());
        this.samplerTypeName.setSelectedItem(this.model.getSamplerTypeName());
        this.samplerRedirectAutomatically.setSelected(this.model.getSamplerRedirectAutomatically());
        this.samplerFollowRedirects.setSelected(this.model.getSamplerFollowRedirects());
        this.useKeepAlive.setSelected(this.model.getUseKeepalive());
        this.samplerDownloadImages.setSelected(this.model.getSamplerDownloadImages());
        this.httpSampleNamingMode.setSelectedIndex(this.model.getHTTPSampleNamingMode());
        this.prefixHTTPSampleName.setText(this.model.getPrefixHTTPSampleName());
        this.defaultEncoding.setText(this.model.getDefaultEncoding());
        this.proxyPauseHTTPSample.setText(this.model.getProxyPauseHTTPSample());
        this.notifyChildSamplerListenerOfFilteredSamplersCB.setSelected(this.model.getNotifyChildSamplerListenerOfFilteredSamplers());
        this.regexMatch.setSelected(this.model.getRegexMatch());
        this.contentTypeInclude.setText(this.model.getContentTypeInclude());
        this.contentTypeExclude.setText(this.model.getContentTypeExclude());
        this.reinitializeTargetCombo();
        this.populateTable(this.includeModel, this.model.getIncludePatterns().iterator());
        this.populateTable(this.excludeModel, this.model.getExcludePatterns().iterator());
        this.repaint();
    }

    private void populateTable(PowerTableModel pModel, PropertyIterator iter) {
        pModel.clearData();
        while (iter.hasNext()) {
            pModel.addRow(new Object[]{iter.next().getStringValue()});
        }
        pModel.fireTableDataChanged();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() instanceof JComboBox) {
            JComboBox combo = (JComboBox)e.getSource();
            if (HTTP_SAMPLER_NAMING_MODE.equals(combo.getName())) {
                this.model.setHTTPSampleNamingMode(this.httpSampleNamingMode.getSelectedIndex());
            }
        } else {
            this.enableRestart();
        }
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        String command = action.getActionCommand();
        Object source = action.getSource();
        if (source.equals(this.samplerFollowRedirects) && this.samplerFollowRedirects.isSelected()) {
            this.samplerRedirectAutomatically.setSelected(false);
        } else if (source.equals(this.samplerRedirectAutomatically) && this.samplerRedirectAutomatically.isSelected()) {
            this.samplerFollowRedirects.setSelected(false);
        }
        if (command.equals(ACTION_STOP)) {
            this.stopRecorder();
        } else if (command.equals(ACTION_START)) {
            if (this.startProxy()) {
                this.recorderDialog.setVisible(true);
            }
        } else if (command.equals(ACTION_RESTART)) {
            this.model.stopProxy();
            if (this.startProxy()) {
                this.recorderDialog.setVisible(true);
            }
        } else if (command.equals(ENABLE_RESTART)) {
            this.enableRestart();
        } else if (command.equals(ADD_EXCLUDE)) {
            this.excludeModel.addNewRow();
            this.excludeModel.fireTableDataChanged();
            this.enableRestart();
        } else if (command.equals(ADD_INCLUDE)) {
            this.includeModel.addNewRow();
            this.includeModel.fireTableDataChanged();
            this.enableRestart();
        } else if (command.equals(DELETE_EXCLUDE)) {
            this.deleteRowFromTable(this.excludeModel, this.excludeTable);
        } else if (command.equals(DELETE_INCLUDE)) {
            this.deleteRowFromTable(this.includeModel, this.includeTable);
        } else if (command.equals(CHANGE_TARGET)) {
            log.debug("Change target {} in model {}", this.targetNodes.getSelectedItem(), (Object)this.model);
            TreeNodeWrapper nw = (TreeNodeWrapper)this.targetNodes.getSelectedItem();
            this.model.setTarget(nw.getTreeNode());
            this.enableRestart();
        } else if (command.equals(ADD_TO_INCLUDE_FROM_CLIPBOARD)) {
            this.addFromClipboard(this.includeTable);
            this.includeModel.fireTableDataChanged();
            this.enableRestart();
        } else if (command.equals(ADD_TO_EXCLUDE_FROM_CLIPBOARD)) {
            this.addFromClipboard(this.excludeTable);
            this.excludeModel.fireTableDataChanged();
            this.enableRestart();
        } else if (command.equals(ADD_SUGGESTED_EXCLUDES)) {
            this.addSuggestedExcludes(this.excludeTable);
            this.excludeModel.fireTableDataChanged();
            this.enableRestart();
        }
    }

    void stopRecorder() {
        this.model.stopProxy();
        this.stop.setEnabled(false);
        this.start.setEnabled(true);
        this.restart.setEnabled(false);
        this.recorderDialog.setVisible(false);
    }

    private void deleteRowFromTable(PowerTableModel tableModel, JTable table) {
        int selectedRow = table.getSelectedRow();
        if (selectedRow >= 0) {
            tableModel.removeRow(table.getSelectedRow());
        } else if (table.getRowCount() > 0) {
            tableModel.removeRow(0);
        }
        tableModel.fireTableDataChanged();
        if (table.getRowCount() > 0) {
            if (selectedRow == -1) {
                table.setRowSelectionInterval(0, 0);
            } else {
                int rowToSelect = selectedRow > 0 ? selectedRow - 1 : 0;
                table.setRowSelectionInterval(rowToSelect, rowToSelect);
            }
        }
        this.enableRestart();
    }

    protected void addSuggestedExcludes(JTable table) {
        PowerTableModel model;
        GuiUtils.stopTableEditing((JTable)table);
        int rowCount = table.getRowCount();
        String[] exclusions = SUGGESTED_EXCLUSIONS.split(";");
        if (exclusions.length > 0 && (model = (PowerTableModel)table.getModel()) != null) {
            for (String clipboardLine : exclusions) {
                model.addRow(new Object[]{clipboardLine});
            }
            if (table.getRowCount() > rowCount) {
                int rowToSelect = model.getRowCount() - 1;
                table.setRowSelectionInterval(rowCount, rowToSelect);
            }
        }
    }

    protected void addFromClipboard(JTable table) {
        GuiUtils.stopTableEditing((JTable)table);
        int rowCount = table.getRowCount();
        try {
            String clipboardContent = GuiUtils.getPastedText();
            if (clipboardContent != null) {
                String[] clipboardLines;
                PowerTableModel model = null;
                for (String clipboardLine : clipboardLines = clipboardContent.split(NEW_LINE)) {
                    model = (PowerTableModel)table.getModel();
                    model.addRow(new Object[]{clipboardLine});
                }
                if (model != null && table.getRowCount() > rowCount) {
                    int rowToSelect = model.getRowCount() - 1;
                    table.setRowSelectionInterval(rowCount, rowToSelect);
                }
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog((Component)((Object)this), JMeterUtils.getResString((String)"proxy_daemon_error_read_args") + NEW_LINE + ioe.getLocalizedMessage(), JMeterUtils.getResString((String)"error_title"), 0);
        }
        catch (UnsupportedFlavorException ufe) {
            JOptionPane.showMessageDialog((Component)((Object)this), JMeterUtils.getResString((String)"proxy_daemon_error_not_retrieve") + SPACE + DataFlavor.stringFlavor.getHumanPresentableName() + SPACE + JMeterUtils.getResString((String)"proxy_daemon_error_from_clipboard") + ufe.getLocalizedMessage(), JMeterUtils.getResString((String)"error_title"), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startProxy() {
        JMeterTreeNode targetNode;
        ValueReplacer replacer = GuiPackage.getInstance().getReplacer();
        this.modifyTestElement((TestElement)this.model);
        TreeNodeWrapper treeNodeWrapper = (TreeNodeWrapper)this.targetNodesModel.getSelectedItem();
        if (JMeterUtils.getResString((String)"use_recording_controller").equals(treeNodeWrapper.getLabel()) && ((targetNode = this.model.findTargetControllerNode()) == null || !(targetNode.getTestElement() instanceof RecordingController))) {
            JOptionPane.showMessageDialog((Component)((Object)this), JMeterUtils.getResString((String)"proxy_cl_wrong_target_cl"), JMeterUtils.getResString((String)"error_title"), 0);
            return false;
        }
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            replacer.replaceValues((TestElement)this.model);
            this.model.startProxy();
            this.start.setEnabled(false);
            this.stop.setEnabled(true);
            this.restart.setEnabled(false);
            if (ProxyControl.isDynamicMode()) {
                String[] details = this.model.getCertificateDetails();
                StringBuilder sb = new StringBuilder();
                sb.append("<html>");
                sb.append(JMeterUtils.getResString((String)"proxy_daemon_msg_rootca_cert")).append("&nbsp;<b>").append("ApacheJMeterTemporaryRootCA").append("</b>&nbsp;").append(JMeterUtils.getResString((String)"proxy_daemon_msg_created_in_bin"));
                sb.append("<br>").append(JMeterUtils.getResString((String)"proxy_daemon_msg_install_as_in_doc"));
                sb.append("<br><b>").append(MessageFormat.format(JMeterUtils.getResString((String)"proxy_daemon_msg_check_expiration"), ProxyControl.CERT_VALIDITY)).append("</b><br>");
                sb.append("<br>").append(JMeterUtils.getResString((String)"proxy_daemon_msg_check_details")).append("<ul>");
                for (String detail : details) {
                    sb.append("<li>").append(detail).append("</li>");
                }
                sb.append("</ul>").append("</html>");
                JLabel messageLabel = new JLabel(sb.toString());
                Timer timer = new Timer(7000, evt -> {
                    Window window = SwingUtilities.getWindowAncestor(messageLabel);
                    if (window != null) {
                        window.dispose();
                    }
                });
                timer.setRepeats(false);
                timer.start();
                JOptionPane.showMessageDialog((Component)((Object)this), messageLabel, JMeterUtils.getResString((String)"proxy_daemon_msg_rootca_cert") + SPACE + "ApacheJMeterTemporaryRootCA" + SPACE + JMeterUtils.getResString((String)"proxy_daemon_msg_created_in_bin"), 1);
            }
            boolean details = true;
            return details;
        }
        catch (InvalidVariableException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), JMeterUtils.getResString((String)"invalid_variables") + ": " + e.getMessage(), JMeterUtils.getResString((String)"error_title"), 0);
            boolean bl = false;
            return bl;
        }
        catch (BindException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), JMeterUtils.getResString((String)"proxy_daemon_bind_error") + ": " + e.getMessage(), JMeterUtils.getResString((String)"error_title"), 0);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), JMeterUtils.getResString((String)"proxy_daemon_error") + ": " + e.getMessage(), JMeterUtils.getResString((String)"error_title"), 0);
            boolean bl = false;
            return bl;
        }
        finally {
            this.setCursor(cursor);
        }
    }

    void enableRestart() {
        if (this.stop.isEnabled()) {
            this.restart.setEnabled(true);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        String fieldName = e.getComponent().getName();
        if (fieldName.equals(PORT_FIELD_NAME)) {
            block11: {
                try {
                    int port = Integer.parseInt(this.portField.getText());
                    log.debug("Using port {} for recording", (Object)port);
                }
                catch (NumberFormatException nfe) {
                    int length = this.portField.getText().length();
                    if (length <= 0) break block11;
                    JOptionPane.showMessageDialog((Component)((Object)this), JMeterUtils.getResString((String)"proxy_settings_port_error_digits"), JMeterUtils.getResString((String)"proxy_settings_port_error_invalid_data"), 2);
                    this.portField.setText(this.portField.getText().substring(0, length - 1));
                }
            }
            this.enableRestart();
        } else if (fieldName.equals(ENABLE_RESTART)) {
            this.enableRestart();
        } else if (fieldName.equals(PREFIX_HTTP_SAMPLER_NAME)) {
            this.model.setPrefixHTTPSampleName(this.prefixHTTPSampleName.getText());
        } else if (fieldName.equals(PROXY_PAUSE_HTTP_SAMPLER)) {
            block12: {
                try {
                    Long.parseLong(this.proxyPauseHTTPSample.getText());
                }
                catch (NumberFormatException nfe) {
                    int length = this.proxyPauseHTTPSample.getText().length();
                    if (length <= 0) break block12;
                    JOptionPane.showMessageDialog((Component)((Object)this), JMeterUtils.getResString((String)"proxy_settings_pause_error_digits"), JMeterUtils.getResString((String)"proxy_settings_pause_error_invalid_data"), 2);
                    this.proxyPauseHTTPSample.setText(this.proxyPauseHTTPSample.getText().substring(0, length - 1));
                }
            }
            this.model.setProxyPauseHTTPSample(this.proxyPauseHTTPSample.getText());
            this.enableRestart();
        }
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.createControls(), "North");
        JTabbedPane tabbedPane = new JTabbedPane();
        VerticalPanel testPlanPanel = new VerticalPanel();
        testPlanPanel.add(this.createTestPlanContentPanel());
        testPlanPanel.add(Box.createVerticalStrut(5));
        testPlanPanel.add(this.createHTTPSamplerPanel());
        tabbedPane.add(JMeterUtils.getResString((String)"proxy_test_plan_creation"), (Component)testPlanPanel);
        VerticalPanel filteringPanel = new VerticalPanel();
        tabbedPane.add(JMeterUtils.getResString((String)"proxy_test_plan_filtering"), (Component)filteringPanel);
        filteringPanel.add(this.createContentTypePanel());
        filteringPanel.add(this.createIncludePanel());
        filteringPanel.add(this.createExcludePanel());
        filteringPanel.add(this.createNotifyListenersPanel());
        VerticalPanel vPanel = new VerticalPanel();
        vPanel.add(this.createPortPanel());
        vPanel.add(Box.createVerticalStrut(5));
        vPanel.add(tabbedPane);
        mainPanel.add((Component)vPanel, "Center");
        this.add(mainPanel, "Center");
    }

    private JPanel createControls() {
        String iconSize = JMeterUtils.getPropDefault((String)"jmeter.toolbar.icons.size", (String)"22x22");
        this.start = new JButton(JMeterUtils.getResString((String)ACTION_START));
        ImageIcon startImage = JMeterUtils.getImage((String)("toolbar/" + iconSize + "/arrow-right-3.png"));
        this.start.setIcon(startImage);
        this.start.addActionListener(this);
        this.start.setActionCommand(ACTION_START);
        this.start.setEnabled(true);
        this.stop = this.createStopButton(iconSize);
        this.stop.addActionListener(this);
        ImageIcon restartImage = JMeterUtils.getImage((String)("toolbar/" + iconSize + "/edit-redo-7.png"));
        this.restart = new JButton(JMeterUtils.getResString((String)ACTION_RESTART));
        this.restart.setIcon(restartImage);
        this.restart.addActionListener(this);
        this.restart.setActionCommand(ACTION_RESTART);
        this.restart.setEnabled(false);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"proxy_general_lifecycle")));
        panel.add(this.start);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.stop);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.restart);
        return panel;
    }

    JButton createStopButton(String iconSize) {
        JButton stop = new JButton(JMeterUtils.getResString((String)ACTION_STOP));
        ImageIcon stopImage = JMeterUtils.getImage((String)("toolbar/" + iconSize + "/process-stop-4.png"));
        stop.setIcon(stopImage);
        stop.setActionCommand(ACTION_STOP);
        stop.setEnabled(false);
        return stop;
    }

    private JPanel createPortPanel() {
        this.portField = new JTextField(ProxyControl.DEFAULT_PORT_S, 20);
        this.portField.setName(PORT_FIELD_NAME);
        this.portField.addKeyListener(this);
        Dimension portPreferredSize = this.portField.getPreferredSize();
        this.portField.setMinimumSize(new Dimension((int)Math.round((double)portPreferredSize.width * 0.75), portPreferredSize.height));
        JLabel label = new JLabel(JMeterUtils.getResString((String)"port"));
        label.setLabelFor(this.portField);
        HorizontalPanel panel = new HorizontalPanel();
        panel.add((Component)label);
        panel.add((Component)this.portField);
        this.sslDomains = new JLabeledTextField(JMeterUtils.getResString((String)"proxy_domains"));
        this.sslDomains.setEnabled(ProxyControl.isDynamicMode());
        if (ProxyControl.isDynamicMode()) {
            this.sslDomains.setToolTipText(JMeterUtils.getResString((String)"proxy_domains_dynamic_mode_tooltip"));
        } else {
            this.sslDomains.setToolTipText(JMeterUtils.getResString((String)"proxy_domains_dynamic_mode_tooltip_java6"));
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JPanel gPane = new JPanel(gridBagLayout);
        gPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"proxy_general_settings")));
        gPane.add((Component)panel, gbc.clone());
        ++gbc.gridx;
        gbc.fill = 2;
        gbc.weightx = 6.0;
        gPane.add((Component)this.sslDomains, gbc);
        return gPane;
    }

    private JPanel createTestPlanContentPanel() {
        this.httpHeaders = new JCheckBox(JMeterUtils.getResString((String)"proxy_headers"));
        this.httpHeaders.setSelected(true);
        this.httpHeaders.addActionListener(this);
        this.httpHeaders.setActionCommand(ENABLE_RESTART);
        this.addAssertions = new JCheckBox(JMeterUtils.getResString((String)"proxy_assertions"));
        this.addAssertions.setSelected(false);
        this.addAssertions.addActionListener(this);
        this.addAssertions.setActionCommand(ENABLE_RESTART);
        this.regexMatch = new JCheckBox(JMeterUtils.getResString((String)"proxy_regex"));
        this.regexMatch.setSelected(false);
        this.regexMatch.addActionListener(this);
        this.regexMatch.setActionCommand(ENABLE_RESTART);
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"proxy_test_plan_content")));
        HorizontalPanel nodeCreationPanel = new HorizontalPanel();
        nodeCreationPanel.add((Component)this.createGroupingPanel());
        nodeCreationPanel.add((Component)this.httpHeaders);
        nodeCreationPanel.add((Component)this.addAssertions);
        nodeCreationPanel.add((Component)this.regexMatch);
        HorizontalPanel targetPanel = new HorizontalPanel();
        targetPanel.add((Component)this.createTargetPanel());
        mainPanel.add((Component)targetPanel);
        mainPanel.add((Component)nodeCreationPanel);
        return mainPanel;
    }

    private JPanel createHTTPSamplerPanel() {
        DefaultComboBoxModel<String> m = new DefaultComboBoxModel<String>();
        for (String s : HTTPSamplerFactory.getImplementations()) {
            m.addElement(s);
        }
        m.addElement(USE_DEFAULT_HTTP_IMPL);
        this.samplerTypeName = new JComboBox(m);
        this.samplerTypeName.setSelectedItem(USE_DEFAULT_HTTP_IMPL);
        this.samplerTypeName.addItemListener(this);
        JLabel labelSamplerType = new JLabel(JMeterUtils.getResString((String)"proxy_sampler_type"));
        labelSamplerType.setLabelFor(this.samplerTypeName);
        this.samplerRedirectAutomatically = new JCheckBox(JMeterUtils.getResString((String)"follow_redirects_auto"));
        this.samplerRedirectAutomatically.setSelected(false);
        this.samplerRedirectAutomatically.addActionListener(this);
        this.samplerRedirectAutomatically.setActionCommand(ENABLE_RESTART);
        this.samplerFollowRedirects = new JCheckBox(JMeterUtils.getResString((String)"follow_redirects"));
        this.samplerFollowRedirects.setSelected(true);
        this.samplerFollowRedirects.addActionListener(this);
        this.samplerFollowRedirects.setActionCommand(ENABLE_RESTART);
        this.useKeepAlive = new JCheckBox(JMeterUtils.getResString((String)"use_keepalive"));
        this.useKeepAlive.setSelected(true);
        this.useKeepAlive.addActionListener(this);
        this.useKeepAlive.setActionCommand(ENABLE_RESTART);
        this.samplerDownloadImages = new JCheckBox(JMeterUtils.getResString((String)"web_testing_retrieve_images"));
        this.samplerDownloadImages.setSelected(false);
        this.samplerDownloadImages.addActionListener(this);
        this.samplerDownloadImages.setActionCommand(ENABLE_RESTART);
        DefaultComboBoxModel<String> choice = new DefaultComboBoxModel<String>();
        choice.addElement(JMeterUtils.getResString((String)"sample_name_prefix"));
        choice.addElement(JMeterUtils.getResString((String)"sample_name_transaction"));
        this.httpSampleNamingMode = new JComboBox(choice);
        this.httpSampleNamingMode.setName(HTTP_SAMPLER_NAMING_MODE);
        this.httpSampleNamingMode.addItemListener(this);
        this.defaultEncoding = new JTextField(15);
        this.prefixHTTPSampleName = new JTextField(20);
        this.prefixHTTPSampleName.addKeyListener(this);
        this.prefixHTTPSampleName.setName(PREFIX_HTTP_SAMPLER_NAME);
        this.proxyPauseHTTPSample = new JTextField(10);
        this.proxyPauseHTTPSample.addKeyListener(this);
        this.proxyPauseHTTPSample.setName(PROXY_PAUSE_HTTP_SAMPLER);
        this.proxyPauseHTTPSample.setActionCommand(ENABLE_RESTART);
        JLabel labelProxyPause = new JLabel(JMeterUtils.getResString((String)PROXY_PAUSE_HTTP_SAMPLER));
        labelProxyPause.setLabelFor(this.proxyPauseHTTPSample);
        JLabel labelDefaultEncoding = new JLabel(JMeterUtils.getResString((String)"proxy_default_encoding"));
        labelDefaultEncoding.setLabelFor(this.defaultEncoding);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 23;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JPanel panel = new JPanel(gridBagLayout);
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"proxy_sampler_settings")));
        panel.add(this.httpSampleNamingMode, gbc.clone());
        ++gbc.gridx;
        gbc.weightx = 3.0;
        gbc.fill = 2;
        panel.add((Component)this.prefixHTTPSampleName, gbc.clone());
        gbc.gridx = 0;
        ++gbc.gridy;
        panel.add((Component)labelProxyPause, gbc.clone());
        ++gbc.gridx;
        gbc.weightx = 3.0;
        gbc.fill = 2;
        panel.add((Component)this.proxyPauseHTTPSample, gbc.clone());
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        ++gbc.gridy;
        panel.add((Component)labelDefaultEncoding, gbc.clone());
        ++gbc.gridx;
        gbc.weightx = 3.0;
        gbc.fill = 2;
        panel.add((Component)this.defaultEncoding, gbc.clone());
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 3;
        panel.add((Component)this.samplerDownloadImages, gbc.clone());
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 3;
        panel.add((Component)this.samplerRedirectAutomatically, gbc.clone());
        ++gbc.gridx;
        gbc.fill = 2;
        panel.add((Component)this.samplerFollowRedirects, gbc.clone());
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 3;
        panel.add((Component)this.useKeepAlive, gbc.clone());
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 3;
        panel.add((Component)labelSamplerType, gbc.clone());
        ++gbc.gridx;
        gbc.fill = 2;
        panel.add(this.samplerTypeName, gbc.clone());
        return panel;
    }

    private JPanel createTargetPanel() {
        this.targetNodesModel = new DefaultComboBoxModel();
        this.targetNodes = new JComboBox<Object>(this.targetNodesModel);
        this.targetNodes.setPrototypeDisplayValue(USE_DEFAULT_HTTP_IMPL);
        JPopupMenu popup = (JPopupMenu)this.targetNodes.getUI().getAccessibleChild(this.targetNodes, 0);
        JScrollPane scrollPane = this.findScrollPane(popup);
        if (scrollPane != null) {
            scrollPane.setHorizontalScrollBar(new JScrollBar(0));
            scrollPane.setHorizontalScrollBarPolicy(30);
        }
        this.targetNodes.setActionCommand(CHANGE_TARGET);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"proxy_target"));
        label.setLabelFor(this.targetNodes);
        HorizontalPanel panel = new HorizontalPanel();
        panel.add((Component)label);
        panel.add(this.targetNodes);
        return panel;
    }

    private JScrollPane findScrollPane(JPopupMenu popup) {
        Component[] components;
        for (Component component : components = popup.getComponents()) {
            if (!(component instanceof JScrollPane)) continue;
            return (JScrollPane)component;
        }
        return null;
    }

    private JPanel createGroupingPanel() {
        DefaultComboBoxModel<String> m = new DefaultComboBoxModel<String>();
        m.addElement(JMeterUtils.getResString((String)"grouping_no_groups"));
        m.addElement(JMeterUtils.getResString((String)"grouping_add_separators"));
        m.addElement(JMeterUtils.getResString((String)"grouping_in_controllers"));
        m.addElement(JMeterUtils.getResString((String)"grouping_store_first_only"));
        m.addElement(JMeterUtils.getResString((String)"grouping_in_transaction_controllers"));
        this.groupingMode = new JComboBox(m);
        this.groupingMode.setPreferredSize(new Dimension(150, 20));
        this.groupingMode.setSelectedIndex(0);
        this.groupingMode.addItemListener(this);
        JLabel label2 = new JLabel(JMeterUtils.getResString((String)"grouping_mode"));
        label2.setLabelFor(this.groupingMode);
        HorizontalPanel panel = new HorizontalPanel();
        panel.add((Component)label2);
        panel.add(this.groupingMode);
        return panel;
    }

    private JPanel createContentTypePanel() {
        this.contentTypeInclude = new JTextField(35);
        this.contentTypeInclude.addKeyListener(this);
        this.contentTypeInclude.setName(ENABLE_RESTART);
        JLabel labelInclude = new JLabel(JMeterUtils.getResString((String)"proxy_content_type_include"));
        labelInclude.setLabelFor(this.contentTypeInclude);
        this.contentTypeInclude.setText(JMeterUtils.getProperty((String)"proxy.content_type_include"));
        this.contentTypeExclude = new JTextField(35);
        this.contentTypeExclude.addKeyListener(this);
        this.contentTypeExclude.setName(ENABLE_RESTART);
        JLabel labelExclude = new JLabel(JMeterUtils.getResString((String)"proxy_content_type_exclude"));
        labelExclude.setLabelFor(this.contentTypeExclude);
        this.contentTypeExclude.setText(JMeterUtils.getProperty((String)"proxy.content_type_exclude"));
        HorizontalPanel panel = new HorizontalPanel();
        panel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"proxy_content_type_filter")));
        panel.add((Component)labelInclude);
        panel.add((Component)this.contentTypeInclude);
        panel.add((Component)labelExclude);
        panel.add((Component)this.contentTypeExclude);
        return panel;
    }

    private JPanel createIncludePanel() {
        this.includeModel = new PowerTableModel(new String[]{INCLUDE_COL}, new Class[]{String.class});
        this.includeTable = new JTable((TableModel)this.includeModel);
        JMeterUtils.applyHiDPI((JTable)this.includeTable);
        this.includeTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        this.includeTable.setPreferredScrollableViewportSize(new Dimension(80, 80));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)INCLUDE_COL)));
        panel.add((Component)GuiUtils.emptyBorder((JComponent)new JScrollPane(this.includeTable)), "Center");
        panel.add((Component)this.createTableButtonPanel(ADD_INCLUDE, DELETE_INCLUDE, ADD_TO_INCLUDE_FROM_CLIPBOARD, null), "South");
        return panel;
    }

    private JPanel createExcludePanel() {
        this.excludeModel = new PowerTableModel(new String[]{EXCLUDE_COL}, new Class[]{String.class});
        this.excludeTable = new JTable((TableModel)this.excludeModel);
        JMeterUtils.applyHiDPI((JTable)this.excludeTable);
        this.excludeTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        this.excludeTable.setPreferredScrollableViewportSize(new Dimension(80, 80));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)EXCLUDE_COL)));
        panel.add((Component)GuiUtils.emptyBorder((JComponent)new JScrollPane(this.excludeTable)), "Center");
        panel.add((Component)this.createTableButtonPanel(ADD_EXCLUDE, DELETE_EXCLUDE, ADD_TO_EXCLUDE_FROM_CLIPBOARD, ADD_SUGGESTED_EXCLUDES), "South");
        return panel;
    }

    private JPanel createNotifyListenersPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"notify_child_listeners_fr")));
        this.notifyChildSamplerListenerOfFilteredSamplersCB = new JCheckBox(JMeterUtils.getResString((String)"notify_child_listeners_fr"));
        this.notifyChildSamplerListenerOfFilteredSamplersCB.setSelected(false);
        this.notifyChildSamplerListenerOfFilteredSamplersCB.addActionListener(this);
        this.notifyChildSamplerListenerOfFilteredSamplersCB.setActionCommand(ENABLE_RESTART);
        panel.add(this.notifyChildSamplerListenerOfFilteredSamplersCB);
        return panel;
    }

    private JPanel createTableButtonPanel(String addCommand, String deleteCommand, String copyFromClipboard, String addSuggestedExcludes) {
        JPanel buttonPanel = new JPanel();
        JButton addButton = new JButton(JMeterUtils.getResString((String)"add"));
        addButton.setActionCommand(addCommand);
        addButton.addActionListener(this);
        buttonPanel.add(addButton);
        JButton deleteButton = new JButton(JMeterUtils.getResString((String)"delete"));
        deleteButton.setActionCommand(deleteCommand);
        deleteButton.addActionListener(this);
        buttonPanel.add(deleteButton);
        JButton addFromClipboard = new JButton(JMeterUtils.getResString((String)"add_from_clipboard"));
        addFromClipboard.setActionCommand(copyFromClipboard);
        addFromClipboard.addActionListener(this);
        buttonPanel.add(addFromClipboard);
        if (addSuggestedExcludes != null) {
            JButton addFromSuggestedExcludes = new JButton(JMeterUtils.getResString((String)"add_from_suggested_excludes"));
            addFromSuggestedExcludes.setActionCommand(addSuggestedExcludes);
            addFromSuggestedExcludes.addActionListener(this);
            buttonPanel.add(addFromSuggestedExcludes);
        }
        return buttonPanel;
    }

    private void reinitializeTargetCombo() {
        log.debug("Reinitializing target combo");
        this.targetNodes.removeActionListener(this);
        this.targetNodesModel.removeAllElements();
        GuiPackage gp = GuiPackage.getInstance();
        if (gp != null) {
            JMeterTreeNode root = (JMeterTreeNode)GuiPackage.getInstance().getTreeModel().getRoot();
            this.targetNodesModel.addElement(new TreeNodeWrapper(null, JMeterUtils.getResString((String)"use_recording_controller")));
            this.buildNodesModel(root, USE_DEFAULT_HTTP_IMPL, 0);
        }
        TreeNodeWrapper choice = null;
        for (int i = 0; i < this.targetNodesModel.getSize(); ++i) {
            choice = (TreeNodeWrapper)this.targetNodesModel.getElementAt(i);
            log.debug("Selecting item {} for model {} in {}", new Object[]{choice, this.model, this});
            if (choice.getTreeNode() == this.model.getTarget()) break;
        }
        this.targetNodes.addActionListener(this);
        this.targetNodesModel.setSelectedItem(choice);
        log.debug("Reinitialization complete");
    }

    private void buildNodesModel(JMeterTreeNode node, String parentName, int level) {
        String separator = " > ";
        if (node != null) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                StringBuilder name = new StringBuilder();
                JMeterTreeNode cur = (JMeterTreeNode)node.getChildAt(i);
                TestElement te = cur.getTestElement();
                if (te instanceof Controller) {
                    name.append(parentName);
                    name.append(cur.getName());
                    TreeNodeWrapper tnw = new TreeNodeWrapper(cur, name.toString());
                    this.targetNodesModel.addElement(tnw);
                    name.append(separator);
                    this.buildNodesModel(cur, name.toString(), level + 1);
                    continue;
                }
                if (!(te instanceof TestPlan)) continue;
                name.append(cur.getName());
                name.append(separator);
                this.buildNodesModel(cur, name.toString(), 0);
            }
        }
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu pop = new JPopupMenu();
        JMenu addMenu = new JMenu(JMeterUtils.getResString((String)"add"));
        addMenu.add(MenuFactory.makeMenu((String)"menu_timer", (String)"Add"));
        addMenu.add(MenuFactory.makeMenu((String)"menu_pre_processors", (String)"Add"));
        addMenu.add(MenuFactory.makeMenu((String)"menu_listener", (String)"Add"));
        pop.add(addMenu);
        MenuFactory.addEditMenu((JPopupMenu)pop, (boolean)true);
        MenuFactory.addFileMenu((JPopupMenu)pop);
        return pop;
    }

    int getHTTPSampleNamingMode() {
        return this.httpSampleNamingMode.getSelectedIndex();
    }

    String getProxyPauseHTTPSample() {
        return this.proxyPauseHTTPSample.getText();
    }

    public String getPrefixHTTPSampleName() {
        return this.prefixHTTPSampleName.getText();
    }

    void setHTTPSampleNamingMode(int selectedIndex) {
        this.httpSampleNamingMode.setSelectedIndex(selectedIndex);
        this.model.setHTTPSampleNamingMode(this.httpSampleNamingMode.getSelectedIndex());
    }

    void setProxyPauseHTTPSample(String text) {
        this.proxyPauseHTTPSample.setText(text);
        this.model.setProxyPauseHTTPSample(text);
    }

    void setPrefixHTTPSampleName(String text) {
        this.prefixHTTPSampleName.setText(text);
        this.model.setPrefixHTTPSampleName(text);
    }
}

