/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.avalon.CLArgsParser;
import org.apache.commons.cli.avalon.CLOption;
import org.apache.commons.cli.avalon.CLOptionDescriptor;
import org.apache.commons.cli.avalon.CLUtil;
import org.apache.jmeter.gui.Stoppable;
import org.apache.jmeter.protocol.http.control.HttpMirrorThread;
import org.apache.jmeter.testelement.NonTestElement;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMirrorServer
extends Thread
implements Stoppable,
NonTestElement {
    private static final int OPTIONS_OPT = 63;
    private static final int PORT_OPT = 80;
    private static final int LOGLEVEL_OPT = 76;
    private static final CLOptionDescriptor D_OPTIONS_OPT = new CLOptionDescriptor("?", 8, 63, "print command line options and exit");
    private static final CLOptionDescriptor D_PORT_OPT = new CLOptionDescriptor("port", 2, 80, "Set server port for HttpMirrorServer to use");
    private static final CLOptionDescriptor D_LOGLEVEL_OPT = new CLOptionDescriptor("loglevel", 48, 76, "[category=]level e.g. INFO or DEBUG");
    private static final CLOptionDescriptor[] options = new CLOptionDescriptor[]{D_OPTIONS_OPT, D_PORT_OPT, D_LOGLEVEL_OPT};
    private static final int ACCEPT_TIMEOUT = 1000;
    private static final long KEEP_ALIVE_TIME = 10L;
    private final int daemonPort;
    private volatile boolean running;
    private volatile Exception except;
    private int maxThreadPoolSize;
    private int maxQueueSize;

    public HttpMirrorServer(int port) {
        this(port, 0, 25);
    }

    public HttpMirrorServer(int port, int maxThreadPoolSize, int maxQueueSize) {
        super("HttpMirrorServer");
        this.daemonPort = port;
        this.maxThreadPoolSize = maxThreadPoolSize;
        this.maxQueueSize = maxQueueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block13: {
            ServerSocket mainSocket;
            block12: {
                this.except = null;
                this.running = true;
                mainSocket = null;
                ThreadPoolExecutor threadPoolExecutor = null;
                if (this.maxThreadPoolSize > 0) {
                    ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(this.maxQueueSize);
                    threadPoolExecutor = new ThreadPoolExecutor(this.maxThreadPoolSize / 2, this.maxThreadPoolSize, 10L, TimeUnit.SECONDS, queue);
                    threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
                }
                try {
                    HttpMirrorServer.getLogger().info("Creating HttpMirror ... on port " + this.daemonPort);
                    mainSocket = new ServerSocket(this.daemonPort);
                    mainSocket.setSoTimeout(1000);
                    HttpMirrorServer.getLogger().info("HttpMirror up and running!");
                    while (this.running) {
                        try {
                            Socket clientSocket = mainSocket.accept();
                            if (this.running) {
                                if (threadPoolExecutor != null) {
                                    threadPoolExecutor.execute(new HttpMirrorThread(clientSocket));
                                    continue;
                                }
                                Thread thd = new Thread(new HttpMirrorThread(clientSocket));
                                HttpMirrorServer.getLogger().debug("Starting new Mirror thread");
                                thd.start();
                                continue;
                            }
                            HttpMirrorServer.getLogger().warn("Server not running");
                            JOrphanUtils.closeQuietly((Socket)clientSocket);
                        }
                        catch (InterruptedIOException clientSocket) {}
                    }
                    HttpMirrorServer.getLogger().info("HttpMirror Server stopped");
                    if (threadPoolExecutor == null) break block12;
                    threadPoolExecutor.shutdownNow();
                }
                catch (Exception e) {
                    this.except = e;
                    HttpMirrorServer.getLogger().warn("HttpMirror Server stopped", (Throwable)e);
                    break block13;
                }
                finally {
                    if (threadPoolExecutor != null) {
                        threadPoolExecutor.shutdownNow();
                    }
                    JOrphanUtils.closeQuietly(mainSocket);
                }
            }
            JOrphanUtils.closeQuietly((ServerSocket)mainSocket);
        }
    }

    public void stopServer() {
        this.running = false;
    }

    public Exception getException() {
        return this.except;
    }

    public static void main(String[] args) {
        CLArgsParser parser = new CLArgsParser(args, options);
        String error = parser.getErrorString();
        if (error != null) {
            System.err.println("Error: " + error);
            System.out.println("Usage");
            System.out.println(CLUtil.describeOptions((CLOptionDescriptor[])options).toString());
            System.out.println("Error: " + error);
            return;
        }
        if (parser.getArgumentById(63) != null) {
            System.out.println(CLUtil.describeOptions((CLOptionDescriptor[])options).toString());
            return;
        }
        int port = 8081;
        if (parser.getArgumentById(80) != null) {
            CLOption option = parser.getArgumentById(80);
            String value = option.getArgument(0);
            try {
                port = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (args.length > 0) {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException option) {
                // empty catch block
            }
        }
        if (System.getProperty("log4j.configurationFile") == null) {
            Configurator.setRootLevel((Level)Level.INFO);
        }
        Vector clOptions = parser.getArguments();
        for (CLOption option : clOptions) {
            String name = option.getArgument(0);
            String value = option.getArgument(1);
            switch (option.getDescriptor().getId()) {
                case 76: {
                    Level logLevel;
                    if (!value.isEmpty()) {
                        logLevel = Level.getLevel((String)value);
                        if (logLevel != null) {
                            String loggerName = name;
                            if (name.startsWith("jmeter") || name.startsWith("jorphan")) {
                                loggerName = "org.apache." + name;
                            }
                            HttpMirrorServer.getLogger().info("Setting log level to " + value + " for " + loggerName);
                            Configurator.setAllLevels((String)loggerName, (Level)logLevel);
                            break;
                        }
                        HttpMirrorServer.getLogger().warn("Invalid log level, '" + value + "' for '" + name + "'.");
                        break;
                    }
                    logLevel = Level.getLevel((String)name);
                    if (logLevel != null) {
                        HttpMirrorServer.getLogger().info("Setting root log level to " + name);
                        Configurator.setRootLevel((Level)logLevel);
                        break;
                    }
                    HttpMirrorServer.getLogger().warn("Invalid log level, '" + name + "' for the root logger.");
                    break;
                }
            }
        }
        HttpMirrorServer serv = new HttpMirrorServer(port);
        serv.start();
    }

    private static Logger getLogger() {
        return LazyHolder.LOGGER;
    }

    private static class LazyHolder {
        public static final Logger LOGGER = LoggerFactory.getLogger(HttpMirrorServer.class);

        private LazyHolder() {
        }
    }
}

