/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.parser;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.jmeter.protocol.http.parser.LinkExtractorParseException;
import org.apache.jmeter.protocol.http.parser.LinkExtractorParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseParser
implements LinkExtractorParser {
    private static final Logger LOG = LoggerFactory.getLogger(BaseParser.class);
    private static final ConcurrentMap<String, LinkExtractorParser> PARSERS = new ConcurrentHashMap<String, LinkExtractorParser>(5);

    public static LinkExtractorParser getParser(String parserClassName) throws LinkExtractorParseException {
        LinkExtractorParser currentParser;
        LinkExtractorParser parser = (LinkExtractorParser)PARSERS.get(parserClassName);
        if (parser != null) {
            LOG.debug("Fetched " + parserClassName);
            return parser;
        }
        try {
            Object clazz = Class.forName(parserClassName).newInstance();
            if (!(clazz instanceof LinkExtractorParser)) {
                throw new LinkExtractorParseException(new ClassCastException(parserClassName));
            }
            parser = (LinkExtractorParser)clazz;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new LinkExtractorParseException(e);
        }
        LOG.info("Created " + parserClassName);
        if (parser.isReusable() && (currentParser = PARSERS.putIfAbsent(parserClassName, parser)) != null) {
            return currentParser;
        }
        return parser;
    }

    @Override
    public boolean isReusable() {
        return true;
    }
}

