/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.security.auth.Subject;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.protocol.http.control.Authorization;
import org.apache.jmeter.protocol.http.control.KerberosManager;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestIterationListener;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthManager
extends ConfigTestElement
implements TestStateListener,
TestIterationListener,
Serializable {
    private static final long serialVersionUID = 235L;
    private static final Logger log = LoggerFactory.getLogger(AuthManager.class);
    private static final String CLEAR = "AuthManager.clearEachIteration";
    private static final String AUTH_LIST = "AuthManager.auth_list";
    private static final String[] COLUMN_RESOURCE_NAMES = new String[]{"auth_base_url", "username", "password", "domain", "realm", "mechanism"};
    public static final int COL_URL = 0;
    public static final int COL_USERNAME = 1;
    public static final int COL_PASSWORD = 2;
    public static final int COL_DOMAIN = 3;
    public static final int COL_REALM = 4;
    public static final int COL_MECHANISM = 5;
    private static final int COLUMN_COUNT = COLUMN_RESOURCE_NAMES.length;
    private static final Credentials USE_JAAS_CREDENTIALS = new NullCredentials();
    private static final boolean DEFAULT_CLEAR_VALUE = false;
    private static final boolean STRIP_PORT = JMeterUtils.getPropDefault((String)"kerberos.spnego.strip_port", (boolean)true);
    private KerberosManager kerberosManager = new KerberosManager();

    public AuthManager() {
        this.setProperty((JMeterProperty)new CollectionProperty(AUTH_LIST, new ArrayList()));
    }

    public void clear() {
        super.clear();
        this.kerberosManager.clearSubjects();
        this.setProperty((JMeterProperty)new CollectionProperty(AUTH_LIST, new ArrayList()));
    }

    public void set(int index, String url, String user, String pass, String domain, String realm, Mechanism mechanism) {
        Authorization auth = new Authorization(url, user, pass, domain, realm, mechanism);
        if (index >= 0) {
            this.getAuthObjects().set(index, (JMeterProperty)new TestElementProperty(auth.getName(), (TestElement)auth));
        } else {
            this.getAuthObjects().addItem((Object)auth);
        }
    }

    public CollectionProperty getAuthObjects() {
        return (CollectionProperty)this.getProperty(AUTH_LIST);
    }

    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    public String getColumnName(int column) {
        return COLUMN_RESOURCE_NAMES[column];
    }

    public Class<?> getColumnClass(int column) {
        return COLUMN_RESOURCE_NAMES[column].getClass();
    }

    public Authorization getAuthObjectAt(int row) {
        return (Authorization)this.getAuthObjects().get(row).getObjectValue();
    }

    public boolean isEditable() {
        return true;
    }

    public Authorization get(int i) {
        return (Authorization)this.getAuthObjects().get(i).getObjectValue();
    }

    public String getAuthHeaderForURL(URL url) {
        Authorization auth = this.getAuthForURL(url);
        if (auth == null) {
            return null;
        }
        return auth.toBasicHeader();
    }

    public Authorization getAuthForURL(URL url) {
        if (!AuthManager.isSupportedProtocol(url)) {
            return null;
        }
        URL url2 = null;
        try {
            if (url.getPort() == -1) {
                int port = url.getProtocol().equalsIgnoreCase("http") ? 80 : 443;
                url2 = new URL(url.getProtocol(), url.getHost(), port, url.getPath());
            } else if (url.getPort() == 80 && url.getProtocol().equalsIgnoreCase("http") || url.getPort() == 443 && url.getProtocol().equalsIgnoreCase("https")) {
                url2 = new URL(url.getProtocol(), url.getHost(), url.getPath());
            }
        }
        catch (MalformedURLException e) {
            log.error("Internal error!", (Throwable)e);
        }
        String s1 = url.toString();
        String s2 = null;
        if (url2 != null) {
            s2 = url2.toString();
        }
        log.debug("Target URL strings to match against: " + s1 + " and " + s2);
        for (JMeterProperty jMeterProperty : this.getAuthObjects()) {
            Authorization auth = (Authorization)jMeterProperty.getObjectValue();
            String uRL = auth.getURL();
            log.debug("Checking match against auth'n entry: " + uRL);
            if (s1.startsWith(uRL) || s2 != null && s2.startsWith(uRL)) {
                log.debug("Matched");
                return auth;
            }
            log.debug("Did not match");
        }
        return null;
    }

    public boolean hasAuthForURL(URL url) {
        return this.getAuthForURL(url) != null;
    }

    public Subject getSubjectForUrl(URL url) {
        Authorization authorization = this.getAuthForURL(url);
        if (authorization != null && Mechanism.KERBEROS.equals((Object)authorization.getMechanism())) {
            return this.kerberosManager.getSubjectForUser(authorization.getUser(), authorization.getPass());
        }
        return null;
    }

    public void addConfigElement(ConfigElement config) {
    }

    public void addAuth(Authorization newAuthorization) {
        boolean alreadyExists = false;
        for (JMeterProperty jMeterProperty : this.getAuthObjects()) {
            Authorization authorization = (Authorization)jMeterProperty.getObjectValue();
            if (authorization == null || !this.match(authorization, newAuthorization)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Found the same Authorization object:" + newAuthorization.toString());
            }
            alreadyExists = true;
            break;
        }
        if (!alreadyExists) {
            this.getAuthObjects().addItem((Object)newAuthorization);
        }
    }

    public void addAuth() {
        this.getAuthObjects().addItem((Object)new Authorization());
    }

    public boolean expectsModification() {
        return false;
    }

    public void save(String authFile) throws IOException {
        File file = new File(authFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir"), authFile);
        }
        try (FileWriter fw = new FileWriter(file);
             PrintWriter writer = new PrintWriter(fw);){
            writer.println("# JMeter generated Authorization file");
            for (int i = 0; i < this.getAuthObjects().size(); ++i) {
                Authorization auth = (Authorization)this.getAuthObjects().get(i).getObjectValue();
                writer.println(auth.toString());
            }
            writer.flush();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addFile(String authFile) throws IOException {
        File file = new File(authFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir") + File.separator + authFile);
        }
        if (!file.canRead()) {
            throw new IOException("The file you specified cannot be read.");
        }
        boolean ok = true;
        try (FileReader fr = new FileReader(file);
             BufferedReader reader = new BufferedReader(fr);){
            String line;
            while ((line = reader.readLine()) != null) {
                try {
                    String realm;
                    String domain;
                    String[] tokens;
                    if (line.startsWith("#") || JOrphanUtils.isBlank((String)line) || (tokens = line.split("\t")).length < 3) continue;
                    String url = tokens[0];
                    String user = tokens[1];
                    String pass = tokens[2];
                    if (tokens.length > 3) {
                        domain = tokens[3];
                        realm = tokens[4];
                    } else {
                        domain = "";
                        realm = "";
                    }
                    Mechanism mechanism = tokens.length > 5 ? Mechanism.valueOf(tokens[5]) : Mechanism.BASIC_DIGEST;
                    Authorization auth = new Authorization(url, user, pass, domain, realm, mechanism);
                    this.getAuthObjects().addItem((Object)auth);
                }
                catch (NoSuchElementException e) {
                    log.error("Error parsing auth line: '" + line + "'", (Throwable)e);
                    ok = false;
                }
            }
        }
        if (!ok) {
            JMeterUtils.reportErrorToUser((String)"One or more errors found when reading the Auth file - see the log file");
        }
    }

    public void remove(int index) {
        this.getAuthObjects().remove(index);
    }

    public boolean getClearEachIteration() {
        return this.getPropertyAsBoolean(CLEAR, false);
    }

    public void setClearEachIteration(boolean clear) {
        this.setProperty(CLEAR, clear, false);
    }

    public int getAuthCount() {
        return this.getAuthObjects().size();
    }

    static boolean isSupportedProtocol(URL url) {
        String protocol = url.getProtocol().toLowerCase(Locale.ENGLISH);
        return protocol.equals("http") || protocol.equals("https");
    }

    public void setupCredentials(HttpClient client, URL url, CredentialsProvider credentialsProvider, String localHost) {
        Authorization auth = this.getAuthForURL(url);
        if (auth != null) {
            String username = auth.getUser();
            String realm = auth.getRealm();
            String domain = auth.getDomain();
            if (log.isDebugEnabled()) {
                log.debug(username + " > D=" + domain + " R=" + realm + " M=" + (Object)((Object)auth.getMechanism()));
            }
            if (Mechanism.KERBEROS.equals((Object)auth.getMechanism())) {
                ((AbstractHttpClient)client).getAuthSchemes().register("Negotiate", (AuthSchemeFactory)new SPNegoSchemeFactory(this.isStripPort(url)));
                credentialsProvider.setCredentials(new AuthScope(null, -1, null), USE_JAAS_CREDENTIALS);
            } else {
                credentialsProvider.setCredentials(new AuthScope(url.getHost(), url.getPort(), realm.length() == 0 ? null : realm), (Credentials)new NTCredentials(username, auth.getPass(), localHost, domain));
            }
        }
    }

    private boolean isStripPort(URL url) {
        if (STRIP_PORT) {
            return true;
        }
        return url.getPort() == 80 || url.getPort() == 443;
    }

    private boolean match(Authorization a, Authorization b) {
        return a.getURL().equals(b.getURL()) && a.getDomain().equals(b.getDomain()) && a.getRealm().equals(b.getRealm()) && a.getMechanism().equals((Object)b.getMechanism());
    }

    public void testStarted() {
        this.kerberosManager.clearSubjects();
    }

    public void testEnded() {
    }

    public void testStarted(String host) {
        this.testStarted();
    }

    public void testEnded(String host) {
    }

    public void testIterationStart(LoopIterationEvent event) {
        if (this.getClearEachIteration()) {
            this.kerberosManager.clearSubjects();
        }
    }

    private static final class NullCredentials
    implements Credentials {
        private NullCredentials() {
        }

        public String getPassword() {
            return null;
        }

        public Principal getUserPrincipal() {
            return null;
        }
    }

    public static enum Mechanism {
        BASIC_DIGEST,
        KERBEROS;

    }
}

