/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util.accesslog;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.jmeter.protocol.http.util.accesslog.Filter;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.regex.Pattern;

public class LogFilter
implements Filter,
Serializable {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected boolean CHANGEEXT = false;
    protected String OLDEXT = null;
    protected String NEWEXT = null;
    protected String[] INCFILE = null;
    protected String[] EXCFILE = null;
    protected boolean FILEFILTER = false;
    protected boolean USEFILE = true;
    protected String[] INCPTRN = null;
    protected String[] EXCPTRN = null;
    protected boolean PTRNFILTER = false;
    protected ArrayList<Pattern> EXCPATTERNS = new ArrayList();
    protected ArrayList<Pattern> INCPATTERNS = new ArrayList();
    protected String NEWFILE = null;

    @Override
    public void setReplaceExtension(String oldext, String newext) {
        if (oldext != null && newext != null) {
            this.CHANGEEXT = true;
            if (!oldext.contains(".") && !newext.contains(".")) {
                this.OLDEXT = "." + oldext;
                this.NEWEXT = "." + newext;
            } else {
                this.OLDEXT = oldext;
                this.NEWEXT = newext;
            }
        }
    }

    @Override
    public void includeFiles(String[] filenames) {
        if (filenames != null && filenames.length > 0) {
            this.INCFILE = filenames;
            this.FILEFILTER = true;
        }
    }

    @Override
    public void excludeFiles(String[] filenames) {
        if (filenames != null && filenames.length > 0) {
            this.EXCFILE = filenames;
            this.FILEFILTER = true;
        }
    }

    @Override
    public void includePattern(String[] regexp) {
        if (regexp != null && regexp.length > 0) {
            this.INCPTRN = regexp;
            this.PTRNFILTER = true;
            for (String includePattern : this.INCPTRN) {
                this.INCPATTERNS.add(this.createPattern(includePattern));
            }
        }
    }

    @Override
    public void excludePattern(String[] regexp) {
        if (regexp != null && regexp.length > 0) {
            this.EXCPTRN = regexp;
            this.PTRNFILTER = true;
            for (String excludePattern : this.EXCPTRN) {
                this.EXCPATTERNS.add(this.createPattern(excludePattern));
            }
        }
    }

    @Override
    public boolean isFiltered(String path, TestElement el) {
        if (this.FILEFILTER) {
            return this.filterFile(path);
        }
        if (this.PTRNFILTER) {
            return this.filterPattern(path);
        }
        return false;
    }

    protected boolean filterFile(String file) {
        if (this.EXCFILE != null) {
            return this.excFile(file);
        }
        if (this.INCFILE != null) {
            return !this.incFile(file);
        }
        return false;
    }

    public boolean incFile(String text) {
        this.USEFILE = false;
        for (String includeFile : this.INCFILE) {
            if (!text.contains(includeFile)) continue;
            this.USEFILE = true;
            break;
        }
        return this.USEFILE;
    }

    public boolean excFile(String text) {
        this.USEFILE = true;
        boolean exc = false;
        for (String excludeFile : this.EXCFILE) {
            if (!text.contains(excludeFile)) continue;
            exc = true;
            this.USEFILE = false;
            break;
        }
        return exc;
    }

    protected boolean filterPattern(String text) {
        if (this.INCPTRN != null) {
            return !this.incPattern(text);
        }
        if (this.EXCPTRN != null) {
            return this.excPattern(text);
        }
        return false;
    }

    protected boolean incPattern(String text) {
        this.USEFILE = false;
        for (Pattern includePattern : this.INCPATTERNS) {
            if (!JMeterUtils.getMatcher().contains(text, includePattern)) continue;
            this.USEFILE = true;
            break;
        }
        return this.USEFILE;
    }

    protected boolean excPattern(String text) {
        this.USEFILE = true;
        boolean exc = false;
        for (Pattern excludePattern : this.EXCPATTERNS) {
            if (!JMeterUtils.getMatcher().contains(text, excludePattern)) continue;
            exc = true;
            this.USEFILE = false;
            break;
        }
        return exc;
    }

    public boolean replaceExtension(String text) {
        int pt = text.indexOf(this.OLDEXT);
        if (pt > -1) {
            int extsize = this.OLDEXT.length();
            this.NEWFILE = text.substring(0, pt) + this.NEWEXT + text.substring(pt + extsize);
            return true;
        }
        return false;
    }

    @Override
    public String filter(String text) {
        if (this.CHANGEEXT) {
            if (this.replaceExtension(text)) {
                return this.NEWFILE;
            }
            return text;
        }
        if (this.USEFILE) {
            return text;
        }
        return null;
    }

    public Pattern createPattern(String pattern) {
        try {
            return JMeterUtils.getPatternCache().getPattern(pattern, 32784);
        }
        catch (MalformedCachePatternException exception) {
            log.error("Problem with pattern: " + pattern, (Throwable)exception);
            return null;
        }
    }

    @Override
    public void reset() {
    }
}

