/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.IllegalCharsetNameException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.parser.HTMLParseException;
import org.apache.jmeter.protocol.http.proxy.FormCharSetFinder;
import org.apache.jmeter.protocol.http.proxy.HttpReplyHdr;
import org.apache.jmeter.protocol.http.proxy.HttpRequestHdr;
import org.apache.jmeter.protocol.http.proxy.ProxyControl;
import org.apache.jmeter.protocol.http.proxy.SamplerCreator;
import org.apache.jmeter.protocol.http.proxy.SamplerCreatorFactory;
import org.apache.jmeter.protocol.http.proxy.ServerAliasKeyManager;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterException;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class Proxy
extends Thread {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final byte[] CRLF_BYTES = new byte[]{13, 10};
    private static final String CRLF_STRING = "\r\n";
    private static final String NEW_LINE = "\n";
    private static final String[] HEADERS_TO_REMOVE;
    private static final String PROXY_HEADERS_REMOVE = "proxy.headers.remove";
    private static final String PROXY_HEADERS_REMOVE_DEFAULT = "If-Modified-Since,If-None-Match,Host";
    private static final String PROXY_HEADERS_REMOVE_SEPARATOR = ",";
    private static final String KEYMANAGERFACTORY;
    private static final String SSLCONTEXT_PROTOCOL;
    private static final HashMap<String, SSLSocketFactory> HOST2SSL_SOCK_FAC;
    private static final SamplerCreatorFactory SAMPLERFACTORY;
    private OutputStream outStreamClient = null;
    private Socket clientSocket = null;
    private ProxyControl target;
    private boolean captureHttpHeaders;
    private Map<String, String> pageEncodings;
    private Map<String, String> formEncodings;
    private String port = "";
    private KeyStore keyStore;
    private String keyPassword;

    void configure(Socket _clientSocket, ProxyControl _target, Map<String, String> _pageEncodings, Map<String, String> _formEncodings) {
        this.target = _target;
        this.clientSocket = _clientSocket;
        this.captureHttpHeaders = _target.getCaptureHttpHeaders();
        this.pageEncodings = _pageEncodings;
        this.formEncodings = _formEncodings;
        this.port = "[" + this.clientSocket.getPort() + "] ";
        this.keyStore = _target.getKeyStore();
        this.keyPassword = _target.getKeyPassword();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        SamplerCreator samplerCreator;
        boolean isDebug;
        HTTPSamplerBase sampler;
        HeaderManager headers;
        SampleResult result;
        HttpRequestHdr request;
        block66: {
            String httpSamplerName = this.target.getSamplerTypeName();
            request = new HttpRequestHdr(httpSamplerName);
            result = null;
            headers = null;
            sampler = null;
            isDebug = log.isDebugEnabled();
            if (isDebug) {
                log.debug(this.port + "====================================================================");
            }
            samplerCreator = null;
            byte[] ba = request.parse(new BufferedInputStream(this.clientSocket.getInputStream()));
            if (ba.length == 0) {
                if (!isDebug) throw new JMeterException();
                log.debug(this.port + "Empty request, ignored");
                throw new JMeterException();
            }
            if (isDebug) {
                log.debug(this.port + "Initial request: " + new String(ba));
            }
            this.outStreamClient = this.clientSocket.getOutputStream();
            if (request.getMethod().startsWith("CONNECT") && this.outStreamClient != null) {
                if (isDebug) {
                    log.debug(this.port + "Method CONNECT => SSL");
                }
                this.outStreamClient.write("HTTP/1.0 200 OK\r\n\r\n".getBytes(SampleResult.DEFAULT_HTTP_ENCODING));
                this.outStreamClient.flush();
                String[] param = request.getUrl().split(":");
                if (param.length != 2) {
                    log.error("In SSL request, unable to find host and port in CONNECT request: " + request.getUrl());
                    throw new JMeterException();
                }
                if (isDebug) {
                    log.debug(this.port + "Start to negotiate SSL connection, host: " + param[0]);
                }
                this.clientSocket = this.startSSL(this.clientSocket, param[0]);
                try {
                    ba = request.parse(new BufferedInputStream(this.clientSocket.getInputStream()));
                }
                catch (IOException ioe) {
                    String url = " for '" + param[0] + "'";
                    log.warn(this.port + "Problem with SSL certificate" + url + "? Ensure browser is set to accept the JMeter proxy cert: " + ioe.getMessage());
                    result = Proxy.generateErrorResult(result, request, ioe, "\n**ensure browser is set to accept the JMeter proxy certificate**");
                    throw new JMeterException();
                }
                if (isDebug) {
                    log.debug(this.port + "Reparse: " + new String(ba));
                }
                if (ba.length == 0) {
                    log.warn(this.port + "Empty response to http over SSL. Probably waiting for user to authorize the certificate for " + request.getUrl());
                    throw new JMeterException();
                }
            }
            samplerCreator = SAMPLERFACTORY.getSamplerCreator(request, this.pageEncodings, this.formEncodings);
            sampler = samplerCreator.createAndPopulateSampler(request, this.pageEncodings, this.formEncodings);
            headers = request.getHeaderManager();
            sampler.setHeaderManager(headers);
            sampler.threadStarted();
            if (isDebug) {
                log.debug(this.port + "Execute sample: " + sampler.getMethod() + " " + sampler.getUrl());
            }
            result = sampler.sample();
            String pageEncoding = this.addPageEncoding(result);
            this.addFormEncodings(result, pageEncoding);
            this.writeToClient(result, new BufferedOutputStream(this.clientSocket.getOutputStream()));
            samplerCreator.postProcessSampler(sampler, result);
            if (sampler == null || !isDebug) break block66;
            log.debug(this.port + "Will deliver sample " + sampler.getName());
        }
        if (headers != null) {
            headers.removeHeaderNamed("Cookie");
            for (String hdr : HEADERS_TO_REMOVE) {
                headers.removeHeaderNamed(hdr);
            }
        }
        if (result != null) {
            ArrayList<HeaderManager> children = new ArrayList<HeaderManager>();
            if (this.captureHttpHeaders) {
                children.add(headers);
            }
            if (samplerCreator != null) {
                children.addAll(samplerCreator.createChildren(sampler, result));
            }
            this.target.deliverSampler(sampler, children.toArray(new TestElement[children.size()]), result);
        }
        try {
            this.clientSocket.close();
        }
        catch (Exception e) {
            log.error(this.port + "Failed to close client socket", (Throwable)e);
        }
        if (sampler == null) return;
        sampler.threadFinished();
        return;
        catch (JMeterException e) {
            if (sampler != null && isDebug) {
                log.debug(this.port + "Will deliver sample " + sampler.getName());
            }
            if (headers != null) {
                headers.removeHeaderNamed("Cookie");
                for (String hdr : HEADERS_TO_REMOVE) {
                    headers.removeHeaderNamed(hdr);
                }
            }
            if (result != null) {
                ArrayList<HeaderManager> children = new ArrayList<HeaderManager>();
                if (this.captureHttpHeaders) {
                    children.add(headers);
                }
                if (samplerCreator != null) {
                    children.addAll(samplerCreator.createChildren(sampler, result));
                }
                this.target.deliverSampler(sampler, children.toArray(new TestElement[children.size()]), result);
            }
            try {
                this.clientSocket.close();
            }
            catch (Exception e2) {
                log.error(this.port + "Failed to close client socket", (Throwable)e2);
            }
            if (sampler == null) return;
            sampler.threadFinished();
            return;
            catch (UnknownHostException uhe) {
                block67: {
                    log.warn(this.port + "Server Not Found.", (Throwable)uhe);
                    this.writeErrorToClient(HttpReplyHdr.formServerNotFound());
                    result = this.generateErrorResult(result, request, uhe);
                    if (sampler == null || !isDebug) break block67;
                    log.debug(this.port + "Will deliver sample " + sampler.getName());
                }
                if (headers != null) {
                    headers.removeHeaderNamed("Cookie");
                    for (String hdr : HEADERS_TO_REMOVE) {
                        headers.removeHeaderNamed(hdr);
                    }
                }
                if (result != null) {
                    ArrayList<HeaderManager> children = new ArrayList<HeaderManager>();
                    if (this.captureHttpHeaders) {
                        children.add(headers);
                    }
                    if (samplerCreator != null) {
                        children.addAll(samplerCreator.createChildren(sampler, result));
                    }
                    this.target.deliverSampler(sampler, children.toArray(new TestElement[children.size()]), result);
                }
                try {
                    this.clientSocket.close();
                }
                catch (Exception e3) {
                    log.error(this.port + "Failed to close client socket", (Throwable)e3);
                }
                if (sampler == null) return;
                sampler.threadFinished();
                return;
                catch (IllegalArgumentException e4) {
                    block68: {
                        log.error(this.port + "Not implemented (probably used https)", (Throwable)e4);
                        this.writeErrorToClient(HttpReplyHdr.formNotImplemented("Probably used https instead of http. To record https requests, see <a href=\"http://jmeter.apache.org/usermanual/component_reference.html#HTTP(S)_Test_Script_Recorder\">HTTP(S) Test Script Recorder documentation</a>"));
                        result = this.generateErrorResult(result, request, e4);
                        if (sampler == null || !isDebug) break block68;
                        log.debug(this.port + "Will deliver sample " + sampler.getName());
                    }
                    if (headers != null) {
                        headers.removeHeaderNamed("Cookie");
                        for (String hdr : HEADERS_TO_REMOVE) {
                            headers.removeHeaderNamed(hdr);
                        }
                    }
                    if (result != null) {
                        ArrayList<HeaderManager> children = new ArrayList<HeaderManager>();
                        if (this.captureHttpHeaders) {
                            children.add(headers);
                        }
                        if (samplerCreator != null) {
                            children.addAll(samplerCreator.createChildren(sampler, result));
                        }
                        this.target.deliverSampler(sampler, children.toArray(new TestElement[children.size()]), result);
                    }
                    try {
                        this.clientSocket.close();
                    }
                    catch (Exception e5) {
                        log.error(this.port + "Failed to close client socket", (Throwable)e5);
                    }
                    if (sampler == null) return;
                    sampler.threadFinished();
                    return;
                    catch (Exception e6) {
                        block69: {
                            log.error(this.port + "Exception when processing sample", (Throwable)e6);
                            this.writeErrorToClient(HttpReplyHdr.formInternalError());
                            result = this.generateErrorResult(result, request, e6);
                            if (sampler == null || !isDebug) break block69;
                            log.debug(this.port + "Will deliver sample " + sampler.getName());
                        }
                        if (headers != null) {
                            headers.removeHeaderNamed("Cookie");
                            for (String hdr : HEADERS_TO_REMOVE) {
                                headers.removeHeaderNamed(hdr);
                            }
                        }
                        if (result != null) {
                            ArrayList<HeaderManager> children = new ArrayList<HeaderManager>();
                            if (this.captureHttpHeaders) {
                                children.add(headers);
                            }
                            if (samplerCreator != null) {
                                children.addAll(samplerCreator.createChildren(sampler, result));
                            }
                            this.target.deliverSampler(sampler, children.toArray(new TestElement[children.size()]), result);
                        }
                        try {
                            this.clientSocket.close();
                        }
                        catch (Exception e7) {
                            log.error(this.port + "Failed to close client socket", (Throwable)e7);
                        }
                        if (sampler == null) return;
                        sampler.threadFinished();
                        return;
                        catch (Throwable throwable) {
                            if (sampler != null && isDebug) {
                                log.debug(this.port + "Will deliver sample " + sampler.getName());
                            }
                            if (headers != null) {
                                headers.removeHeaderNamed("Cookie");
                                for (String hdr : HEADERS_TO_REMOVE) {
                                    headers.removeHeaderNamed(hdr);
                                }
                            }
                            if (result != null) {
                                ArrayList<HeaderManager> children = new ArrayList<HeaderManager>();
                                if (this.captureHttpHeaders) {
                                    children.add(headers);
                                }
                                if (samplerCreator != null) {
                                    children.addAll(samplerCreator.createChildren(sampler, result));
                                }
                                this.target.deliverSampler(sampler, children.toArray(new TestElement[children.size()]), result);
                            }
                            try {
                                this.clientSocket.close();
                            }
                            catch (Exception e8) {
                                log.error(this.port + "Failed to close client socket", (Throwable)e8);
                            }
                            if (sampler == null) throw throwable;
                            sampler.threadFinished();
                            throw throwable;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLSocketFactory getSSLSocketFactory(String host) {
        String keyAlias;
        String hashAlias;
        if (this.keyStore == null) {
            log.error(this.port + "No keystore available, cannot record SSL");
            return null;
        }
        switch (ProxyControl.KEYSTORE_MODE) {
            case DYNAMIC_KEYSTORE: {
                try {
                    this.keyStore = this.target.getKeyStore();
                    String alias = this.getDomainMatch(this.keyStore, host);
                    if (alias == null) {
                        hashAlias = host;
                        keyAlias = host;
                        this.keyStore = this.target.updateKeyStore(this.port, keyAlias);
                        break;
                    }
                    if (alias.equals(host)) {
                        hashAlias = host;
                        keyAlias = host;
                        break;
                    }
                    hashAlias = alias;
                    keyAlias = alias;
                    break;
                }
                catch (IOException e) {
                    log.error(this.port + "Problem with keystore", (Throwable)e);
                    return null;
                }
                catch (GeneralSecurityException e) {
                    log.error(this.port + "Problem with keystore", (Throwable)e);
                    return null;
                }
            }
            case JMETER_KEYSTORE: {
                keyAlias = ":jmeter:";
                hashAlias = ":jmeter:";
                break;
            }
            case USER_KEYSTORE: {
                hashAlias = keyAlias = ProxyControl.CERT_ALIAS;
                break;
            }
            default: {
                throw new IllegalStateException("Impossible case: " + (Object)((Object)ProxyControl.KEYSTORE_MODE));
            }
        }
        HashMap<String, SSLSocketFactory> hashMap = HOST2SSL_SOCK_FAC;
        synchronized (hashMap) {
            SSLSocketFactory sslSocketFactory = HOST2SSL_SOCK_FAC.get(hashAlias);
            if (sslSocketFactory != null) {
                if (log.isDebugEnabled()) {
                    log.debug(this.port + "Good, already in map, host=" + host + " using alias " + hashAlias);
                }
                return sslSocketFactory;
            }
            try {
                SSLContext sslcontext = SSLContext.getInstance(SSLCONTEXT_PROTOCOL);
                sslcontext.init(this.getWrappedKeyManagers(keyAlias), null, null);
                SSLSocketFactory sslFactory = sslcontext.getSocketFactory();
                HOST2SSL_SOCK_FAC.put(hashAlias, sslFactory);
                log.info(this.port + "KeyStore for SSL loaded OK and put host '" + host + "' in map with key (" + hashAlias + ")");
                return sslFactory;
            }
            catch (GeneralSecurityException e) {
                log.error(this.port + "Problem with SSL certificate", (Throwable)e);
            }
            catch (IOException e) {
                log.error(this.port + "Problem with keystore", (Throwable)e);
            }
            return null;
        }
    }

    private String getDomainMatch(KeyStore keyStore, String host) throws KeyStoreException {
        if (keyStore.containsAlias(host)) {
            return host;
        }
        String[] parts = host.split("\\.");
        StringBuilder sb = new StringBuilder("*");
        for (int j = 1; j < parts.length; ++j) {
            sb.append('.');
            sb.append(parts[j]);
        }
        String alias = sb.toString();
        if (keyStore.containsAlias(alias)) {
            return alias;
        }
        return null;
    }

    private KeyManager[] getWrappedKeyManagers(String keyAlias) throws GeneralSecurityException, IOException {
        if (!this.keyStore.containsAlias(keyAlias)) {
            throw new IOException("Keystore does not contain alias " + keyAlias);
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KEYMANAGERFACTORY);
        kmf.init(this.keyStore, this.keyPassword.toCharArray());
        KeyManager[] keyManagers = kmf.getKeyManagers();
        int keyManagerCount = keyManagers.length;
        KeyManager[] wrappedKeyManagers = new KeyManager[keyManagerCount];
        for (int i = 0; i < keyManagerCount; ++i) {
            wrappedKeyManagers[i] = new ServerAliasKeyManager(keyManagers[i], keyAlias);
        }
        return wrappedKeyManagers;
    }

    private Socket startSSL(Socket sock, String host) throws IOException {
        SSLSocketFactory sslFactory = this.getSSLSocketFactory(host);
        if (sslFactory != null) {
            try {
                SSLSocket secureSocket = (SSLSocket)sslFactory.createSocket(sock, sock.getInetAddress().getHostName(), sock.getPort(), true);
                secureSocket.setUseClientMode(false);
                if (log.isDebugEnabled()) {
                    log.debug(this.port + "SSL transaction ok with cipher: " + secureSocket.getSession().getCipherSuite());
                }
                return secureSocket;
            }
            catch (IOException e) {
                log.error(this.port + "Error in SSL socket negotiation: ", (Throwable)e);
                throw e;
            }
        }
        log.warn(this.port + "Unable to negotiate SSL transaction, no keystore?");
        throw new IOException("Unable to negotiate SSL transaction, no keystore?");
    }

    private SampleResult generateErrorResult(SampleResult result, HttpRequestHdr request, Exception e) {
        return Proxy.generateErrorResult(result, request, e, "");
    }

    private static SampleResult generateErrorResult(SampleResult result, HttpRequestHdr request, Exception e, String msg) {
        if (result == null) {
            result = new SampleResult();
            ByteArrayOutputStream text = new ByteArrayOutputStream(200);
            e.printStackTrace(new PrintStream(text));
            result.setResponseData(text.toByteArray());
            result.setSamplerData(request.getFirstLine());
            result.setSampleLabel(request.getUrl());
        }
        result.setSuccessful(false);
        result.setResponseMessage(e.getMessage() + msg);
        return result;
    }

    private void writeToClient(SampleResult res, OutputStream out) throws IOException {
        try {
            String responseHeaders = this.messageResponseHeaders(res);
            out.write(responseHeaders.getBytes(SampleResult.DEFAULT_HTTP_ENCODING));
            out.write(CRLF_BYTES);
            out.write(res.getResponseData());
            out.flush();
            if (log.isDebugEnabled()) {
                log.debug(this.port + "Done writing to client");
            }
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            try {
                out.close();
            }
            catch (Exception ex) {
                log.warn(this.port + "Error while closing socket", (Throwable)ex);
            }
        }
    }

    private String messageResponseHeaders(SampleResult res) {
        String headers = res.getResponseHeaders();
        String[] headerLines = headers.split(NEW_LINE, 0);
        int contentLengthIndex = -1;
        boolean fixContentLength = false;
        for (int i = 0; i < headerLines.length; ++i) {
            String line = headerLines[i];
            String[] parts = line.split(":\\s+", 2);
            if (parts.length != 2) continue;
            if ("transfer-encoding".equalsIgnoreCase(parts[0])) {
                headerLines[i] = null;
                continue;
            }
            if ("content-encoding".equalsIgnoreCase(parts[0]) && ("gzip".equalsIgnoreCase(parts[1]) || "deflate".equalsIgnoreCase(parts[1]))) {
                headerLines[i] = null;
                fixContentLength = true;
                continue;
            }
            if (!"Content-Length".equalsIgnoreCase(parts[0])) continue;
            contentLengthIndex = i;
        }
        if (fixContentLength && contentLengthIndex >= 0) {
            headerLines[contentLengthIndex] = "Content-Length: " + res.getResponseData().length;
        }
        StringBuilder sb = new StringBuilder(headers.length());
        for (String line : headerLines) {
            if (line == null) continue;
            sb.append(line).append(CRLF_STRING);
        }
        return sb.toString();
    }

    private void writeErrorToClient(String message) {
        try {
            OutputStream sockOut = this.clientSocket.getOutputStream();
            DataOutputStream out = new DataOutputStream(sockOut);
            out.writeBytes(message);
            out.flush();
        }
        catch (Exception e) {
            log.warn(this.port + "Exception while writing error", (Throwable)e);
        }
    }

    private String addPageEncoding(SampleResult result) {
        String pageEncoding = null;
        try {
            pageEncoding = ConversionUtils.getEncodingFromContentType(result.getContentType());
        }
        catch (IllegalCharsetNameException ex) {
            log.warn("Unsupported charset detected in contentType:'" + result.getContentType() + "', will continue processing with default charset", (Throwable)ex);
        }
        if (pageEncoding != null) {
            String urlWithoutQuery = this.getUrlWithoutQuery(result.getURL());
            this.pageEncodings.put(urlWithoutQuery, pageEncoding);
        }
        return pageEncoding;
    }

    private void addFormEncodings(SampleResult result, String pageEncoding) {
        block3: {
            FormCharSetFinder finder = new FormCharSetFinder();
            if (!result.getContentType().startsWith("text/")) {
                return;
            }
            try {
                finder.addFormActionsAndCharSet(result.getResponseDataAsString(), this.formEncodings, pageEncoding);
            }
            catch (HTMLParseException parseException) {
                if (!log.isDebugEnabled()) break block3;
                log.debug(this.port + "Unable to parse response, could not find any form character set encodings");
            }
        }
    }

    private String getUrlWithoutQuery(URL url) {
        String fullUrl;
        String urlWithoutQuery = fullUrl = url.toString();
        String query = url.getQuery();
        if (query != null) {
            urlWithoutQuery = urlWithoutQuery.substring(0, urlWithoutQuery.length() - query.length() - 1);
        }
        return urlWithoutQuery;
    }

    static {
        KEYMANAGERFACTORY = JMeterUtils.getPropDefault((String)"proxy.cert.factory", (String)"SunX509");
        SSLCONTEXT_PROTOCOL = JMeterUtils.getPropDefault((String)"proxy.ssl.protocol", (String)"TLS");
        HOST2SSL_SOCK_FAC = new HashMap();
        SAMPLERFACTORY = new SamplerCreatorFactory();
        String removeList = JMeterUtils.getPropDefault((String)PROXY_HEADERS_REMOVE, (String)PROXY_HEADERS_REMOVE_DEFAULT);
        HEADERS_TO_REMOVE = JOrphanUtils.split((String)removeList, (String)PROXY_HEADERS_REMOVE_SEPARATOR);
        log.info("Proxy will remove the headers: " + removeList);
    }
}

