/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.protocol.http.parser.HTMLParseException;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class FormCharSetFinder {
    private static final Logger log = LoggingManager.getLoggerForClass();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFormActionsAndCharSet(String html, Map<String, String> formEncodings, String pageEncoding) throws HTMLParseException {
        if (log.isDebugEnabled()) {
            log.debug("Parsing html of: " + html);
        }
        Document document = Jsoup.parse((String)html);
        Elements forms = document.select("form");
        for (Element element : forms) {
            String[] charSets;
            String action = element.attr("action");
            if (StringUtils.isEmpty((CharSequence)action)) continue;
            String formCharSet = pageEncoding;
            String acceptCharSet = element.attr("accept-charset");
            if (acceptCharSet != null && (charSets = JOrphanUtils.split((String)acceptCharSet, (String)",")).length > 0 && (formCharSet = charSets[0].trim()).length() == 0) {
                formCharSet = null;
            }
            if (formCharSet == null) continue;
            Map<String, String> map = formEncodings;
            synchronized (map) {
                formEncodings.put(action, formCharSet);
            }
        }
    }
}

