/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.parser;

import com.helger.css.ECSSVersion;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSExpressionMemberTermURI;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.decl.visit.CSSVisitor;
import com.helger.css.decl.visit.DefaultCSSUrlVisitor;
import com.helger.css.decl.visit.ICSSUrlVisitor;
import com.helger.css.handler.ICSSParseExceptionCallback;
import com.helger.css.handler.LoggingCSSParseExceptionCallback;
import com.helger.css.parser.ParseException;
import com.helger.css.reader.CSSReader;
import com.helger.css.reader.CSSReaderSettings;
import com.helger.css.reader.errorhandler.DoNothingCSSInterpretErrorHandler;
import com.helger.css.reader.errorhandler.ICSSInterpretErrorHandler;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import com.helger.css.reader.errorhandler.LoggingCSSParseErrorHandler;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.protocol.http.parser.LinkExtractorParseException;
import org.apache.jmeter.protocol.http.parser.LinkExtractorParser;
import org.apache.jmeter.protocol.http.parser.URLCollection;
import org.apache.jmeter.protocol.http.parser.URLString;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class CssParser
implements LinkExtractorParser {
    private static final boolean IGNORE_UNRECOVERABLE_PARSING_ERROR = JMeterUtils.getPropDefault((String)"httpsampler.ignore_failed_embedded_resource", (boolean)false);
    private static final Logger LOG = LoggingManager.getLoggerForClass();
    private static final int CSS_URL_CACHE_MAX_SIZE = JMeterUtils.getPropDefault((String)"css.parser.cache.size", (int)400);
    private static final boolean IGNORE_ALL_CSS_ERRORS = JMeterUtils.getPropDefault((String)"css.parser.ignore_all_css_errors", (boolean)true);
    private static final Map<String, URLCollection> CSS_URL_CACHE = CSS_URL_CACHE_MAX_SIZE > 0 ? Collections.synchronizedMap(new LRUMap(CSS_URL_CACHE_MAX_SIZE)) : null;

    @Override
    public Iterator<URL> getEmbeddedResourceURLs(String userAgent, byte[] data, final URL baseUrl, String encoding) throws LinkExtractorParseException {
        try {
            boolean cacheEnabled = CSS_URL_CACHE_MAX_SIZE > 0;
            String md5Key = null;
            URLCollection urlCollection = null;
            if (cacheEnabled) {
                md5Key = DigestUtils.md5Hex((byte[])data);
                urlCollection = CSS_URL_CACHE.get(md5Key);
            }
            if (urlCollection == null) {
                String cssContent = new String(data, encoding);
                CSSReaderSettings cssSettings = new CSSReaderSettings().setBrowserCompliantMode(true).setFallbackCharset(Charset.forName(encoding)).setCSSVersion(ECSSVersion.CSS30).setCustomErrorHandler((ICSSParseErrorHandler)new LoggingCSSParseErrorHandler()).setCustomExceptionHandler((ICSSParseExceptionCallback)new CustomLoggingCSSParseExceptionCallback(baseUrl));
                if (IGNORE_ALL_CSS_ERRORS) {
                    cssSettings.setInterpretErrorHandler((ICSSInterpretErrorHandler)new DoNothingCSSInterpretErrorHandler());
                }
                CascadingStyleSheet aCSS = CSSReader.readFromStringStream((String)cssContent, (CSSReaderSettings)cssSettings);
                ArrayList<URLString> list = new ArrayList<URLString>();
                final URLCollection localCollection = urlCollection = new URLCollection(list);
                if (aCSS != null) {
                    CSSVisitor.visitCSSUrl((CascadingStyleSheet)aCSS, (ICSSUrlVisitor)new DefaultCSSUrlVisitor(){

                        public void onImport(CSSImportRule importRule) {
                            String location = importRule.getLocationString();
                            if (!StringUtils.isEmpty((CharSequence)location)) {
                                localCollection.addURL(location, baseUrl);
                            }
                        }

                        public void onUrlDeclaration(ICSSTopLevelRule aTopLevelRule, CSSDeclaration aDeclaration, CSSExpressionMemberTermURI aURITerm) {
                        }
                    });
                    if (cacheEnabled) {
                        CSS_URL_CACHE.put(md5Key, urlCollection);
                    }
                } else {
                    LOG.warn("Failed parsing url:" + baseUrl + ", got null CascadingStyleSheet");
                }
            }
            if (LOG.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder();
                Iterator<URL> iterator = urlCollection.iterator();
                while (iterator.hasNext()) {
                    URL urlString = iterator.next();
                    builder.append(urlString).append(',');
                }
                LOG.debug("Parsed:" + baseUrl + ", got:" + builder.toString());
            }
            return urlCollection.iterator();
        }
        catch (Exception e) {
            throw new LinkExtractorParseException(e);
        }
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    private static final class CustomLoggingCSSParseExceptionCallback
    extends LoggingCSSParseExceptionCallback {
        private static final long serialVersionUID = -9111232037888068394L;
        private URL cssUrl;

        public CustomLoggingCSSParseExceptionCallback(URL cssUrl) {
            this.cssUrl = cssUrl;
        }

        public void onException(ParseException ex) {
            if (!IGNORE_UNRECOVERABLE_PARSING_ERROR) {
                throw new IllegalStateException("Failed to parse CSS: " + this.cssUrl + ", " + LoggingCSSParseErrorHandler.createLoggingStringParseError((ParseException)ex));
            }
            LOG.warn("Failed to parse CSS: " + this.cssUrl + ", " + LoggingCSSParseErrorHandler.createLoggingStringParseError((ParseException)ex));
        }
    }
}

