/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.protocol.http.control.DNSCacheManager;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class DNSCachePanel
extends AbstractConfigGui
implements ActionListener {
    private static final long serialVersionUID = 2120L;
    public static final String OPTIONS = JMeterUtils.getResString((String)"option");
    private static final String ADD_COMMAND = JMeterUtils.getResString((String)"add");
    private static final String DELETE_COMMAND = JMeterUtils.getResString((String)"delete");
    private static final String SYS_RES_COMMAND = JMeterUtils.getResString((String)"use_system_dns_resolver");
    private static final String CUST_RES_COMMAND = JMeterUtils.getResString((String)"use_custom_dns_resolver");
    private JTable dnsServersTable;
    private JPanel dnsServersPanel;
    private JPanel dnsServButPanel;
    private PowerTableModel dnsServersTableModel;
    private JRadioButton sysResButton;
    private JRadioButton custResButton;
    private JButton deleteButton;
    private JButton addButton;
    private ButtonGroup providerDNSradioGroup = new ButtonGroup();
    private static final String[] COLUMN_RESOURCE_NAMES = new String[]{JMeterUtils.getResString((String)"dns_hostname_or_ip")};
    private static final Class<?>[] columnClasses = new Class[]{String.class};
    private JCheckBox clearEachIteration;

    public DNSCachePanel() {
        this.init();
    }

    public String getLabelResource() {
        return "dns_cache_manager_title";
    }

    public void modifyTestElement(TestElement dnsRes) {
        GuiUtils.stopTableEditing((JTable)this.dnsServersTable);
        dnsRes.clear();
        this.configureTestElement(dnsRes);
        if (dnsRes instanceof DNSCacheManager) {
            DNSCacheManager dnsCacheManager = (DNSCacheManager)dnsRes;
            for (int i = 0; i < this.dnsServersTableModel.getRowCount(); ++i) {
                String server = (String)this.dnsServersTableModel.getRowData(i)[0];
                dnsCacheManager.addServer(server);
            }
            dnsCacheManager.setClearEachIteration(this.clearEachIteration.isSelected());
            if (this.providerDNSradioGroup.isSelected(this.custResButton.getModel())) {
                dnsCacheManager.setCustomResolver(true);
            } else {
                dnsCacheManager.setCustomResolver(false);
            }
        }
    }

    public void clearGui() {
        super.clearGui();
        this.clearEachIteration.setSelected(false);
        this.providerDNSradioGroup.setSelected(this.sysResButton.getModel(), true);
        this.dnsServersTableModel.clearData();
        this.deleteButton.setEnabled(false);
    }

    private void populateTable(DNSCacheManager resolver) {
        this.dnsServersTableModel.clearData();
        for (JMeterProperty jMeterProperty : resolver.getServers()) {
            this.addServerToTable((String)jMeterProperty.getObjectValue());
        }
    }

    public TestElement createTestElement() {
        DNSCacheManager dnsCacheManager = new DNSCacheManager();
        this.modifyTestElement((TestElement)dnsCacheManager);
        return dnsCacheManager;
    }

    public void configure(TestElement el) {
        super.configure(el);
        DNSCacheManager dnsCacheManager = (DNSCacheManager)el;
        this.populateTable(dnsCacheManager);
        this.clearEachIteration.setSelected(dnsCacheManager.isClearEachIteration());
        if (dnsCacheManager.isCustomResolver()) {
            this.providerDNSradioGroup.setSelected(this.custResButton.getModel(), true);
            this.deleteButton.setEnabled(this.dnsServersTable.getColumnCount() > 0);
            this.addButton.setEnabled(true);
        } else {
            this.providerDNSradioGroup.setSelected(this.sysResButton.getModel(), true);
        }
    }

    private void init() {
        this.dnsServersTableModel = new PowerTableModel(COLUMN_RESOURCE_NAMES, (Class[])columnClasses);
        this.clearEachIteration = new JCheckBox(JMeterUtils.getResString((String)"clear_cache_each_iteration"), true);
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        JPanel northPanel = new JPanel();
        northPanel.setLayout((LayoutManager)new VerticalLayout(5, 3));
        northPanel.add(this.makeTitlePanel());
        JPanel optionsPane = new JPanel();
        optionsPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), OPTIONS));
        optionsPane.setLayout((LayoutManager)new VerticalLayout(5, 3));
        optionsPane.add((Component)this.clearEachIteration, "West");
        optionsPane.add((Component)this.createChooseResPanel(), "South");
        northPanel.add(optionsPane);
        this.add(northPanel, "North");
        this.dnsServersPanel = this.createDnsServersTablePanel();
        this.add(this.dnsServersPanel, "Center");
    }

    public JPanel createDnsServersTablePanel() {
        this.dnsServersTable = new JTable((TableModel)this.dnsServersTableModel);
        JMeterUtils.applyHiDPI((JTable)this.dnsServersTable);
        this.dnsServersTable.setSelectionMode(0);
        this.dnsServersTable.setPreferredScrollableViewportSize(new Dimension(400, 100));
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"dns_servers")));
        JScrollPane dnsServScrollPane = new JScrollPane(this.dnsServersTable);
        panel.add((Component)dnsServScrollPane, "Center");
        this.dnsServButPanel = this.createButtonPanel();
        panel.add((Component)this.dnsServButPanel, "South");
        return panel;
    }

    private JPanel createChooseResPanel() {
        JPanel chooseResPanel = new JPanel(new BorderLayout(0, 5));
        this.sysResButton = new JRadioButton();
        this.sysResButton.setSelected(true);
        this.sysResButton.setText(SYS_RES_COMMAND);
        this.sysResButton.setToolTipText(SYS_RES_COMMAND);
        this.sysResButton.setEnabled(true);
        this.sysResButton.addActionListener(this);
        this.custResButton = new JRadioButton();
        this.custResButton.setSelected(false);
        this.custResButton.setText(CUST_RES_COMMAND);
        this.custResButton.setToolTipText(CUST_RES_COMMAND);
        this.custResButton.setEnabled(true);
        this.custResButton.addActionListener(this);
        this.providerDNSradioGroup.add(this.sysResButton);
        this.providerDNSradioGroup.add(this.custResButton);
        chooseResPanel.add((Component)this.sysResButton, "West");
        chooseResPanel.add((Component)this.custResButton, "Center");
        return chooseResPanel;
    }

    private JPanel createButtonPanel() {
        boolean tableEmpty = this.dnsServersTableModel.getRowCount() == 0;
        this.addButton = this.createButton("add", 'A', ADD_COMMAND, this.custResButton.isSelected());
        this.deleteButton = this.createButton("delete", 'D', DELETE_COMMAND, !tableEmpty);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add((Component)this.addButton, "West");
        buttonPanel.add((Component)this.deleteButton, "After");
        return buttonPanel;
    }

    private JButton createButton(String resName, char mnemonic, String command, boolean enabled) {
        JButton button = new JButton(JMeterUtils.getResString((String)resName));
        button.setMnemonic(mnemonic);
        button.setActionCommand(command);
        button.setEnabled(enabled);
        button.addActionListener(this);
        return button;
    }

    private void addServerToTable(String dnsServer) {
        this.dnsServersTableModel.addRow(new Object[]{dnsServer});
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        this.dnsServersTable.setEnabled(this.custResButton.isSelected());
        Color greyColor = new Color(240, 240, 240);
        Color blueColor = new Color(184, 207, 229);
        this.dnsServersTable.setBackground(this.sysResButton.isSelected() ? greyColor : Color.WHITE);
        this.dnsServersTable.setSelectionBackground(this.sysResButton.isSelected() ? greyColor : blueColor);
        this.addButton.setEnabled(this.custResButton.isSelected());
        this.deleteButton.setEnabled(this.custResButton.isSelected());
        if (this.custResButton.isSelected() && this.dnsServersTableModel.getRowCount() > 0) {
            this.deleteButton.setEnabled(true);
            this.addButton.setEnabled(true);
        }
        if (action.equals(DELETE_COMMAND)) {
            if (this.dnsServersTableModel.getRowCount() > 0) {
                GuiUtils.cancelEditing((JTable)this.dnsServersTable);
                int rowSelected = this.dnsServersTable.getSelectedRow();
                if (rowSelected != -1) {
                    this.dnsServersTableModel.removeRow(rowSelected);
                    this.dnsServersTableModel.fireTableDataChanged();
                    if (this.dnsServersTableModel.getRowCount() == 0) {
                        this.deleteButton.setEnabled(false);
                    } else {
                        int rowToSelect = rowSelected;
                        if (rowSelected >= this.dnsServersTableModel.getRowCount()) {
                            rowToSelect = rowSelected - 1;
                        }
                        this.dnsServersTable.setRowSelectionInterval(rowToSelect, rowToSelect);
                    }
                }
            }
        } else if (action.equals(ADD_COMMAND)) {
            GuiUtils.stopTableEditing((JTable)this.dnsServersTable);
            this.dnsServersTableModel.addNewRow();
            this.dnsServersTableModel.fireTableDataChanged();
            if (!this.deleteButton.isEnabled()) {
                this.deleteButton.setEnabled(true);
            }
            int rowToSelect = this.dnsServersTableModel.getRowCount() - 1;
            this.dnsServersTable.setRowSelectionInterval(rowToSelect, rowToSelect);
        }
    }
}

