/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.apache.jmeter.util.JMeterUtils;
import org.w3c.dom.Document;

public final class DOMPool {
    private static final Map<Object, Document> MEMCACHE = Collections.synchronizedMap(new LRUMap(JMeterUtils.getPropDefault((String)"soap.document_cache", (int)50)));

    public static Document getDocument(Object key) {
        return MEMCACHE.get(key);
    }

    public static void putDocument(Object key, Document data) {
        MEMCACHE.put(key, data);
    }

    private DOMPool() {
    }

    public static void clear() {
        MEMCACHE.clear();
    }
}

