/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util.accesslog;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.protocol.http.util.accesslog.Filter;
import org.apache.jmeter.testelement.TestCloneable;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;

public class SessionFilter
implements Filter,
Serializable,
TestCloneable,
ThreadListener {
    private static final long serialVersionUID = 232L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected Map<String, CookieManager> cookieManagers;
    protected Set<CookieManager> managersInUse;
    protected CookieManager lastUsed;

    protected boolean hasExcPattern(String text) {
        return false;
    }

    protected String getIpAddress(String logLine) {
        Pattern incIp = JMeterUtils.getPatternCache().getPattern("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}", 32784);
        Perl5Matcher matcher = JMeterUtils.getMatcher();
        matcher.contains(logLine, incIp);
        return matcher.getMatch().group(0);
    }

    public void reset() {
        this.cookieManagers.clear();
    }

    public Object clone() {
        if (this.cookieManagers == null) {
            this.cookieManagers = new ConcurrentHashMap<String, CookieManager>();
        }
        if (this.managersInUse == null) {
            this.managersInUse = Collections.synchronizedSet(new HashSet());
        }
        SessionFilter f = new SessionFilter();
        f.cookieManagers = this.cookieManagers;
        f.managersInUse = this.managersInUse;
        return f;
    }

    public void excludeFiles(String[] filenames) {
    }

    public void excludePattern(String[] regexp) {
    }

    public String filter(String text) {
        return text;
    }

    public void includeFiles(String[] filenames) {
    }

    public void includePattern(String[] regexp) {
    }

    public boolean isFiltered(String path, TestElement sampler) {
        String ipAddr = this.getIpAddress(path);
        CookieManager cm = this.getCookieManager(ipAddr);
        ((HTTPSampler)sampler).setCookieManager(cm);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CookieManager getCookieManager(String ipAddr) {
        CookieManager cm = null;
        Set<CookieManager> set = this.managersInUse;
        synchronized (set) {
            if (this.lastUsed != null) {
                this.managersInUse.remove(this.lastUsed);
                this.managersInUse.notify();
            }
        }
        if (this.lastUsed != null) {
            Thread.yield();
        }
        set = this.managersInUse;
        synchronized (set) {
            cm = this.cookieManagers.get(ipAddr);
            if (cm == null) {
                cm = new CookieManager();
                this.cookieManagers.put(ipAddr, cm);
            }
            while (this.managersInUse.contains(cm)) {
                try {
                    this.managersInUse.wait();
                }
                catch (InterruptedException e) {
                    log.info("SessionFilter wait interrupted");
                }
            }
            this.managersInUse.add(cm);
            this.lastUsed = cm;
        }
        return cm;
    }

    public void setReplaceExtension(String oldextension, String newextension) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadFinished() {
        Set<CookieManager> set = this.managersInUse;
        synchronized (set) {
            this.managersInUse.remove(this.lastUsed);
            this.managersInUse.notify();
        }
    }

    public void threadStarted() {
    }
}

