/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.parser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.jmeter.protocol.http.parser.URLString;
import org.apache.jmeter.protocol.http.util.ConversionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLCollection {
    private final Collection<URLString> coll;

    public URLCollection(Collection<URLString> c) {
        this.coll = c;
    }

    public boolean add(URL u) {
        return this.coll.add(new URLString(u));
    }

    private boolean add(String s) {
        return this.coll.add(new URLString(s));
    }

    public boolean addURL(String url, URL baseUrl) {
        if (url == null || url.length() == 0) {
            return false;
        }
        url = StringEscapeUtils.unescapeXml((String)url);
        boolean b = false;
        try {
            b = this.add(ConversionUtils.makeRelativeURL(baseUrl, url));
        }
        catch (MalformedURLException mfue) {
            b = this.add(url);
        }
        return b;
    }

    public Iterator<URL> iterator() {
        return new UrlIterator(this.coll.iterator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UrlIterator
    implements Iterator<URL> {
        private final Iterator<URLString> iter;

        UrlIterator(Iterator<URLString> i) {
            this.iter = i;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public URL next() {
            return this.iter.next().getURL();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

