/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.jmeter.samplers.SampleResult;

public class MeasuringConnectionManager
extends PoolingClientConnectionManager {
    private MeasuringConnectionRequest measuredConnection;
    private SampleResult sample;

    public MeasuringConnectionManager(SchemeRegistry schemeRegistry, DnsResolver resolver) {
        super(schemeRegistry, resolver);
    }

    public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
        ClientConnectionRequest res = super.requestConnection(route, state);
        this.measuredConnection = new MeasuringConnectionRequest(res, this.sample);
        return this.measuredConnection;
    }

    public void setSample(SampleResult sample) {
        this.sample = sample;
    }

    private static class MeasuredConnection
    implements ManagedClientConnection {
        private final ManagedClientConnection handler;
        private final SampleResult sample;

        public MeasuredConnection(ManagedClientConnection res, SampleResult sample) {
            this.handler = res;
            this.sample = sample;
        }

        public void open(HttpRoute route, HttpContext context, HttpParams params) throws IOException {
            this.handler.open(route, context, params);
            if (this.sample != null) {
                this.sample.connectEnd();
            }
        }

        public boolean isSecure() {
            return this.handler.isSecure();
        }

        public HttpRoute getRoute() {
            return this.handler.getRoute();
        }

        public SSLSession getSSLSession() {
            return this.handler.getSSLSession();
        }

        public void tunnelTarget(boolean secure, HttpParams params) throws IOException {
            this.handler.tunnelTarget(secure, params);
        }

        public void tunnelProxy(HttpHost next, boolean secure, HttpParams params) throws IOException {
            this.handler.tunnelProxy(next, secure, params);
        }

        public void layerProtocol(HttpContext context, HttpParams params) throws IOException {
            this.handler.layerProtocol(context, params);
        }

        public void markReusable() {
            this.handler.markReusable();
        }

        public void unmarkReusable() {
            this.handler.unmarkReusable();
        }

        public boolean isMarkedReusable() {
            return this.handler.isMarkedReusable();
        }

        public void setState(Object state) {
            this.handler.setState(state);
        }

        public Object getState() {
            return this.handler.getState();
        }

        public void setIdleDuration(long duration, TimeUnit unit) {
            this.handler.setIdleDuration(duration, unit);
        }

        public void releaseConnection() throws IOException {
            this.handler.releaseConnection();
        }

        public void abortConnection() throws IOException {
            this.handler.abortConnection();
        }

        public boolean isResponseAvailable(int timeout) throws IOException {
            return this.handler.isResponseAvailable(timeout);
        }

        public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
            this.handler.sendRequestHeader(request);
        }

        public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
            this.handler.sendRequestEntity(request);
        }

        public HttpResponse receiveResponseHeader() throws HttpException, IOException {
            return this.handler.receiveResponseHeader();
        }

        public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
            this.handler.receiveResponseEntity(response);
        }

        public void flush() throws IOException {
            this.handler.flush();
        }

        public InetAddress getLocalAddress() {
            return this.handler.getLocalAddress();
        }

        public int getLocalPort() {
            return this.handler.getLocalPort();
        }

        public InetAddress getRemoteAddress() {
            return this.handler.getRemoteAddress();
        }

        public int getRemotePort() {
            return this.handler.getRemotePort();
        }

        public void close() throws IOException {
            this.handler.close();
        }

        public boolean isOpen() {
            return this.handler.isOpen();
        }

        public boolean isStale() {
            return this.handler.isStale();
        }

        public void setSocketTimeout(int timeout) {
            this.handler.setSocketTimeout(timeout);
        }

        public int getSocketTimeout() {
            return this.handler.getSocketTimeout();
        }

        public void shutdown() throws IOException {
            this.handler.shutdown();
        }

        public HttpConnectionMetrics getMetrics() {
            return this.handler.getMetrics();
        }
    }

    private static class MeasuringConnectionRequest
    implements ClientConnectionRequest {
        private final ClientConnectionRequest handler;
        private final SampleResult sample;

        public MeasuringConnectionRequest(ClientConnectionRequest res, SampleResult sample) {
            this.handler = res;
            this.sample = sample;
        }

        public ManagedClientConnection getConnection(long timeout, TimeUnit tunit) throws InterruptedException, ConnectionPoolTimeoutException {
            ManagedClientConnection res = this.handler.getConnection(timeout, tunit);
            return new MeasuredConnection(res, this.sample);
        }

        public void abortRequest() {
            this.handler.abortRequest();
        }
    }
}

