/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.util.Map;
import org.apache.jmeter.protocol.http.parser.HTMLParseException;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;
import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.Tag;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.tags.FormTag;
import org.htmlparser.util.NodeIterator;
import org.htmlparser.util.ParserException;

public class FormCharSetFinder {
    private static final Logger log = LoggingManager.getLoggerForClass();

    public void addFormActionsAndCharSet(String html, Map<String, String> formEncodings, String pageEncoding) throws HTMLParseException {
        if (log.isDebugEnabled()) {
            log.debug("Parsing html of: " + html);
        }
        Parser htmlParser = null;
        try {
            htmlParser = new Parser();
            htmlParser.setInputHTML(html);
        }
        catch (Exception e) {
            throw new HTMLParseException(e);
        }
        try {
            this.parseNodes(htmlParser.elements(), formEncodings, pageEncoding);
            log.debug("End   : parseNodes");
        }
        catch (ParserException e) {
            throw new HTMLParseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseNodes(NodeIterator e, Map<String, String> formEncodings, String pageEncoding) throws HTMLParseException, ParserException {
        while (e.hasMoreNodes()) {
            Node node = e.nextNode();
            if (!(node instanceof Tag)) continue;
            Tag tag = (Tag)node;
            if (tag instanceof FormTag) {
                String action = tag.getAttribute("action");
                String acceptCharSet = tag.getAttribute("accept-charset");
                if (action != null && action.length() > 0) {
                    String[] charSets;
                    String formCharSet = pageEncoding;
                    if (acceptCharSet != null && (charSets = JOrphanUtils.split((String)acceptCharSet, (String)",")).length > 0 && (formCharSet = charSets[0].trim()).length() == 0) {
                        formCharSet = null;
                    }
                    if (formCharSet != null) {
                        Map<String, String> map = formEncodings;
                        synchronized (map) {
                            formEncodings.put(action, formCharSet);
                        }
                    }
                }
            }
            if (!(tag instanceof CompositeTag)) continue;
            CompositeTag composite = (CompositeTag)tag;
            this.parseNodes((NodeIterator)composite.elements(), formEncodings, pageEncoding);
        }
    }

    static {
        log.info("Using htmlparser version: " + Parser.getVersion());
    }
}

