/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.net.BindException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.gui.LogicControllerGui;
import org.apache.jmeter.control.gui.TreeNodeWrapper;
import org.apache.jmeter.engine.util.ValueReplacer;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.UnsharedComponent;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.http.proxy.ProxyControl;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFactory;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.WorkBench;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ProxyControlGui
extends LogicControllerGui
implements JMeterGUIComponent,
ActionListener,
ItemListener,
KeyListener,
UnsharedComponent {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 232L;
    private static final String NEW_LINE = "\n";
    private static final String SPACE = " ";
    private static final String USE_DEFAULT_HTTP_IMPL = "";
    private static final String SUGGESTED_EXCLUSIONS = JMeterUtils.getPropDefault((String)"proxy.excludes.suggested", (String)".*\\.(bmp|css|js|gif|ico|jpe?g|png|swf|woff)");
    private JTextField portField;
    private JLabeledTextField sslDomains;
    private JCheckBox httpHeaders;
    private JComboBox groupingMode;
    private JCheckBox addAssertions;
    private JCheckBox useKeepAlive;
    private JCheckBox regexMatch;
    private JComboBox samplerTypeName;
    private JCheckBox samplerRedirectAutomatically;
    private JCheckBox samplerFollowRedirects;
    private JCheckBox samplerDownloadImages;
    private JTextField contentTypeInclude;
    private JTextField contentTypeExclude;
    private JComboBox targetNodes;
    private JCheckBox notifyChildSamplerListenerOfFilteredSamplersCB;
    private DefaultComboBoxModel targetNodesModel;
    private ProxyControl model;
    private JTable excludeTable;
    private PowerTableModel excludeModel;
    private JTable includeTable;
    private PowerTableModel includeModel;
    private static final String CHANGE_TARGET = "change_target";
    private JButton stop;
    private JButton start;
    private JButton restart;
    private static final String STOP = "stop";
    private static final String START = "start";
    private static final String RESTART = "restart";
    private static final String ENABLE_RESTART = "enable_restart";
    private static final String ADD_INCLUDE = "add_include";
    private static final String ADD_EXCLUDE = "add_exclude";
    private static final String DELETE_INCLUDE = "delete_include";
    private static final String DELETE_EXCLUDE = "delete_exclude";
    private static final String ADD_TO_INCLUDE_FROM_CLIPBOARD = "include_clipboard";
    private static final String ADD_TO_EXCLUDE_FROM_CLIPBOARD = "exclude_clipboard";
    private static final String ADD_SUGGESTED_EXCLUDES = "exclude_suggested";
    private static final String INCLUDE_COL = "patterns_to_include";
    private static final String EXCLUDE_COL = "patterns_to_exclude";
    private static final String PORTFIELD = "portField";

    public ProxyControlGui() {
        log.debug("Creating ProxyControlGui");
        this.init();
    }

    public TestElement createTestElement() {
        this.model = this.makeProxyControl();
        log.debug("creating/configuring model = " + (Object)((Object)this.model));
        this.modifyTestElement((TestElement)this.model);
        return this.model;
    }

    protected ProxyControl makeProxyControl() {
        ProxyControl local = new ProxyControl();
        return local;
    }

    public void modifyTestElement(TestElement el) {
        GuiUtils.stopTableEditing((JTable)this.excludeTable);
        GuiUtils.stopTableEditing((JTable)this.includeTable);
        this.configureTestElement(el);
        if (el instanceof ProxyControl) {
            this.model = (ProxyControl)el;
            this.model.setPort(this.portField.getText());
            this.model.setSslDomains(this.sslDomains.getText());
            this.setIncludeListInProxyControl(this.model);
            this.setExcludeListInProxyControl(this.model);
            this.model.setCaptureHttpHeaders(this.httpHeaders.isSelected());
            this.model.setGroupingMode(this.groupingMode.getSelectedIndex());
            this.model.setAssertions(this.addAssertions.isSelected());
            if (this.samplerTypeName.getSelectedIndex() < HTTPSamplerFactory.getImplementations().length) {
                this.model.setSamplerTypeName(HTTPSamplerFactory.getImplementations()[this.samplerTypeName.getSelectedIndex()]);
            } else {
                this.model.setSamplerTypeName(USE_DEFAULT_HTTP_IMPL);
            }
            this.model.setSamplerRedirectAutomatically(this.samplerRedirectAutomatically.isSelected());
            this.model.setSamplerFollowRedirects(this.samplerFollowRedirects.isSelected());
            this.model.setUseKeepAlive(this.useKeepAlive.isSelected());
            this.model.setSamplerDownloadImages(this.samplerDownloadImages.isSelected());
            this.model.setNotifyChildSamplerListenerOfFilteredSamplers(this.notifyChildSamplerListenerOfFilteredSamplersCB.isSelected());
            this.model.setRegexMatch(this.regexMatch.isSelected());
            this.model.setContentTypeInclude(this.contentTypeInclude.getText());
            this.model.setContentTypeExclude(this.contentTypeExclude.getText());
            TreeNodeWrapper nw = (TreeNodeWrapper)this.targetNodes.getSelectedItem();
            if (nw == null) {
                this.model.setTarget(null);
            } else {
                this.model.setTarget(nw.getTreeNode());
            }
        }
    }

    protected void setIncludeListInProxyControl(ProxyControl element) {
        List<String> includeList = this.getDataList(this.includeModel, INCLUDE_COL);
        element.setIncludeList(includeList);
    }

    protected void setExcludeListInProxyControl(ProxyControl element) {
        List<String> excludeList = this.getDataList(this.excludeModel, EXCLUDE_COL);
        element.setExcludeList(excludeList);
    }

    private List<String> getDataList(PowerTableModel p_model, String colName) {
        String[] dataArray = p_model.getData().getColumn(colName);
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < dataArray.length; ++i) {
            list.add(dataArray[i]);
        }
        return list;
    }

    public String getLabelResource() {
        return "proxy_title";
    }

    public Collection<String> getMenuCategories() {
        return Arrays.asList("menu_non_test_elements");
    }

    public void configure(TestElement element) {
        log.debug("Configuring gui with " + element);
        super.configure(element);
        this.model = (ProxyControl)element;
        this.portField.setText(this.model.getPortString());
        this.sslDomains.setText(this.model.getSslDomains());
        this.httpHeaders.setSelected(this.model.getCaptureHttpHeaders());
        this.groupingMode.setSelectedIndex(this.model.getGroupingMode());
        this.addAssertions.setSelected(this.model.getAssertions());
        this.samplerTypeName.setSelectedItem(this.model.getSamplerTypeName());
        this.samplerRedirectAutomatically.setSelected(this.model.getSamplerRedirectAutomatically());
        this.samplerFollowRedirects.setSelected(this.model.getSamplerFollowRedirects());
        this.useKeepAlive.setSelected(this.model.getUseKeepalive());
        this.samplerDownloadImages.setSelected(this.model.getSamplerDownloadImages());
        this.notifyChildSamplerListenerOfFilteredSamplersCB.setSelected(this.model.getNotifyChildSamplerListenerOfFilteredSamplers());
        this.regexMatch.setSelected(this.model.getRegexMatch());
        this.contentTypeInclude.setText(this.model.getContentTypeInclude());
        this.contentTypeExclude.setText(this.model.getContentTypeExclude());
        this.reinitializeTargetCombo();
        this.populateTable(this.includeModel, this.model.getIncludePatterns().iterator());
        this.populateTable(this.excludeModel, this.model.getExcludePatterns().iterator());
        this.repaint();
    }

    private void populateTable(PowerTableModel p_model, PropertyIterator iter) {
        p_model.clearData();
        while (iter.hasNext()) {
            p_model.addRow(new Object[]{iter.next().getStringValue()});
        }
        p_model.fireTableDataChanged();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.enableRestart();
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        String command = action.getActionCommand();
        Object source = action.getSource();
        if (source.equals(this.samplerFollowRedirects) && this.samplerFollowRedirects.isSelected()) {
            this.samplerRedirectAutomatically.setSelected(false);
        } else if (source.equals(this.samplerRedirectAutomatically) && this.samplerRedirectAutomatically.isSelected()) {
            this.samplerFollowRedirects.setSelected(false);
        }
        if (command.equals(STOP)) {
            this.model.stopProxy();
            this.stop.setEnabled(false);
            this.start.setEnabled(true);
            this.restart.setEnabled(false);
        } else if (command.equals(START)) {
            this.startProxy();
        } else if (command.equals(RESTART)) {
            this.model.stopProxy();
            this.startProxy();
        } else if (command.equals(ENABLE_RESTART)) {
            this.enableRestart();
        } else if (command.equals(ADD_EXCLUDE)) {
            this.excludeModel.addNewRow();
            this.excludeModel.fireTableDataChanged();
            this.enableRestart();
        } else if (command.equals(ADD_INCLUDE)) {
            this.includeModel.addNewRow();
            this.includeModel.fireTableDataChanged();
            this.enableRestart();
        } else if (command.equals(DELETE_EXCLUDE)) {
            this.excludeModel.removeRow(this.excludeTable.getSelectedRow());
            this.excludeModel.fireTableDataChanged();
            this.enableRestart();
        } else if (command.equals(DELETE_INCLUDE)) {
            this.includeModel.removeRow(this.includeTable.getSelectedRow());
            this.includeModel.fireTableDataChanged();
            this.enableRestart();
        } else if (command.equals(CHANGE_TARGET)) {
            log.debug("Change target " + this.targetNodes.getSelectedItem());
            log.debug("In model " + (Object)((Object)this.model));
            TreeNodeWrapper nw = (TreeNodeWrapper)this.targetNodes.getSelectedItem();
            this.model.setTarget(nw.getTreeNode());
            this.enableRestart();
        } else if (command.equals(ADD_TO_INCLUDE_FROM_CLIPBOARD)) {
            this.addFromClipboard(this.includeTable);
            this.includeModel.fireTableDataChanged();
            this.enableRestart();
        } else if (command.equals(ADD_TO_EXCLUDE_FROM_CLIPBOARD)) {
            this.addFromClipboard(this.excludeTable);
            this.excludeModel.fireTableDataChanged();
            this.enableRestart();
        } else if (command.equals(ADD_SUGGESTED_EXCLUDES)) {
            this.addSuggestedExcludes(this.excludeTable);
            this.excludeModel.fireTableDataChanged();
            this.enableRestart();
        }
    }

    protected void addSuggestedExcludes(JTable table) {
        GuiUtils.stopTableEditing((JTable)table);
        int rowCount = table.getRowCount();
        PowerTableModel model = null;
        String[] exclusions = SUGGESTED_EXCLUSIONS.split(";");
        if (exclusions.length > 0 && (model = (PowerTableModel)table.getModel()) != null) {
            for (String clipboardLine : exclusions) {
                model.addRow(new Object[]{clipboardLine});
            }
            if (table.getRowCount() > rowCount) {
                int rowToSelect = model.getRowCount() - 1;
                table.setRowSelectionInterval(rowCount, rowToSelect);
            }
        }
    }

    protected void addFromClipboard(JTable table) {
        GuiUtils.stopTableEditing((JTable)table);
        int rowCount = table.getRowCount();
        PowerTableModel model = null;
        try {
            String clipboardContent = GuiUtils.getPastedText();
            if (clipboardContent != null) {
                String[] clipboardLines;
                for (String clipboardLine : clipboardLines = clipboardContent.split(NEW_LINE)) {
                    model = (PowerTableModel)table.getModel();
                    model.addRow(new Object[]{clipboardLine});
                }
                if (table.getRowCount() > rowCount && model != null) {
                    int rowToSelect = model.getRowCount() - 1;
                    table.setRowSelectionInterval(rowCount, rowToSelect);
                }
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog((Component)((Object)this), JMeterUtils.getResString((String)"proxy_daemon_error_read_args") + NEW_LINE + ioe.getLocalizedMessage(), JMeterUtils.getResString((String)"error_title"), 0);
        }
        catch (UnsupportedFlavorException ufe) {
            JOptionPane.showMessageDialog((Component)((Object)this), JMeterUtils.getResString((String)"proxy_daemon_error_not_retrieve") + SPACE + DataFlavor.stringFlavor.getHumanPresentableName() + SPACE + JMeterUtils.getResString((String)"proxy_daemon_error_from_clipboard") + ufe.getLocalizedMessage(), JMeterUtils.getResString((String)"error_title"), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProxy() {
        ValueReplacer replacer = GuiPackage.getInstance().getReplacer();
        this.modifyTestElement((TestElement)this.model);
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            replacer.replaceValues((TestElement)this.model);
            this.model.startProxy();
            this.start.setEnabled(false);
            this.stop.setEnabled(true);
            this.restart.setEnabled(false);
            if (ProxyControl.isDynamicMode()) {
                String[] details = this.model.getCertificateDetails();
                StringBuilder sb = new StringBuilder();
                sb.append(JMeterUtils.getResString((String)"proxy_daemon_msg_rootca_cert")).append(SPACE).append("ApacheJMeterTemporaryRootCA").append(SPACE).append(JMeterUtils.getResString((String)"proxy_daemon_msg_created_in_bin"));
                sb.append(NEW_LINE).append(JMeterUtils.getResString((String)"proxy_daemon_msg_install_as_in_doc"));
                sb.append(NEW_LINE).append(JMeterUtils.getResString((String)"proxy_daemon_msg_check_details")).append(NEW_LINE).append(NEW_LINE);
                for (String detail : details) {
                    sb.append(detail).append(NEW_LINE);
                }
                JOptionPane.showMessageDialog((Component)((Object)this), sb.toString(), JMeterUtils.getResString((String)"proxy_daemon_msg_rootca_cert") + SPACE + "ApacheJMeterTemporaryRootCA" + SPACE + JMeterUtils.getResString((String)"proxy_daemon_msg_created_in_bin"), 1);
            }
        }
        catch (InvalidVariableException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), JMeterUtils.getResString((String)"invalid_variables") + ": " + e.getMessage(), JMeterUtils.getResString((String)"error_title"), 0);
        }
        catch (BindException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), JMeterUtils.getResString((String)"proxy_daemon_bind_error") + ": " + e.getMessage(), JMeterUtils.getResString((String)"error_title"), 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), JMeterUtils.getResString((String)"proxy_daemon_error") + ": " + e.getMessage(), JMeterUtils.getResString((String)"error_title"), 0);
        }
        finally {
            this.setCursor(cursor);
        }
    }

    private void enableRestart() {
        if (this.stop.isEnabled()) {
            this.restart.setEnabled(true);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        String fieldName = e.getComponent().getName();
        if (fieldName.equals(PORTFIELD)) {
            block5: {
                try {
                    Integer.parseInt(this.portField.getText());
                }
                catch (NumberFormatException nfe) {
                    int length = this.portField.getText().length();
                    if (length <= 0) break block5;
                    JOptionPane.showMessageDialog((Component)((Object)this), JMeterUtils.getResString((String)"proxy_settings_port_error_digits"), JMeterUtils.getResString((String)"proxy_settings_port_error_invalid_data"), 2);
                    this.portField.setText(this.portField.getText().substring(0, length - 1));
                }
            }
            this.enableRestart();
        } else if (fieldName.equals(ENABLE_RESTART)) {
            this.enableRestart();
        }
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel mainPanel = new JPanel(new BorderLayout());
        Box myBox = Box.createVerticalBox();
        myBox.add(this.createPortPanel());
        myBox.add(Box.createVerticalStrut(5));
        myBox.add(this.createTestPlanContentPanel());
        myBox.add(Box.createVerticalStrut(5));
        myBox.add(this.createHTTPSamplerPanel());
        myBox.add(Box.createVerticalStrut(5));
        myBox.add(this.createContentTypePanel());
        myBox.add(Box.createVerticalStrut(5));
        mainPanel.add((Component)myBox, "North");
        Box includeExcludePanel = Box.createVerticalBox();
        includeExcludePanel.add(this.createIncludePanel());
        includeExcludePanel.add(this.createExcludePanel());
        includeExcludePanel.add(this.createNotifyListenersPanel());
        mainPanel.add((Component)includeExcludePanel, "Center");
        mainPanel.add((Component)this.createControls(), "South");
        this.add(mainPanel, "Center");
    }

    private JPanel createControls() {
        this.start = new JButton(JMeterUtils.getResString((String)START));
        this.start.addActionListener(this);
        this.start.setActionCommand(START);
        this.start.setEnabled(true);
        this.stop = new JButton(JMeterUtils.getResString((String)STOP));
        this.stop.addActionListener(this);
        this.stop.setActionCommand(STOP);
        this.stop.setEnabled(false);
        this.restart = new JButton(JMeterUtils.getResString((String)RESTART));
        this.restart.addActionListener(this);
        this.restart.setActionCommand(RESTART);
        this.restart.setEnabled(false);
        JPanel panel = new JPanel();
        panel.add(this.start);
        panel.add(this.stop);
        panel.add(this.restart);
        return panel;
    }

    private JPanel createPortPanel() {
        this.portField = new JTextField(ProxyControl.DEFAULT_PORT_S, 5);
        this.portField.setName(PORTFIELD);
        this.portField.addKeyListener(this);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"port"));
        label.setLabelFor(this.portField);
        JPanel gPane = new JPanel(new BorderLayout());
        gPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"proxy_general_settings")));
        HorizontalPanel panel = new HorizontalPanel();
        panel.add((Component)label);
        panel.add((Component)this.portField);
        panel.add(Box.createHorizontalStrut(10));
        gPane.add((Component)panel, "West");
        this.sslDomains = new JLabeledTextField(JMeterUtils.getResString((String)"proxy_domains"));
        this.sslDomains.setEnabled(ProxyControl.isDynamicMode());
        if (ProxyControl.isDynamicMode()) {
            this.sslDomains.setToolTipText(JMeterUtils.getResString((String)"proxy_domains_dynamic_mode_tooltip"));
        } else {
            this.sslDomains.setToolTipText(JMeterUtils.getResString((String)"proxy_domains_dynamic_mode_tooltip_java6"));
        }
        gPane.add((Component)this.sslDomains, "Center");
        return gPane;
    }

    private JPanel createTestPlanContentPanel() {
        this.httpHeaders = new JCheckBox(JMeterUtils.getResString((String)"proxy_headers"));
        this.httpHeaders.setSelected(true);
        this.httpHeaders.addActionListener(this);
        this.httpHeaders.setActionCommand(ENABLE_RESTART);
        this.addAssertions = new JCheckBox(JMeterUtils.getResString((String)"proxy_assertions"));
        this.addAssertions.setSelected(false);
        this.addAssertions.addActionListener(this);
        this.addAssertions.setActionCommand(ENABLE_RESTART);
        this.regexMatch = new JCheckBox(JMeterUtils.getResString((String)"proxy_regex"));
        this.regexMatch.setSelected(false);
        this.regexMatch.addActionListener(this);
        this.regexMatch.setActionCommand(ENABLE_RESTART);
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"proxy_test_plan_content")));
        HorizontalPanel nodeCreationPanel = new HorizontalPanel();
        nodeCreationPanel.add((Component)this.createGroupingPanel());
        nodeCreationPanel.add((Component)this.httpHeaders);
        nodeCreationPanel.add((Component)this.addAssertions);
        nodeCreationPanel.add((Component)this.regexMatch);
        HorizontalPanel targetPanel = new HorizontalPanel();
        targetPanel.add((Component)this.createTargetPanel());
        mainPanel.add((Component)targetPanel);
        mainPanel.add((Component)nodeCreationPanel);
        return mainPanel;
    }

    private JPanel createHTTPSamplerPanel() {
        DefaultComboBoxModel<String> m = new DefaultComboBoxModel<String>();
        for (String s : HTTPSamplerFactory.getImplementations()) {
            m.addElement(s);
        }
        m.addElement(USE_DEFAULT_HTTP_IMPL);
        this.samplerTypeName = new JComboBox(m);
        this.samplerTypeName.setPreferredSize(new Dimension(150, 20));
        this.samplerTypeName.setSelectedItem(USE_DEFAULT_HTTP_IMPL);
        this.samplerTypeName.addItemListener(this);
        JLabel label2 = new JLabel(JMeterUtils.getResString((String)"proxy_sampler_type"));
        label2.setLabelFor(this.samplerTypeName);
        this.samplerRedirectAutomatically = new JCheckBox(JMeterUtils.getResString((String)"follow_redirects_auto"));
        this.samplerRedirectAutomatically.setSelected(false);
        this.samplerRedirectAutomatically.addActionListener(this);
        this.samplerRedirectAutomatically.setActionCommand(ENABLE_RESTART);
        this.samplerFollowRedirects = new JCheckBox(JMeterUtils.getResString((String)"follow_redirects"));
        this.samplerFollowRedirects.setSelected(true);
        this.samplerFollowRedirects.addActionListener(this);
        this.samplerFollowRedirects.setActionCommand(ENABLE_RESTART);
        this.useKeepAlive = new JCheckBox(JMeterUtils.getResString((String)"use_keepalive"));
        this.useKeepAlive.setSelected(true);
        this.useKeepAlive.addActionListener(this);
        this.useKeepAlive.setActionCommand(ENABLE_RESTART);
        this.samplerDownloadImages = new JCheckBox(JMeterUtils.getResString((String)"web_testing_retrieve_images"));
        this.samplerDownloadImages.setSelected(false);
        this.samplerDownloadImages.addActionListener(this);
        this.samplerDownloadImages.setActionCommand(ENABLE_RESTART);
        HorizontalPanel panel = new HorizontalPanel();
        panel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"proxy_sampler_settings")));
        panel.add((Component)label2);
        panel.add((Component)this.samplerTypeName);
        panel.add((Component)this.samplerRedirectAutomatically);
        panel.add((Component)this.samplerFollowRedirects);
        panel.add((Component)this.useKeepAlive);
        panel.add((Component)this.samplerDownloadImages);
        return panel;
    }

    private JPanel createTargetPanel() {
        this.targetNodesModel = new DefaultComboBoxModel();
        this.targetNodes = new JComboBox(this.targetNodesModel);
        this.targetNodes.setPrototypeDisplayValue(USE_DEFAULT_HTTP_IMPL);
        JPopupMenu popup = (JPopupMenu)this.targetNodes.getUI().getAccessibleChild(this.targetNodes, 0);
        JScrollPane scrollPane = this.findScrollPane(popup);
        if (scrollPane != null) {
            scrollPane.setHorizontalScrollBar(new JScrollBar(0));
            scrollPane.setHorizontalScrollBarPolicy(30);
        }
        this.targetNodes.setActionCommand(CHANGE_TARGET);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"proxy_target"));
        label.setLabelFor(this.targetNodes);
        HorizontalPanel panel = new HorizontalPanel();
        panel.add((Component)label);
        panel.add((Component)this.targetNodes);
        return panel;
    }

    private JScrollPane findScrollPane(JPopupMenu popup) {
        Component[] components;
        for (Component component : components = popup.getComponents()) {
            if (!(component instanceof JScrollPane)) continue;
            return (JScrollPane)component;
        }
        return null;
    }

    private JPanel createGroupingPanel() {
        DefaultComboBoxModel<String> m = new DefaultComboBoxModel<String>();
        m.addElement(JMeterUtils.getResString((String)"grouping_no_groups"));
        m.addElement(JMeterUtils.getResString((String)"grouping_add_separators"));
        m.addElement(JMeterUtils.getResString((String)"grouping_in_controllers"));
        m.addElement(JMeterUtils.getResString((String)"grouping_store_first_only"));
        m.addElement(JMeterUtils.getResString((String)"grouping_in_transaction_controllers"));
        this.groupingMode = new JComboBox(m);
        this.groupingMode.setPreferredSize(new Dimension(150, 20));
        this.groupingMode.setSelectedIndex(0);
        this.groupingMode.addItemListener(this);
        JLabel label2 = new JLabel(JMeterUtils.getResString((String)"grouping_mode"));
        label2.setLabelFor(this.groupingMode);
        HorizontalPanel panel = new HorizontalPanel();
        panel.add((Component)label2);
        panel.add((Component)this.groupingMode);
        return panel;
    }

    private JPanel createContentTypePanel() {
        this.contentTypeInclude = new JTextField(35);
        this.contentTypeInclude.addKeyListener(this);
        this.contentTypeInclude.setName(ENABLE_RESTART);
        JLabel labelInclude = new JLabel(JMeterUtils.getResString((String)"proxy_content_type_include"));
        labelInclude.setLabelFor(this.contentTypeInclude);
        this.contentTypeInclude.setText(JMeterUtils.getProperty((String)"proxy.content_type_include"));
        this.contentTypeExclude = new JTextField(35);
        this.contentTypeExclude.addKeyListener(this);
        this.contentTypeExclude.setName(ENABLE_RESTART);
        JLabel labelExclude = new JLabel(JMeterUtils.getResString((String)"proxy_content_type_exclude"));
        labelExclude.setLabelFor(this.contentTypeExclude);
        this.contentTypeExclude.setText(JMeterUtils.getProperty((String)"proxy.content_type_exclude"));
        HorizontalPanel panel = new HorizontalPanel();
        panel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"proxy_content_type_filter")));
        panel.add((Component)labelInclude);
        panel.add((Component)this.contentTypeInclude);
        panel.add((Component)labelExclude);
        panel.add((Component)this.contentTypeExclude);
        return panel;
    }

    private JPanel createIncludePanel() {
        this.includeModel = new PowerTableModel(new String[]{INCLUDE_COL}, new Class[]{String.class});
        this.includeTable = new JTable((TableModel)this.includeModel);
        this.includeTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        this.includeTable.setPreferredScrollableViewportSize(new Dimension(100, 30));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)INCLUDE_COL)));
        panel.add((Component)new JScrollPane(this.includeTable), "Center");
        panel.add((Component)this.createTableButtonPanel(ADD_INCLUDE, DELETE_INCLUDE, ADD_TO_INCLUDE_FROM_CLIPBOARD, null), "South");
        return panel;
    }

    private JPanel createExcludePanel() {
        this.excludeModel = new PowerTableModel(new String[]{EXCLUDE_COL}, new Class[]{String.class});
        this.excludeTable = new JTable((TableModel)this.excludeModel);
        this.excludeTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        this.excludeTable.setPreferredScrollableViewportSize(new Dimension(100, 30));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)EXCLUDE_COL)));
        panel.add((Component)new JScrollPane(this.excludeTable), "Center");
        panel.add((Component)this.createTableButtonPanel(ADD_EXCLUDE, DELETE_EXCLUDE, ADD_TO_EXCLUDE_FROM_CLIPBOARD, ADD_SUGGESTED_EXCLUDES), "South");
        return panel;
    }

    private JPanel createNotifyListenersPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"notify_child_listeners_fr")));
        this.notifyChildSamplerListenerOfFilteredSamplersCB = new JCheckBox(JMeterUtils.getResString((String)"notify_child_listeners_fr"));
        this.notifyChildSamplerListenerOfFilteredSamplersCB.setSelected(true);
        this.notifyChildSamplerListenerOfFilteredSamplersCB.addActionListener(this);
        this.notifyChildSamplerListenerOfFilteredSamplersCB.setActionCommand(ENABLE_RESTART);
        panel.add(this.notifyChildSamplerListenerOfFilteredSamplersCB);
        return panel;
    }

    private JPanel createTableButtonPanel(String addCommand, String deleteCommand, String copyFromClipboard, String addSuggestedExcludes) {
        JPanel buttonPanel = new JPanel();
        JButton addButton = new JButton(JMeterUtils.getResString((String)"add"));
        addButton.setActionCommand(addCommand);
        addButton.addActionListener(this);
        buttonPanel.add(addButton);
        JButton deleteButton = new JButton(JMeterUtils.getResString((String)"delete"));
        deleteButton.setActionCommand(deleteCommand);
        deleteButton.addActionListener(this);
        buttonPanel.add(deleteButton);
        JButton addFromClipboard = new JButton(JMeterUtils.getResString((String)"add_from_clipboard"));
        addFromClipboard.setActionCommand(copyFromClipboard);
        addFromClipboard.addActionListener(this);
        buttonPanel.add(addFromClipboard);
        if (addSuggestedExcludes != null) {
            JButton addFromSuggestedExcludes = new JButton(JMeterUtils.getResString((String)"add_from_suggested_excludes"));
            addFromSuggestedExcludes.setActionCommand(addSuggestedExcludes);
            addFromSuggestedExcludes.addActionListener(this);
            buttonPanel.add(addFromSuggestedExcludes);
        }
        return buttonPanel;
    }

    private void reinitializeTargetCombo() {
        log.debug("Reinitializing target combo");
        this.targetNodes.removeActionListener(this);
        this.targetNodesModel.removeAllElements();
        GuiPackage gp = GuiPackage.getInstance();
        if (gp != null) {
            JMeterTreeNode root = (JMeterTreeNode)GuiPackage.getInstance().getTreeModel().getRoot();
            this.targetNodesModel.addElement(new TreeNodeWrapper(null, JMeterUtils.getResString((String)"use_recording_controller")));
            this.buildNodesModel(root, USE_DEFAULT_HTTP_IMPL, 0);
        }
        TreeNodeWrapper choice = null;
        for (int i = 0; i < this.targetNodesModel.getSize(); ++i) {
            choice = (TreeNodeWrapper)this.targetNodesModel.getElementAt(i);
            log.debug("Selecting item " + choice + " for model " + (Object)((Object)this.model) + " in " + this);
            if (choice.getTreeNode() == this.model.getTarget()) break;
        }
        this.targetNodes.addActionListener(this);
        this.targetNodesModel.setSelectedItem(choice);
        log.debug("Reinitialization complete");
    }

    private void buildNodesModel(JMeterTreeNode node, String parent_name, int level) {
        String separator = " > ";
        if (node != null) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                StringBuilder name = new StringBuilder();
                JMeterTreeNode cur = (JMeterTreeNode)node.getChildAt(i);
                TestElement te = cur.getTestElement();
                if (te instanceof Controller) {
                    name.append(parent_name);
                    name.append(cur.getName());
                    TreeNodeWrapper tnw = new TreeNodeWrapper(cur, name.toString());
                    this.targetNodesModel.addElement(tnw);
                    name.append(separator);
                    this.buildNodesModel(cur, name.toString(), level + 1);
                    continue;
                }
                if (!(te instanceof TestPlan) && !(te instanceof WorkBench)) continue;
                name.append(cur.getName());
                name.append(separator);
                this.buildNodesModel(cur, name.toString(), 0);
            }
        }
    }
}

