/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.protocol.http.control.Cookie;
import org.apache.jmeter.protocol.http.control.CookieHandler;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.control.HC3CookieHandler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.JLabeledChoice;
import org.apache.jorphan.gui.layout.VerticalLayout;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class CookiePanel
extends AbstractConfigGui
implements ActionListener {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String ADD_COMMAND = "Add";
    private static final String DELETE_COMMAND = "Delete";
    private static final String LOAD_COMMAND = "Load";
    private static final String SAVE_COMMAND = "Save";
    private static final String HANDLER_COMMAND = "Handler";
    private JTable cookieTable;
    private PowerTableModel tableModel;
    private JCheckBox clearEachIteration;
    private JComboBox selectHandlerPanel;
    private HashMap<String, String> handlerMap = new HashMap();
    private static final String[] COLUMN_RESOURCE_NAMES = new String[]{"name", "value", "domain", "path", "secure"};
    private static final Class<?>[] columnClasses = new Class[]{String.class, String.class, String.class, String.class, Boolean.class};
    private JButton addButton;
    private JButton deleteButton;
    private JButton loadButton;
    private JButton saveButton;
    private final String[] policies = new String[]{"default", "compatibility", "rfc2109", "rfc2965", "ignorecookies", "netscape"};
    private JLabeledChoice policy;

    public CookiePanel() {
        this.init();
    }

    public String getLabelResource() {
        return "cookie_manager_title";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block22: {
            String action = e.getActionCommand();
            if (action.equals(DELETE_COMMAND)) {
                if (this.tableModel.getRowCount() > 0) {
                    int rowSelected;
                    if (this.cookieTable.isEditing()) {
                        TableCellEditor cellEditor = this.cookieTable.getCellEditor(this.cookieTable.getEditingRow(), this.cookieTable.getEditingColumn());
                        cellEditor.cancelCellEditing();
                    }
                    if ((rowSelected = this.cookieTable.getSelectedRow()) != -1) {
                        this.tableModel.removeRow(rowSelected);
                        this.tableModel.fireTableDataChanged();
                        if (this.tableModel.getRowCount() == 0) {
                            this.deleteButton.setEnabled(false);
                            this.saveButton.setEnabled(false);
                        } else {
                            int rowToSelect = rowSelected;
                            if (rowSelected >= this.tableModel.getRowCount()) {
                                rowToSelect = rowSelected - 1;
                            }
                            this.cookieTable.setRowSelectionInterval(rowToSelect, rowToSelect);
                        }
                    }
                }
            } else if (action.equals(ADD_COMMAND)) {
                GuiUtils.stopTableEditing((JTable)this.cookieTable);
                this.tableModel.addNewRow();
                this.tableModel.fireTableDataChanged();
                if (!this.deleteButton.isEnabled()) {
                    this.deleteButton.setEnabled(true);
                }
                if (!this.saveButton.isEnabled()) {
                    this.saveButton.setEnabled(true);
                }
                int rowToSelect = this.tableModel.getRowCount() - 1;
                this.cookieTable.setRowSelectionInterval(rowToSelect, rowToSelect);
            } else if (action.equals(LOAD_COMMAND)) {
                try {
                    String[] _txt = new String[]{".txt"};
                    JFileChooser chooser = FileDialoger.promptToOpenFile((String[])_txt);
                    if (chooser == null) break block22;
                    CookieManager manager = new CookieManager();
                    manager.addFile(chooser.getSelectedFile().getAbsolutePath());
                    for (int i = 0; i < manager.getCookieCount(); ++i) {
                        this.addCookieToTable(manager.get(i));
                    }
                    this.tableModel.fireTableDataChanged();
                    if (this.tableModel.getRowCount() > 0) {
                        this.deleteButton.setEnabled(true);
                        this.saveButton.setEnabled(true);
                    }
                }
                catch (IOException ex) {
                    log.error("", (Throwable)ex);
                }
            } else if (action.equals(SAVE_COMMAND)) {
                try {
                    JFileChooser chooser = FileDialoger.promptToSaveFile((String)"cookies.txt");
                    if (chooser != null) {
                        ((CookieManager)this.createTestElement()).save(chooser.getSelectedFile().getAbsolutePath());
                    }
                }
                catch (IOException ex) {
                    JMeterUtils.reportErrorToUser((String)ex.getMessage(), (String)"Error saving cookies");
                }
            }
        }
    }

    private void addCookieToTable(Cookie cookie) {
        this.tableModel.addRow(new Object[]{cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.getSecure()});
    }

    public void modifyTestElement(TestElement cm) {
        GuiUtils.stopTableEditing((JTable)this.cookieTable);
        cm.clear();
        this.configureTestElement(cm);
        if (cm instanceof CookieManager) {
            CookieManager cookieManager = (CookieManager)cm;
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                Cookie cookie = this.createCookie(this.tableModel.getRowData(i));
                cookieManager.add(cookie);
            }
            cookieManager.setClearEachIteration(this.clearEachIteration.isSelected());
            cookieManager.setCookiePolicy(this.policy.getText());
            cookieManager.setImplementation(this.handlerMap.get(this.selectHandlerPanel.getSelectedItem()));
        }
    }

    public void clearGui() {
        super.clearGui();
        this.tableModel.clearData();
        this.clearEachIteration.setSelected(false);
        this.policy.setText("compatibility");
        this.selectHandlerPanel.setSelectedItem(CookieManager.DEFAULT_IMPLEMENTATION.substring(CookieManager.DEFAULT_IMPLEMENTATION.lastIndexOf(46) + 1));
        this.deleteButton.setEnabled(false);
        this.saveButton.setEnabled(false);
    }

    private Cookie createCookie(Object[] rowData) {
        Cookie cookie = new Cookie((String)rowData[0], (String)rowData[1], (String)rowData[2], (String)rowData[3], (Boolean)rowData[4], 0L);
        return cookie;
    }

    private void populateTable(CookieManager manager) {
        this.tableModel.clearData();
        PropertyIterator iter = manager.getCookies().iterator();
        while (iter.hasNext()) {
            this.addCookieToTable((Cookie)iter.next().getObjectValue());
        }
    }

    public TestElement createTestElement() {
        CookieManager cookieManager = new CookieManager();
        this.modifyTestElement((TestElement)cookieManager);
        return cookieManager;
    }

    public void configure(TestElement el) {
        super.configure(el);
        CookieManager cookieManager = (CookieManager)el;
        this.populateTable(cookieManager);
        this.clearEachIteration.setSelected(cookieManager.getClearEachIteration());
        this.policy.setText(cookieManager.getPolicy());
        String fullImpl = cookieManager.getImplementation();
        this.selectHandlerPanel.setSelectedItem(fullImpl.substring(fullImpl.lastIndexOf(46) + 1));
    }

    private void init() {
        this.tableModel = new PowerTableModel(COLUMN_RESOURCE_NAMES, (Class[])columnClasses);
        this.clearEachIteration = new JCheckBox(JMeterUtils.getResString((String)"clear_cookies_per_iter"), false);
        this.policy = new JLabeledChoice(JMeterUtils.getResString((String)"cookie_manager_policy"), this.policies);
        this.policy.setText("compatibility");
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        JPanel northPanel = new JPanel();
        northPanel.setLayout((LayoutManager)new VerticalLayout(5, 3));
        northPanel.add(this.makeTitlePanel());
        JPanel optionsPane = new JPanel();
        optionsPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"cookie_options")));
        optionsPane.setLayout((LayoutManager)new VerticalLayout(5, 3));
        optionsPane.add(this.clearEachIteration);
        JPanel policyTypePane = new JPanel();
        policyTypePane.setLayout(new FlowLayout(0, 0, 0));
        policyTypePane.add((Component)this.policy);
        policyTypePane.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"cookie_implementation_choose"), (JComboBox)this.createComboHandler()));
        optionsPane.add(policyTypePane);
        northPanel.add(optionsPane);
        this.add(northPanel, "North");
        this.add(this.createCookieTablePanel(), "Center");
    }

    public JPanel createCookieTablePanel() {
        this.cookieTable = new JTable((TableModel)this.tableModel);
        this.cookieTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        this.cookieTable.setSelectionMode(0);
        this.cookieTable.setPreferredScrollableViewportSize(new Dimension(100, 70));
        JPanel buttonPanel = this.createButtonPanel();
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"cookies_stored")));
        panel.add((Component)new JScrollPane(this.cookieTable), "Center");
        panel.add((Component)buttonPanel, "South");
        return panel;
    }

    private JButton createButton(String resName, char mnemonic, String command, boolean enabled) {
        JButton button = new JButton(JMeterUtils.getResString((String)resName));
        button.setMnemonic(mnemonic);
        button.setActionCommand(command);
        button.setEnabled(enabled);
        button.addActionListener(this);
        return button;
    }

    private JPanel createButtonPanel() {
        boolean tableEmpty = this.tableModel.getRowCount() == 0;
        this.addButton = this.createButton("add", 'A', ADD_COMMAND, true);
        this.deleteButton = this.createButton("delete", 'D', DELETE_COMMAND, !tableEmpty);
        this.loadButton = this.createButton("load", 'L', LOAD_COMMAND, true);
        this.saveButton = this.createButton("save", 'S', SAVE_COMMAND, !tableEmpty);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.deleteButton);
        buttonPanel.add(this.loadButton);
        buttonPanel.add(this.saveButton);
        return buttonPanel;
    }

    private JComboBox createComboHandler() {
        DefaultComboBoxModel nodesModel = new DefaultComboBoxModel();
        this.selectHandlerPanel = new JComboBox(nodesModel);
        this.selectHandlerPanel.setActionCommand(HANDLER_COMMAND);
        this.selectHandlerPanel.addActionListener(this);
        List classesToAdd = Collections.emptyList();
        try {
            classesToAdd = JMeterUtils.findClassesThatExtend(CookieHandler.class);
        }
        catch (IOException e1) {
            // empty catch block
        }
        String tmpName = null;
        for (String clazz : classesToAdd) {
            String shortClazz = clazz.substring(clazz.lastIndexOf(46) + 1);
            if (HC3CookieHandler.class.getName().equals(clazz)) {
                tmpName = shortClazz;
            }
            this.selectHandlerPanel.addItem(shortClazz);
            this.handlerMap.put(shortClazz, clazz);
        }
        nodesModel.setSelectedItem(tmpName);
        return this.selectHandlerPanel;
    }
}

