/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.gui.util.TextBoxDialoger;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.RequestView;
import org.apache.jmeter.visualizers.SamplerResultTab;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.gui.RendererUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.Functor;
import org.apache.log.Logger;

public class RequestViewHTTP
implements RequestView {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String KEY_LABEL = "view_results_table_request_tab_http";
    private static final String CHARSET_DECODE = "ISO-8859-1";
    private static final String PARAM_CONCATENATE = "&";
    private JPanel paneParsed;
    private ObjectTableModel requestModel = new ObjectTableModel(COLUMNS_REQUEST, SamplerResultTab.RowResult.class, new Functor[]{new Functor("getKey"), new Functor("getValue")}, new Functor[]{null, null}, new Class[]{String.class, String.class}, false);
    private ObjectTableModel paramsModel = new ObjectTableModel(COLUMNS_PARAMS, SamplerResultTab.RowResult.class, new Functor[]{new Functor("getKey"), new Functor("getValue")}, new Functor[]{null, null}, new Class[]{String.class, String.class}, false);
    private ObjectTableModel headersModel = new ObjectTableModel(COLUMNS_HEADERS, SamplerResultTab.RowResult.class, new Functor[]{new Functor("getKey"), new Functor("getValue")}, new Functor[]{null, null}, new Class[]{String.class, String.class}, false);
    private static final String[] COLUMNS_REQUEST = new String[]{" ", " "};
    private static final String[] COLUMNS_PARAMS = new String[]{"view_results_table_request_params_key", "view_results_table_request_params_value"};
    private static final String[] COLUMNS_HEADERS = new String[]{"view_results_table_request_headers_key", "view_results_table_request_headers_value"};
    private JTable tableRequest = null;
    private JTable tableParams = null;
    private JTable tableHeaders = null;
    private static final TableCellRenderer[] RENDERERS_REQUEST = new TableCellRenderer[]{null, null};
    private static final TableCellRenderer[] RENDERERS_PARAMS = new TableCellRenderer[]{null, null};
    private static final TableCellRenderer[] RENDERERS_HEADERS = new TableCellRenderer[]{null, null};

    public void init() {
        this.paneParsed = new JPanel(new BorderLayout(0, 5));
        this.paneParsed.add(this.createRequestPane());
    }

    public void clearData() {
        this.requestModel.clearData();
        this.paramsModel.clearData();
        this.headersModel.clearData();
    }

    public void setSamplerResult(Object objectResult) {
        if (objectResult instanceof HTTPSampleResult) {
            String cookie;
            HTTPSampleResult sampleResult = (HTTPSampleResult)((Object)objectResult);
            this.requestModel.addRow((Object)new SamplerResultTab.RowResult(JMeterUtils.getResString((String)"view_results_table_request_http_method"), (Object)sampleResult.getHTTPMethod()));
            URL hUrl = sampleResult.getURL();
            if (hUrl != null) {
                this.requestModel.addRow((Object)new SamplerResultTab.RowResult(JMeterUtils.getResString((String)"view_results_table_request_http_protocol"), (Object)hUrl.getProtocol()));
                this.requestModel.addRow((Object)new SamplerResultTab.RowResult(JMeterUtils.getResString((String)"view_results_table_request_http_host"), (Object)hUrl.getHost()));
                int port = hUrl.getPort() == -1 ? hUrl.getDefaultPort() : hUrl.getPort();
                this.requestModel.addRow((Object)new SamplerResultTab.RowResult(JMeterUtils.getResString((String)"view_results_table_request_http_port"), (Object)port));
                this.requestModel.addRow((Object)new SamplerResultTab.RowResult(JMeterUtils.getResString((String)"view_results_table_request_http_path"), (Object)hUrl.getPath()));
                String queryGet = hUrl.getQuery() == null ? "" : hUrl.getQuery();
                String queryPost = sampleResult.getQueryString();
                if (queryPost != null && queryPost.length() > 0) {
                    if (queryGet.length() > 0) {
                        queryGet = queryGet + PARAM_CONCATENATE;
                    }
                    queryGet = queryGet + queryPost;
                }
                if ((queryGet = RequestViewHTTP.decodeQuery(queryGet)) != null) {
                    Set<Map.Entry<String, String>> keys = RequestViewHTTP.getQueryMap(queryGet).entrySet();
                    for (Map.Entry<String, String> entry : keys) {
                        this.paramsModel.addRow((Object)new SamplerResultTab.RowResult(entry.getKey(), (Object)entry.getValue()));
                    }
                }
            }
            if ((cookie = sampleResult.getCookies()) != null && cookie.length() > 0) {
                this.headersModel.addRow((Object)new SamplerResultTab.RowResult(JMeterUtils.getParsedLabel((String)"view_results_table_request_http_cookie"), (Object)sampleResult.getCookies()));
            }
            LinkedHashMap lhm = JMeterUtils.parseHeaders((String)sampleResult.getRequestHeaders());
            for (Map.Entry entry : lhm.entrySet()) {
                this.headersModel.addRow((Object)new SamplerResultTab.RowResult((String)entry.getKey(), entry.getValue()));
            }
        } else {
            this.requestModel.addRow((Object)new SamplerResultTab.RowResult("", (Object)JMeterUtils.getResString((String)"view_results_table_request_http_nohttp")));
        }
    }

    public static Map<String, String> getQueryMap(String query) {
        String[] params;
        HashMap<String, String> map = new HashMap<String, String>();
        if (query.trim().startsWith("<?")) {
            map.put(" ", query);
            return map;
        }
        for (String param : params = query.split(PARAM_CONCATENATE)) {
            String[] paramSplit = param.split("=");
            if (paramSplit.length > 2) {
                map.clear();
                map.put(" ", query);
                return map;
            }
            String name = null;
            if (paramSplit.length > 0) {
                name = paramSplit[0];
            }
            String value = "";
            if (paramSplit.length > 1) {
                value = param.substring(param.indexOf("=") + 1);
            }
            map.put(name, value);
        }
        return map;
    }

    public static String decodeQuery(String query) {
        if (query != null && query.length() > 0) {
            try {
                query = URLDecoder.decode(query, CHARSET_DECODE);
            }
            catch (IllegalArgumentException e) {
                log.warn("Error decoding query, maybe your request parameters should be encoded:" + query, (Throwable)e);
                return null;
            }
            catch (UnsupportedEncodingException uee) {
                log.warn("Error decoding query, maybe your request parameters should be encoded:" + query, (Throwable)uee);
                return null;
            }
            return query;
        }
        return null;
    }

    public JPanel getPanel() {
        return this.paneParsed;
    }

    private Component createRequestPane() {
        this.tableRequest = new JTable((TableModel)this.requestModel);
        this.tableRequest.setToolTipText(JMeterUtils.getResString((String)"textbox_tooltip_cell"));
        this.tableRequest.addMouseListener((MouseListener)new TextBoxDialoger.TextBoxDoubleClick(this.tableRequest));
        this.setFirstColumnPreferredSize(this.tableRequest);
        RendererUtils.applyRenderers((JTable)this.tableRequest, (TableCellRenderer[])RENDERERS_REQUEST);
        this.tableParams = new JTable((TableModel)this.paramsModel);
        this.tableParams.setToolTipText(JMeterUtils.getResString((String)"textbox_tooltip_cell"));
        this.tableParams.addMouseListener((MouseListener)new TextBoxDialoger.TextBoxDoubleClick(this.tableParams));
        this.setFirstColumnPreferredSize(this.tableParams);
        this.tableParams.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        RendererUtils.applyRenderers((JTable)this.tableParams, (TableCellRenderer[])RENDERERS_PARAMS);
        this.tableHeaders = new JTable((TableModel)this.headersModel);
        this.tableHeaders.setToolTipText(JMeterUtils.getResString((String)"textbox_tooltip_cell"));
        this.tableHeaders.addMouseListener((MouseListener)new TextBoxDialoger.TextBoxDoubleClick(this.tableHeaders));
        this.setFirstColumnPreferredSize(this.tableHeaders);
        this.tableHeaders.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        RendererUtils.applyRenderers((JTable)this.tableHeaders, (TableCellRenderer[])RENDERERS_HEADERS);
        JSplitPane topSplit = new JSplitPane(0, GuiUtils.makeScrollPane((Component)this.tableParams), GuiUtils.makeScrollPane((Component)this.tableHeaders));
        topSplit.setOneTouchExpandable(true);
        topSplit.setResizeWeight(0.5);
        topSplit.setBorder(null);
        JSplitPane paneParsed = new JSplitPane(0, GuiUtils.makeScrollPane((Component)this.tableRequest), topSplit);
        paneParsed.setOneTouchExpandable(true);
        paneParsed.setResizeWeight(0.25);
        paneParsed.setBorder(null);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(paneParsed);
        return panel;
    }

    private void setFirstColumnPreferredSize(JTable table) {
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setMaxWidth(300);
        column.setPreferredWidth(160);
    }

    public String getLabel() {
        return JMeterUtils.getResString((String)KEY_LABEL);
    }
}

