/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.parser;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jmeter.protocol.http.parser.HTMLParseError;
import org.apache.jmeter.protocol.http.parser.HTMLParseException;
import org.apache.jmeter.protocol.http.parser.URLCollection;
import org.apache.jmeter.protocol.http.parser.URLString;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class HTMLParser {
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected static final String ATT_BACKGROUND = "background";
    protected static final String ATT_CODE = "code";
    protected static final String ATT_CODEBASE = "codebase";
    protected static final String ATT_DATA = "data";
    protected static final String ATT_HREF = "href";
    protected static final String ATT_REL = "rel";
    protected static final String ATT_SRC = "src";
    protected static final String ATT_STYLE = "style";
    protected static final String ATT_TYPE = "type";
    protected static final String ATT_IS_IMAGE = "image";
    protected static final String TAG_APPLET = "applet";
    protected static final String TAG_BASE = "base";
    protected static final String TAG_BGSOUND = "bgsound";
    protected static final String TAG_BODY = "body";
    protected static final String TAG_EMBED = "embed";
    protected static final String TAG_FRAME = "frame";
    protected static final String TAG_IFRAME = "iframe";
    protected static final String TAG_IMAGE = "img";
    protected static final String TAG_INPUT = "input";
    protected static final String TAG_LINK = "link";
    protected static final String TAG_OBJECT = "object";
    protected static final String TAG_SCRIPT = "script";
    protected static final String STYLESHEET = "stylesheet";
    private static final Map<String, HTMLParser> parsers = new ConcurrentHashMap<String, HTMLParser>(4);
    public static final String PARSER_CLASSNAME = "htmlParser.className";
    public static final String DEFAULT_PARSER = "org.apache.jmeter.protocol.http.parser.LagartoBasedHtmlParser";

    protected HTMLParser() {
    }

    public static final HTMLParser getParser() {
        return HTMLParser.getParser(JMeterUtils.getPropDefault((String)PARSER_CLASSNAME, (String)DEFAULT_PARSER));
    }

    public static final HTMLParser getParser(String htmlParserClassName) {
        HTMLParser pars = parsers.get(htmlParserClassName);
        if (pars != null) {
            log.debug("Fetched " + htmlParserClassName);
            return pars;
        }
        try {
            Object clazz = Class.forName(htmlParserClassName).newInstance();
            if (!(clazz instanceof HTMLParser)) {
                throw new HTMLParseError(new ClassCastException(htmlParserClassName));
            }
            pars = (HTMLParser)clazz;
        }
        catch (InstantiationException e) {
            throw new HTMLParseError(e);
        }
        catch (IllegalAccessException e) {
            throw new HTMLParseError(e);
        }
        catch (ClassNotFoundException e) {
            throw new HTMLParseError(e);
        }
        log.info("Created " + htmlParserClassName);
        if (pars.isReusable()) {
            parsers.put(htmlParserClassName, pars);
        }
        return pars;
    }

    public Iterator<URL> getEmbeddedResourceURLs(byte[] html, URL baseUrl, String encoding) throws HTMLParseException {
        LinkedHashSet<URLString> col = new LinkedHashSet<URLString>();
        return this.getEmbeddedResourceURLs(html, baseUrl, new URLCollection(col), encoding);
    }

    public abstract Iterator<URL> getEmbeddedResourceURLs(byte[] var1, URL var2, URLCollection var3, String var4) throws HTMLParseException;

    public Iterator<URL> getEmbeddedResourceURLs(byte[] html, URL baseUrl, Collection<URLString> coll, String encoding) throws HTMLParseException {
        return this.getEmbeddedResourceURLs(html, baseUrl, new URLCollection(coll), encoding);
    }

    protected boolean isReusable() {
        return false;
    }
}

