/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomFromMultipleVars
extends AbstractFunction {
    private static final Logger log = LoggerFactory.getLogger(RandomFromMultipleVars.class);
    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__RandomFromMultipleVars";
    private static final String SEPARATOR = "\\|";
    private CompoundVariable variablesNamesSplitBySeparator;
    private CompoundVariable varName;

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String variablesNamesSplitBySeparatorValue = this.variablesNamesSplitBySeparator.execute().trim();
        JMeterVariables vars = this.getVariables();
        String outputValue = "";
        String separator = "";
        if (vars != null) {
            String varTrim;
            String[] variables;
            ArrayList<String> results = new ArrayList<String>();
            for (String varName : variables = variablesNamesSplitBySeparatorValue.split(SEPARATOR)) {
                if (StringUtils.isEmpty((CharSequence)varName)) continue;
                this.extractVariableValuesToList(varName, vars, results);
            }
            if (results.size() > 0) {
                int randomIndex = ThreadLocalRandom.current().nextInt(0, results.size());
                outputValue = (String)results.get(randomIndex);
            } else if (log.isDebugEnabled()) {
                log.debug("RandomFromMultiResult didn't find <var>_matchNr in variables :'" + variablesNamesSplitBySeparatorValue + "' using separator:'" + separator + "', will return empty value");
            }
            if (this.varName != null && (varTrim = this.varName.execute().trim()).length() > 0) {
                vars.put(varTrim, outputValue);
            }
        }
        return outputValue;
    }

    private void extractVariableValuesToList(String variableName, JMeterVariables vars, List<String> results) throws NumberFormatException {
        String matchNumberAsStr = vars.get(variableName + "_matchNr");
        int matchNumber = 0;
        if (!StringUtils.isEmpty((CharSequence)matchNumberAsStr)) {
            matchNumber = Integer.parseInt(matchNumberAsStr);
        }
        if (matchNumber > 0) {
            for (int i = 1; i <= matchNumber; ++i) {
                results.add(vars.get(variableName + "_" + i));
            }
        } else {
            String value = vars.get(variableName);
            if (!StringUtils.isEmpty((CharSequence)value)) {
                results.add(value);
            }
        }
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 2);
        Object[] values = parameters.toArray();
        this.variablesNamesSplitBySeparator = (CompoundVariable)values[0];
        if (values.length > 1) {
            this.varName = (CompoundVariable)values[1];
        }
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"random_multi_result_source_variable"));
        desc.add(JMeterUtils.getResString((String)"random_multi_result_target_variable"));
    }
}

