/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class Jexl2Function
extends AbstractFunction {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String KEY = "__jexl2";
    private static final List<String> desc = new LinkedList<String>();
    private static final JexlEngine jexl = new JexlEngine();
    private Object[] values;

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String str = "";
        CompoundVariable var = (CompoundVariable)this.values[0];
        String exp = var.execute();
        String varName = "";
        if (this.values.length > 1) {
            varName = ((CompoundVariable)this.values[1]).execute().trim();
        }
        JMeterContext jmctx = JMeterContextService.getContext();
        JMeterVariables vars = jmctx.getVariables();
        try {
            MapContext jc = new MapContext();
            jc.set("log", (Object)log);
            jc.set("ctx", (Object)jmctx);
            jc.set("vars", (Object)vars);
            jc.set("props", (Object)JMeterUtils.getJMeterProperties());
            jc.set("threadName", (Object)Thread.currentThread().getName());
            jc.set("sampler", (Object)currentSampler);
            jc.set("sampleResult", (Object)previousResult);
            jc.set("OUT", (Object)System.out);
            Expression e = jexl.createExpression(exp);
            Object o = e.evaluate((JexlContext)jc);
            if (o != null) {
                str = o.toString();
            }
            if (vars != null && varName.length() > 0) {
                vars.put(varName, str);
            }
        }
        catch (Exception e) {
            log.error("An error occurred while evaluating the expression \"" + exp + "\"\n", (Throwable)e);
        }
        return str;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    public String getReferenceKey() {
        return KEY;
    }

    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 2);
        this.values = parameters.toArray();
    }

    static {
        jexl.setCache(512);
        jexl.setLenient(false);
        jexl.setSilent(false);
        desc.add(JMeterUtils.getResString((String)"jexl_expression"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
    }
}

