/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRowColContainer {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final ArrayList<ArrayList<String>> fileData;
    private final String fileName;
    public static final String DELIMITER = JMeterUtils.getPropDefault((String)"csvread.delimiter", (String)",");
    private int nextRow;
    private final String delimiter;

    public FileRowColContainer(String file, String delim) throws IOException, FileNotFoundException {
        log.debug("FRCC(" + file + "," + delim + ")");
        this.fileName = file;
        this.delimiter = delim;
        this.nextRow = 0;
        this.fileData = new ArrayList();
        this.load();
    }

    public FileRowColContainer(String file) throws IOException, FileNotFoundException {
        log.debug("FRCC(" + file + ")[" + DELIMITER + "]");
        this.fileName = file;
        this.delimiter = DELIMITER;
        this.nextRow = 0;
        this.fileData = new ArrayList();
        this.load();
    }

    private void load() throws IOException, FileNotFoundException {
        BufferedReader myBread = null;
        try {
            FileReader fis = new FileReader(this.fileName);
            myBread = new BufferedReader(fis);
            String line = myBread.readLine();
            while (line != null && line.length() > 0) {
                this.fileData.add(FileRowColContainer.splitLine(line, this.delimiter));
                line = myBread.readLine();
            }
        }
        catch (FileNotFoundException e) {
            this.fileData.clear();
            log.warn(e.toString());
            throw e;
        }
        catch (IOException e) {
            this.fileData.clear();
            log.warn(e.toString());
            throw e;
        }
        finally {
            if (myBread != null) {
                myBread.close();
            }
        }
    }

    public String getColumn(int row, int col) throws IndexOutOfBoundsException {
        String colData = this.fileData.get(row).get(col);
        log.debug(this.fileName + "(" + row + "," + col + "): " + colData);
        return colData;
    }

    public int nextRow() {
        int row = this.nextRow++;
        if (this.nextRow >= this.fileData.size()) {
            this.nextRow = 0;
        }
        log.debug("Row: " + row);
        return row;
    }

    private static ArrayList<String> splitLine(String theLine, String delim) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokener = new StringTokenizer(theLine, delim, true);
        boolean lastWasDelim = true;
        while (tokener.hasMoreTokens()) {
            String token = tokener.nextToken();
            if (token.equals(delim)) {
                if (lastWasDelim) {
                    result.add("");
                }
                lastWasDelim = true;
                continue;
            }
            lastWasDelim = false;
            result.add(token);
        }
        if (lastWasDelim) {
            result.add("");
        }
        return result;
    }

    public String getFileName() {
        return this.fileName;
    }

    final String getDelimiter() {
        return this.delimiter;
    }

    public int getSize() {
        return this.fileData.size();
    }
}

