/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.util.JMeterUtils;

public class UrlEncode
extends AbstractFunction {
    private static final String CHARSET_ENCODING = "UTF-8";
    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__urlencode";
    private Object[] values;

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String decodeString = "";
        try {
            String encodedString = ((CompoundVariable)this.values[0]).execute();
            decodeString = URLEncoder.encode(encodedString, CHARSET_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
        return decodeString;
    }

    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1);
        this.values = parameters.toArray();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"urlencode_string"));
    }
}

