/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.EnumerationUtils;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.apache.jmeter.visualizers.SearchTreePanel;
import org.apache.jmeter.visualizers.SearchableTreeNode;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GUIMenuSortOrder(value=1)
@TestElementMetadata(labelResource="view_results_tree_title")
public class ViewResultsFullVisualizer
extends AbstractVisualizer
implements ActionListener,
TreeSelectionListener,
Clearable,
ItemListener {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ViewResultsFullVisualizer.class);
    public static final Color SERVER_ERROR_COLOR = Color.red;
    public static final Color CLIENT_ERROR_COLOR = Color.blue;
    public static final Color REDIRECT_COLOR = Color.green;
    protected static final String COMBO_CHANGE_COMMAND = "change_combo";
    private static final Border RED_BORDER = BorderFactory.createLineBorder(Color.red);
    private static final Border BLUE_BORDER = BorderFactory.createLineBorder(Color.blue);
    private static final String ICON_SIZE = JMeterUtils.getPropDefault((String)"jmeter.tree.icons.size", (String)"19x19");
    private static final int MAX_DISPLAY_SIZE = JMeterUtils.getPropDefault((String)"view.results.tree.max_size", (int)0xA00000);
    private static final String VIEWERS_ORDER = JMeterUtils.getPropDefault((String)"view.results.tree.renderers_order", (String)"");
    private static final int REFRESH_PERIOD = JMeterUtils.getPropDefault((String)"jmeter.gui.refresh_period", (int)500);
    private static final ImageIcon imageSuccess = JMeterUtils.getImage((String)JMeterUtils.getPropDefault((String)"viewResultsTree.success", (String)("vrt/" + ICON_SIZE + "/security-high-2.png")));
    private static final ImageIcon imageFailure = JMeterUtils.getImage((String)JMeterUtils.getPropDefault((String)"viewResultsTree.failure", (String)("vrt/" + ICON_SIZE + "/security-low-2.png")));
    private JSplitPane mainSplit;
    private DefaultMutableTreeNode root;
    private DefaultTreeModel treeModel;
    private JTree jTree;
    private Component leftSide;
    private JTabbedPane rightSide;
    private JComboBox<ResultRenderer> selectRenderPanel;
    private int selectedTab;
    private ResultRenderer resultsRender = null;
    private Object resultsObject = null;
    private TreeSelectionEvent lastSelectionEvent;
    private JCheckBox autoScrollCB;
    private Buffer buffer;
    private boolean dataChanged;

    public ViewResultsFullVisualizer() {
        int maxResults = JMeterUtils.getPropDefault((String)"view.results.tree.max_results", (int)500);
        this.buffer = maxResults > 0 ? new CircularFifoBuffer(maxResults) : new UnboundedFifoBuffer();
        this.init();
        new Timer(REFRESH_PERIOD, e -> this.updateGui()).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SampleResult sample) {
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            this.buffer.add((Object)sample);
            this.dataChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGui() {
        TreePath selectedPath = null;
        HashSet<TreePath> newExpandedPaths = new HashSet<TreePath>();
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            if (!this.dataChanged) {
                return;
            }
            Enumeration<TreePath> expandedElements = this.jTree.getExpandedDescendants(new TreePath(this.root));
            Set<Object> oldExpandedElements = this.extractExpandedObjects(expandedElements);
            Object oldSelectedElement = this.getSelectedObject();
            this.root.removeAllChildren();
            for (Object sampler : this.buffer) {
                SampleResult res = (SampleResult)sampler;
                SearchableTreeNode currNode = new SearchableTreeNode(res, this.treeModel);
                this.treeModel.insertNodeInto(currNode, this.root, this.root.getChildCount());
                ArrayList<TreeNode> path = new ArrayList<TreeNode>(Arrays.asList(this.root, currNode));
                selectedPath = this.checkExpandedOrSelected(path, res, oldSelectedElement, oldExpandedElements, newExpandedPaths, selectedPath);
                TreePath potentialSelection = this.addSubResults(currNode, res, path, oldSelectedElement, oldExpandedElements, newExpandedPaths);
                if (potentialSelection != null) {
                    selectedPath = potentialSelection;
                }
                AssertionResult[] assertionResults = res.getAssertionResults();
                int assertionIndex = currNode.getChildCount();
                for (AssertionResult assertionResult : assertionResults) {
                    if (!assertionResult.isFailure() && !assertionResult.isError()) continue;
                    SearchableTreeNode assertionNode = new SearchableTreeNode(assertionResult, this.treeModel);
                    this.treeModel.insertNodeInto(assertionNode, currNode, assertionIndex++);
                    selectedPath = this.checkExpandedOrSelected(path, assertionResult, oldSelectedElement, oldExpandedElements, newExpandedPaths, selectedPath, assertionNode);
                }
            }
            this.treeModel.nodeStructureChanged(this.root);
            this.dataChanged = false;
        }
        if (this.root.getChildCount() == 1) {
            this.jTree.expandPath(new TreePath(this.root));
        }
        newExpandedPaths.stream().forEach(this.jTree::expandPath);
        if (selectedPath != null) {
            this.jTree.setSelectionPath(selectedPath);
        }
        if (this.autoScrollCB.isSelected() && this.root.getChildCount() > 1) {
            this.jTree.scrollPathToVisible(new TreePath(new Object[]{this.root, this.treeModel.getChild(this.root, this.root.getChildCount() - 1)}));
        }
    }

    private Object getSelectedObject() {
        DefaultMutableTreeNode oldSelectedNode = (DefaultMutableTreeNode)this.jTree.getLastSelectedPathComponent();
        Object oldSelectedElement = oldSelectedNode == null ? null : oldSelectedNode.getUserObject();
        return oldSelectedElement;
    }

    private TreePath checkExpandedOrSelected(List<TreeNode> path, Object item, Object oldSelectedObject, Set<Object> oldExpandedObjects, Set<TreePath> newExpandedPaths, TreePath defaultPath) {
        TreePath result = defaultPath;
        if (oldSelectedObject == item) {
            result = this.toTreePath(path);
        }
        if (oldExpandedObjects.contains(item)) {
            newExpandedPaths.add(this.toTreePath(path));
        }
        return result;
    }

    private TreePath checkExpandedOrSelected(List<TreeNode> path, Object item, Object oldSelectedObject, Set<Object> oldExpandedObjects, Set<TreePath> newExpandedPaths, TreePath defaultPath, DefaultMutableTreeNode extensionNode) {
        TreePath result = defaultPath;
        if (oldSelectedObject == item) {
            result = this.toTreePath(path, extensionNode);
        }
        if (oldExpandedObjects.contains(item)) {
            newExpandedPaths.add(this.toTreePath(path, extensionNode));
        }
        return result;
    }

    private Set<Object> extractExpandedObjects(Enumeration<TreePath> expandedElements) {
        if (expandedElements != null) {
            List list = EnumerationUtils.toList(expandedElements);
            log.debug("Expanded: {}", (Object)list);
            Set<Object> result = list.stream().map(TreePath::getLastPathComponent).map(c -> (DefaultMutableTreeNode)c).map(DefaultMutableTreeNode::getUserObject).collect(Collectors.toSet());
            log.debug("Elements: {}", result);
            return result;
        }
        return Collections.emptySet();
    }

    private TreePath addSubResults(DefaultMutableTreeNode currNode, SampleResult res, List<TreeNode> path, Object selectedObject, Set<Object> oldExpandedObjects, Set<TreePath> newExpandedPaths) {
        SampleResult[] subResults = res.getSubResults();
        int leafIndex = 0;
        TreePath result = null;
        for (SampleResult child : subResults) {
            log.debug("updateGui1 : child sample result - {}", (Object)child);
            SearchableTreeNode leafNode = new SearchableTreeNode(child, this.treeModel);
            this.treeModel.insertNodeInto(leafNode, currNode, leafIndex++);
            ArrayList<TreeNode> newPath = new ArrayList<TreeNode>(path);
            newPath.add(leafNode);
            result = this.checkExpandedOrSelected(newPath, child, selectedObject, oldExpandedObjects, newExpandedPaths, result);
            this.addSubResults(leafNode, child, newPath, selectedObject, oldExpandedObjects, newExpandedPaths);
            AssertionResult[] assertionResults = child.getAssertionResults();
            int assertionIndex = leafNode.getChildCount();
            for (AssertionResult item : assertionResults) {
                if (!item.isFailure() && !item.isError()) continue;
                SearchableTreeNode assertionNode = new SearchableTreeNode(item, this.treeModel);
                this.treeModel.insertNodeInto(assertionNode, leafNode, assertionIndex++);
                result = this.checkExpandedOrSelected(path, item, selectedObject, oldExpandedObjects, newExpandedPaths, result, assertionNode);
            }
        }
        return result;
    }

    private TreePath toTreePath(List<TreeNode> newPath) {
        return new TreePath(newPath.toArray(new TreeNode[newPath.size()]));
    }

    private TreePath toTreePath(List<TreeNode> path, DefaultMutableTreeNode extensionNode) {
        Object[] result = path.toArray(new TreeNode[path.size() + 1]);
        result[result.length - 1] = extensionNode;
        return new TreePath(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData() {
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            this.buffer.clear();
            this.dataChanged = true;
        }
        this.resultsRender.clearData();
        this.resultsObject = null;
    }

    public String getLabelResource() {
        return "view_results_tree_title";
    }

    private void init() {
        log.debug("init() - pass");
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.leftSide = this.createLeftPanel();
        this.rightSide = new JTabbedPane();
        this.mainSplit = new JSplitPane(1, this.leftSide, this.rightSide);
        this.mainSplit.setOneTouchExpandable(true);
        JSplitPane searchAndMainSP = new JSplitPane(0, new SearchTreePanel(this.root), this.mainSplit);
        searchAndMainSP.setOneTouchExpandable(true);
        JSplitPane splitPane = new JSplitPane(0, this.makeTitlePanel(), searchAndMainSP);
        splitPane.setOneTouchExpandable(true);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.add(splitPane);
        this.resultsRender.setRightSide(this.rightSide);
        this.resultsRender.init();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.valueChanged(e, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void valueChanged(TreeSelectionEvent e, boolean forceRendering) {
        DefaultMutableTreeNode node;
        this.lastSelectionEvent = e;
        ViewResultsFullVisualizer viewResultsFullVisualizer = this;
        synchronized (viewResultsFullVisualizer) {
            node = (DefaultMutableTreeNode)this.jTree.getLastSelectedPathComponent();
        }
        if (node != null && (forceRendering || node.getUserObject() != this.resultsObject)) {
            this.resultsObject = node.getUserObject();
            if (this.rightSide.getTabCount() > this.selectedTab) {
                this.resultsRender.setLastSelectedTab(this.rightSide.getSelectedIndex());
            }
            Object userObject = node.getUserObject();
            this.resultsRender.setSamplerResult(userObject);
            this.resultsRender.setupTabPane();
            if (userObject instanceof SampleResult) {
                SampleResult sampleResult = (SampleResult)userObject;
                if (ViewResultsFullVisualizer.isTextDataType(sampleResult)) {
                    this.resultsRender.renderResult(sampleResult);
                } else {
                    byte[] responseBytes = sampleResult.getResponseData();
                    if (responseBytes != null) {
                        this.resultsRender.renderImage(sampleResult);
                    }
                }
            }
        }
    }

    protected static boolean isTextDataType(SampleResult sampleResult) {
        return "text".equals(sampleResult.getDataType()) || StringUtils.isEmpty((CharSequence)sampleResult.getDataType());
    }

    private synchronized Component createLeftPanel() {
        SampleResult rootSampleResult = new SampleResult();
        rootSampleResult.setSampleLabel("Root");
        rootSampleResult.setSuccessful(true);
        this.root = new SearchableTreeNode(rootSampleResult, null);
        this.treeModel = new DefaultTreeModel(this.root);
        this.jTree = new JTree(this.treeModel);
        this.jTree.setCellRenderer(new ResultsNodeRenderer());
        this.jTree.getSelectionModel().setSelectionMode(1);
        this.jTree.addTreeSelectionListener(this);
        this.jTree.setRootVisible(false);
        this.jTree.setShowsRootHandles(true);
        JScrollPane treePane = new JScrollPane(this.jTree);
        treePane.setPreferredSize(new Dimension(200, 300));
        VerticalPanel leftPane = new VerticalPanel();
        leftPane.add((Component)treePane, (Object)"Center");
        leftPane.add(this.createComboRender(), (Object)"North");
        this.autoScrollCB = new JCheckBox(JMeterUtils.getResString((String)"view_results_autoscroll"));
        this.autoScrollCB.setSelected(false);
        this.autoScrollCB.addItemListener(this);
        leftPane.add((Component)this.autoScrollCB, (Object)"South");
        return leftPane;
    }

    private Component createComboRender() {
        DefaultComboBoxModel nodesModel = new DefaultComboBoxModel();
        this.selectRenderPanel = new JComboBox(nodesModel);
        this.selectRenderPanel.setActionCommand(COMBO_CHANGE_COMMAND);
        this.selectRenderPanel.addActionListener(this);
        List classesToAdd = Collections.emptyList();
        try {
            classesToAdd = JMeterUtils.findClassesThatExtend(ResultRenderer.class);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String defaultRenderer = this.expandToClassname(".RenderAsText");
        if (VIEWERS_ORDER.length() > 0) {
            defaultRenderer = this.expandToClassname(VIEWERS_ORDER.split(",", 2)[0]);
        }
        ResultRenderer defaultObject = null;
        HashMap<String, ResultRenderer> map = new HashMap<String, ResultRenderer>(classesToAdd.size());
        for (String clazz : classesToAdd) {
            try {
                ResultRenderer renderer2 = (ResultRenderer)Class.forName(clazz).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (defaultRenderer.equals(clazz)) {
                    defaultObject = renderer2;
                }
                renderer2.setBackgroundColor(this.getBackground());
                map.put(renderer2.getClass().getName(), renderer2);
            }
            catch (NoClassDefFoundError e) {
                if (e.getMessage() != null && e.getMessage().contains("javafx")) {
                    log.info("Add JavaFX to your Java installation if you want to use renderer: {}", (Object)clazz);
                    continue;
                }
                log.warn("Error loading result renderer: {}", (Object)clazz, (Object)e);
            }
            catch (Exception e) {
                log.warn("Error loading result renderer: {}", (Object)clazz, (Object)e);
            }
        }
        if (VIEWERS_ORDER.length() > 0) {
            Arrays.stream(VIEWERS_ORDER.split(",")).map(this::expandToClassname).forEach(key -> {
                ResultRenderer renderer = (ResultRenderer)map.remove(key);
                if (renderer != null) {
                    this.selectRenderPanel.addItem(renderer);
                } else {
                    log.warn("Missing (check renderer name) or already added (check doublon) result renderer, check property 'view.results.tree.renderers_order', renderer name: '{}'", key);
                }
            });
        }
        map.values().forEach(renderer -> this.selectRenderPanel.addItem((ResultRenderer)renderer));
        nodesModel.setSelectedItem(defaultObject);
        return this.selectRenderPanel;
    }

    private String expandToClassname(String name) {
        if (name.startsWith(".")) {
            return "org.apache.jmeter.visualizers" + name;
        }
        return name;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JComboBox jcb;
        String command = event.getActionCommand();
        if (COMBO_CHANGE_COMMAND.equals(command) && (jcb = (JComboBox)event.getSource()) != null) {
            this.resultsRender = (ResultRenderer)jcb.getSelectedItem();
            if (this.rightSide != null) {
                this.selectedTab = this.rightSide.getSelectedIndex();
                int dividerLocation = this.mainSplit.getDividerLocation();
                this.mainSplit.remove(this.rightSide);
                this.rightSide = new JTabbedPane();
                this.mainSplit.add(this.rightSide);
                this.mainSplit.setDividerLocation(dividerLocation);
                this.resultsRender.setRightSide(this.rightSide);
                this.resultsRender.setLastSelectedTab(this.selectedTab);
                log.debug("selectedTab={}", (Object)this.selectedTab);
                this.resultsRender.init();
                this.valueChanged(this.lastSelectionEvent, true);
            }
        }
    }

    public static String getResponseAsString(SampleResult res) {
        String response = null;
        if (ViewResultsFullVisualizer.isTextDataType(res)) {
            int len = res.getResponseDataAsString().length();
            if (MAX_DISPLAY_SIZE > 0 && len > MAX_DISPLAY_SIZE) {
                StringBuilder builder = new StringBuilder(MAX_DISPLAY_SIZE + 100);
                builder.append(JMeterUtils.getResString((String)"view_results_response_too_large_message")).append(len).append(" > Max: ").append(MAX_DISPLAY_SIZE).append(", ").append(JMeterUtils.getResString((String)"view_results_response_partial_message")).append("\n").append(res.getResponseDataAsString(), 0, MAX_DISPLAY_SIZE).append("\n...");
                response = builder.toString();
            } else {
                response = res.getResponseDataAsString();
            }
        }
        return response;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    private static class ResultsNodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 4159626601097711565L;

        private ResultsNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
            boolean failure = true;
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof SampleResult) {
                failure = !((SampleResult)userObject).isSuccessful();
            } else if (userObject instanceof AssertionResult) {
                AssertionResult assertion = (AssertionResult)userObject;
                boolean bl = failure = assertion.isError() || assertion.isFailure();
            }
            if (failure) {
                this.setForeground(UIManager.getColor("[jmeter]Label.errorForeground"));
                this.setIcon(imageFailure);
            } else {
                this.setIcon(imageSuccess);
            }
            SearchableTreeNode node = (SearchableTreeNode)value;
            if (node.isNodeHasMatched()) {
                this.setBorder(RED_BORDER);
            } else if (node.isChildrenNodesHaveMatched()) {
                this.setBorder(BLUE_BORDER);
            } else {
                this.setBorder(null);
            }
            return this;
        }
    }
}

