/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor.json.render;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.RenderAsJSON;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.apache.jmeter.visualizers.ViewResultsFullVisualizer;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.JLabeledTextField;

abstract class AbstractRenderAsJsonRenderer
implements ResultRenderer,
ActionListener {
    protected static final String NO_MATCH = "NO MATCH";
    private static final String TAB_SEPARATOR = "    ";
    private static final String TESTER_COMMAND = "TESTER_COMMAND";
    private JPanel jsonWithExtractorPanel;
    private JSyntaxTextArea jsonDataField;
    private JLabeledTextField expressionField;
    private JTextArea resultField;
    private JTabbedPane rightSide;
    private SampleResult sampleResult;

    AbstractRenderAsJsonRenderer() {
    }

    @Override
    public void clearData() {
        this.jsonDataField.setText("");
        this.resultField.setText("");
    }

    @Override
    public void init() {
        this.jsonWithExtractorPanel = this.createExtractorPanel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (this.sampleResult != null && TESTER_COMMAND.equals(command)) {
            String response = this.jsonDataField.getText();
            this.executeTester(response);
        }
    }

    protected void executeTester(String textToParse) {
        if (textToParse != null && textToParse.length() > 0 && this.expressionField.getText().length() > 0) {
            this.resultField.setText(this.process(textToParse));
            this.resultField.setCaretPosition(0);
        }
    }

    protected String getExpression() {
        return this.expressionField.getText();
    }

    @Override
    public void renderResult(SampleResult sampleResult) {
        String response = ViewResultsFullVisualizer.getResponseAsString(sampleResult);
        this.jsonDataField.setText(response == null ? "" : RenderAsJSON.prettyJSON(response, TAB_SEPARATOR));
        this.jsonDataField.setCaretPosition(0);
    }

    @Override
    public void setupTabPane() {
        if (this.rightSide.indexOfTab(this.getTabLabel()) < 0) {
            this.rightSide.addTab(this.getTabLabel(), this.jsonWithExtractorPanel);
        }
        this.clearData();
    }

    private JPanel createExtractorPanel() {
        this.jsonDataField = JSyntaxTextArea.getInstance((int)50, (int)80, (boolean)true);
        this.jsonDataField.setCodeFoldingEnabled(true);
        this.jsonDataField.setEditable(false);
        this.jsonDataField.setBracketMatchingEnabled(false);
        this.jsonDataField.setSyntaxEditingStyle("text/json");
        this.jsonDataField.setLanguage("text/json");
        this.jsonDataField.setLineWrap(true);
        this.jsonDataField.setWrapStyleWord(true);
        JTextScrollPane jsonDataPane = JTextScrollPane.getInstance((JSyntaxTextArea)this.jsonDataField, (boolean)true);
        jsonDataPane.setPreferredSize(new Dimension(100, 200));
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        JSplitPane mainSplit = new JSplitPane(0, (Component)jsonDataPane, this.createTechnologyExtractorTasksPanel());
        mainSplit.setDividerLocation(0.6);
        mainSplit.setOneTouchExpandable(true);
        panel.add((Component)mainSplit, "Center");
        return panel;
    }

    private JPanel createTechnologyExtractorTasksPanel() {
        JPanel jsonPathActionPanel = new JPanel();
        jsonPathActionPanel.setLayout(new BoxLayout(jsonPathActionPanel, 0));
        EmptyBorder margin = new EmptyBorder(5, 5, 0, 5);
        jsonPathActionPanel.setBorder(margin);
        this.expressionField = new JLabeledTextField(this.getExpressionLabel());
        jsonPathActionPanel.add((Component)this.expressionField, "West");
        JButton testerButton = new JButton(this.getTestButtonLabel());
        testerButton.setActionCommand(TESTER_COMMAND);
        testerButton.addActionListener(this);
        jsonPathActionPanel.add((Component)testerButton, "East");
        this.resultField = new JTextArea();
        this.resultField.setEditable(false);
        this.resultField.setLineWrap(true);
        this.resultField.setWrapStyleWord(true);
        this.resultField.setMinimumSize(new Dimension(100, 150));
        JPanel jsonPathTasksPanel = new JPanel(new BorderLayout(0, 5));
        jsonPathTasksPanel.add((Component)jsonPathActionPanel, "North");
        jsonPathTasksPanel.add((Component)GuiUtils.makeScrollPane((Component)this.resultField), "Center");
        return jsonPathTasksPanel;
    }

    @Override
    public synchronized void setRightSide(JTabbedPane side) {
        this.rightSide = side;
    }

    @Override
    public synchronized void setSamplerResult(Object userObject) {
        if (userObject instanceof SampleResult) {
            this.sampleResult = (SampleResult)userObject;
        }
    }

    @Override
    public void setLastSelectedTab(int index) {
    }

    @Override
    public void renderImage(SampleResult sampleResult) {
        this.clearData();
        this.jsonDataField.setText(JMeterUtils.getResString((String)"render_no_text"));
    }

    @Override
    public void setBackgroundColor(Color backGround) {
    }

    protected abstract String getTabLabel();

    protected abstract String getTestButtonLabel();

    protected abstract String getExpressionLabel();

    protected abstract String process(String var1);

    protected synchronized JTabbedPane getRightSide() {
        return this.rightSide;
    }

    protected JPanel getJsonWithExtractorPanel() {
        return this.jsonWithExtractorPanel;
    }

    protected JSyntaxTextArea getJsonDataField() {
        return this.jsonDataField;
    }

    protected JLabeledTextField getExpressionField() {
        return this.expressionField;
    }

    protected JTextArea getResultField() {
        return this.resultField;
    }
}

