/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.jmeter.assertions.ResponseAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.gui.util.TextAreaCellRenderer;
import org.apache.jmeter.gui.util.TextAreaTableCellEditor;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.GuiUtils;

@GUIMenuSortOrder(value=1)
public class AssertionGui
extends AbstractAssertionGui {
    private static final long serialVersionUID = 240L;
    private static final String COL_RESOURCE_NAME = "assertion_patterns_to_test";
    private JRadioButton responseStringButton;
    private JRadioButton responseAsDocumentButton;
    private JRadioButton urlButton;
    private JRadioButton responseMessageButton;
    private JRadioButton responseCodeButton;
    private JRadioButton responseHeadersButton;
    private JRadioButton requestHeadersButton;
    private JRadioButton requestDataButton;
    private JCheckBox assumeSuccess;
    private JRadioButton containsBox;
    private JRadioButton matchesBox;
    private JRadioButton equalsBox;
    private JRadioButton substringBox;
    private JCheckBox notBox;
    private JCheckBox orBox;
    private JTable stringTable;
    private JButton deletePattern;
    private PowerTableModel tableModel;
    private JSyntaxTextArea alternativeFailureMessage;

    public AssertionGui() {
        this.init();
    }

    public String getLabelResource() {
        return "assertion_title";
    }

    public TestElement createTestElement() {
        ResponseAssertion el = new ResponseAssertion();
        this.modifyTestElement((TestElement)el);
        return el;
    }

    public void modifyTestElement(TestElement el) {
        GuiUtils.stopTableEditing((JTable)this.stringTable);
        this.configureTestElement(el);
        if (el instanceof ResponseAssertion) {
            String[] testStrings;
            ResponseAssertion ra = (ResponseAssertion)el;
            ra.setCustomFailureMessage(this.alternativeFailureMessage.getText());
            this.saveScopeSettings((AbstractScopedTestElement)ra);
            ra.clearTestStrings();
            for (String testString : testStrings = this.tableModel.getData().getColumn(COL_RESOURCE_NAME)) {
                ra.addTestString(testString);
            }
            if (this.responseStringButton.isSelected()) {
                ra.setTestFieldResponseData();
            } else if (this.responseAsDocumentButton.isSelected()) {
                ra.setTestFieldResponseDataAsDocument();
            } else if (this.responseCodeButton.isSelected()) {
                ra.setTestFieldResponseCode();
            } else if (this.responseMessageButton.isSelected()) {
                ra.setTestFieldResponseMessage();
            } else if (this.requestHeadersButton.isSelected()) {
                ra.setTestFieldRequestHeaders();
            } else if (this.requestDataButton.isSelected()) {
                ra.setTestFieldRequestData();
            } else if (this.responseHeadersButton.isSelected()) {
                ra.setTestFieldResponseHeaders();
            } else {
                ra.setTestFieldURL();
            }
            ra.setAssumeSuccess(this.assumeSuccess.isSelected());
            if (this.containsBox.isSelected()) {
                ra.setToContainsType();
            } else if (this.equalsBox.isSelected()) {
                ra.setToEqualsType();
            } else if (this.substringBox.isSelected()) {
                ra.setToSubstringType();
            } else {
                ra.setToMatchType();
            }
            if (this.notBox.isSelected()) {
                ra.setToNotType();
            } else {
                ra.unsetNotType();
            }
            if (this.orBox.isSelected()) {
                ra.setToOrType();
            } else {
                ra.unsetOrType();
            }
        }
    }

    public void clearGui() {
        super.clearGui();
        GuiUtils.stopTableEditing((JTable)this.stringTable);
        this.tableModel.clearData();
        this.responseStringButton.setSelected(true);
        this.urlButton.setSelected(false);
        this.responseCodeButton.setSelected(false);
        this.responseMessageButton.setSelected(false);
        this.requestHeadersButton.setSelected(false);
        this.requestDataButton.setSelected(false);
        this.responseHeadersButton.setSelected(false);
        this.assumeSuccess.setSelected(false);
        this.substringBox.setSelected(true);
        this.notBox.setSelected(false);
        this.orBox.setSelected(false);
        this.alternativeFailureMessage.setText("");
    }

    public void configure(TestElement el) {
        super.configure(el);
        ResponseAssertion model = (ResponseAssertion)el;
        this.showScopeSettings((AbstractScopedTestElement)model, true);
        if (model.getCustomFailureMessage() != null) {
            this.alternativeFailureMessage.setText(model.getCustomFailureMessage());
        }
        if (model.isContainsType()) {
            this.containsBox.setSelected(true);
        } else if (model.isEqualsType()) {
            this.equalsBox.setSelected(true);
        } else if (model.isSubstringType()) {
            this.substringBox.setSelected(true);
        } else {
            this.matchesBox.setSelected(true);
        }
        this.notBox.setSelected(model.isNotType());
        this.orBox.setSelected(model.isOrType());
        if (model.isTestFieldResponseData()) {
            this.responseStringButton.setSelected(true);
        } else if (model.isTestFieldResponseDataAsDocument()) {
            this.responseAsDocumentButton.setSelected(true);
        } else if (model.isTestFieldResponseCode()) {
            this.responseCodeButton.setSelected(true);
        } else if (model.isTestFieldResponseMessage()) {
            this.responseMessageButton.setSelected(true);
        } else if (model.isTestFieldRequestHeaders()) {
            this.requestHeadersButton.setSelected(true);
        } else if (model.isTestFieldRequestData()) {
            this.requestDataButton.setSelected(true);
        } else if (model.isTestFieldResponseHeaders()) {
            this.responseHeadersButton.setSelected(true);
        } else {
            this.urlButton.setSelected(true);
        }
        this.assumeSuccess.setSelected(model.getAssumeSuccess());
        this.tableModel.clearData();
        for (JMeterProperty jMeterProperty : model.getTestStrings()) {
            this.tableModel.addRow(new Object[]{jMeterProperty.getStringValue()});
        }
        boolean testStringsPresent = model.getTestStrings().size() != 0;
        this.deletePattern.setEnabled(testStringsPresent);
        this.tableModel.fireTableDataChanged();
    }

    void init() {
        this.setLayout(new BorderLayout());
        VerticalPanel box = new VerticalPanel();
        this.setBorder(this.makeBorder());
        box.add((Component)this.makeTitlePanel());
        box.add((Component)this.createScopePanel(true));
        box.add((Component)this.createFieldPanel());
        box.add((Component)this.createTypePanel());
        this.add((Component)box, "North");
        this.add(this.createStringPanel(), "Center");
        this.add(this.createCustomAssertionMessagePanel(), "South");
    }

    private JPanel createFieldPanel() {
        this.responseStringButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_text_resp"));
        this.responseAsDocumentButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_text_document"));
        this.urlButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_url_samp"));
        this.responseCodeButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_code_resp"));
        this.responseMessageButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_message_resp"));
        this.responseHeadersButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_headers"));
        this.requestHeadersButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_req_headers"));
        this.requestDataButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_req_data"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.responseStringButton);
        group.add(this.responseAsDocumentButton);
        group.add(this.urlButton);
        group.add(this.responseCodeButton);
        group.add(this.responseMessageButton);
        group.add(this.requestHeadersButton);
        group.add(this.responseHeadersButton);
        group.add(this.requestDataButton);
        this.responseStringButton.setSelected(true);
        this.assumeSuccess = new JCheckBox(JMeterUtils.getResString((String)"assertion_assume_success"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.initConstraints(gbc);
        JPanel panel = new JPanel(gridBagLayout);
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"assertion_resp_field")));
        this.addField(panel, this.responseStringButton, gbc);
        this.addField(panel, this.responseCodeButton, gbc);
        this.addField(panel, this.responseMessageButton, gbc);
        this.addField(panel, this.responseHeadersButton, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.requestHeadersButton, gbc);
        this.addField(panel, this.urlButton, gbc);
        this.addField(panel, this.responseAsDocumentButton, gbc);
        this.addField(panel, this.assumeSuccess, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.requestDataButton, gbc);
        return panel;
    }

    private void addField(JPanel panel, JToggleButton button, GridBagConstraints gbc) {
        panel.add((Component)button, gbc.clone());
        ++gbc.gridx;
        gbc.fill = 2;
    }

    private void resetContraints(GridBagConstraints gbc) {
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 0;
    }

    private void initConstraints(GridBagConstraints gbc) {
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
    }

    private JPanel createTypePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"assertion_pattern_match_rules")));
        ButtonGroup group = new ButtonGroup();
        this.containsBox = new JRadioButton(JMeterUtils.getResString((String)"assertion_contains"));
        group.add(this.containsBox);
        this.containsBox.setSelected(true);
        panel.add(this.containsBox);
        this.matchesBox = new JRadioButton(JMeterUtils.getResString((String)"assertion_matches"));
        group.add(this.matchesBox);
        panel.add(this.matchesBox);
        this.equalsBox = new JRadioButton(JMeterUtils.getResString((String)"assertion_equals"));
        group.add(this.equalsBox);
        panel.add(this.equalsBox);
        this.substringBox = new JRadioButton(JMeterUtils.getResString((String)"assertion_substring"));
        group.add(this.substringBox);
        panel.add(this.substringBox);
        this.notBox = new JCheckBox(JMeterUtils.getResString((String)"assertion_not"));
        panel.add(this.notBox);
        this.orBox = new JCheckBox(JMeterUtils.getResString((String)"assertion_or"));
        panel.add(this.orBox);
        return panel;
    }

    private JPanel createStringPanel() {
        this.tableModel = new PowerTableModel(new String[]{COL_RESOURCE_NAME}, new Class[]{String.class});
        this.stringTable = new JTable((TableModel)this.tableModel);
        this.stringTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        this.stringTable.setSelectionMode(2);
        JMeterUtils.applyHiDPI((JTable)this.stringTable);
        TextAreaCellRenderer renderer = new TextAreaCellRenderer();
        this.stringTable.setRowHeight(renderer.getPreferredHeight());
        this.stringTable.setDefaultRenderer(String.class, (TableCellRenderer)renderer);
        this.stringTable.setDefaultEditor(String.class, (TableCellEditor)new TextAreaTableCellEditor());
        this.stringTable.setPreferredScrollableViewportSize(new Dimension(100, 70));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)COL_RESOURCE_NAME)));
        panel.add((Component)GuiUtils.emptyBorder((JComponent)new JScrollPane(this.stringTable)), "Center");
        panel.add((Component)this.createButtonPanel(), "South");
        return panel;
    }

    private JPanel createCustomAssertionMessagePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"assertion_custom_message")));
        this.alternativeFailureMessage = JSyntaxTextArea.getInstance((int)3, (int)80);
        panel.add((Component)JTextScrollPane.getInstance((JSyntaxTextArea)this.alternativeFailureMessage));
        return panel;
    }

    private JPanel createButtonPanel() {
        JButton addPattern = new JButton(JMeterUtils.getResString((String)"add"));
        addPattern.addActionListener(new AddPatternListener());
        JButton addFromClipboardPattern = new JButton(JMeterUtils.getResString((String)"add_from_clipboard"));
        addFromClipboardPattern.addActionListener(new AddFromClipboardListener());
        this.deletePattern = new JButton(JMeterUtils.getResString((String)"delete"));
        this.deletePattern.addActionListener(new ClearPatternsListener());
        this.deletePattern.setEnabled(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(addPattern);
        buttonPanel.add(addFromClipboardPattern);
        buttonPanel.add(this.deletePattern);
        return buttonPanel;
    }

    protected void checkButtonsStatus() {
        this.deletePattern.setEnabled(this.tableModel.getRowCount() != 0);
    }

    private class AddFromClipboardListener
    implements ActionListener {
        private AddFromClipboardListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AssertionGui.this.deletePattern.setEnabled(true);
            GuiUtils.stopTableEditing((JTable)AssertionGui.this.stringTable);
            int rowCount = AssertionGui.this.stringTable.getRowCount();
            try {
                String[] clipboardLines;
                String clipboardContent = GuiUtils.getPastedText();
                if (clipboardContent == null) {
                    return;
                }
                for (String clipboardLine : clipboardLines = clipboardContent.split("\n")) {
                    AssertionGui.this.tableModel.addRow(new Object[]{clipboardLine.trim()});
                }
                if (AssertionGui.this.stringTable.getRowCount() > rowCount) {
                    AssertionGui.this.checkButtonsStatus();
                    int rowToSelect = AssertionGui.this.tableModel.getRowCount() - 1;
                    AssertionGui.this.stringTable.setRowSelectionInterval(rowCount, rowToSelect);
                    AssertionGui.this.stringTable.scrollRectToVisible(AssertionGui.this.stringTable.getCellRect(rowCount, 0, true));
                }
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog((Component)GuiPackage.getInstance().getMainFrame(), "Could not add data from clipboard:\n" + ioe.getLocalizedMessage(), "Error", 0);
            }
            catch (UnsupportedFlavorException ufe) {
                JOptionPane.showMessageDialog((Component)GuiPackage.getInstance().getMainFrame(), "Could not add retrieve " + DataFlavor.stringFlavor.getHumanPresentableName() + " from clipboard" + ufe.getLocalizedMessage(), "Error", 0);
            }
            AssertionGui.this.tableModel.fireTableDataChanged();
        }
    }

    private class AddPatternListener
    implements ActionListener {
        private AddPatternListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiUtils.stopTableEditing((JTable)AssertionGui.this.stringTable);
            AssertionGui.this.tableModel.addNewRow();
            AssertionGui.this.checkButtonsStatus();
            AssertionGui.this.tableModel.fireTableDataChanged();
        }
    }

    private class ClearPatternsListener
    implements ActionListener {
        private ClearPatternsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiUtils.cancelEditing((JTable)AssertionGui.this.stringTable);
            int[] rowsSelected = AssertionGui.this.stringTable.getSelectedRows();
            AssertionGui.this.stringTable.clearSelection();
            if (rowsSelected.length > 0) {
                for (int i = rowsSelected.length - 1; i >= 0; --i) {
                    AssertionGui.this.tableModel.removeRow(rowsSelected[i]);
                }
                AssertionGui.this.tableModel.fireTableDataChanged();
            } else if (AssertionGui.this.tableModel.getRowCount() > 0) {
                AssertionGui.this.tableModel.removeRow(0);
                AssertionGui.this.tableModel.fireTableDataChanged();
            }
            if (AssertionGui.this.stringTable.getModel().getRowCount() == 0) {
                AssertionGui.this.deletePattern.setEnabled(false);
            }
        }
    }
}

