/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor.json.jsonpath;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class JSONManager {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final Configuration DEFAULT_CONFIGURATION = Configuration.defaultConfiguration().addOptions(new Option[]{Option.ALWAYS_RETURN_LIST});
    private Map<String, JsonPath> expressionToJsonPath = new HashMap<String, JsonPath>(2);

    private JsonPath getJsonPath(String jsonPathExpression) {
        JsonPath jsonPath = this.expressionToJsonPath.get(jsonPathExpression);
        if (jsonPath == null) {
            jsonPath = JsonPath.compile((String)jsonPathExpression, (Predicate[])new Predicate[0]);
            this.expressionToJsonPath.put(jsonPathExpression, jsonPath);
        }
        return jsonPath;
    }

    public void reset() {
        this.expressionToJsonPath.clear();
    }

    public List<Object> extractWithJsonPath(String jsonString, String jsonPath) throws ParseException {
        List extractedObjects;
        JsonPath jsonPathParser = this.getJsonPath(jsonPath);
        try {
            extractedObjects = (List)jsonPathParser.read(jsonString, DEFAULT_CONFIGURATION);
        }
        catch (PathNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug("Could not find JSON Path " + jsonPath + " in [" + jsonString + "]: " + e.getLocalizedMessage());
            }
            return Collections.emptyList();
        }
        ArrayList<Object> results = new ArrayList<Object>(extractedObjects.size());
        for (Object obj : extractedObjects) {
            results.add(this.stringifyJSONObject(obj));
        }
        return results;
    }

    private String stringifyJSONObject(Object obj) {
        if (obj instanceof Map) {
            return new JSONObject((Map)obj).toJSONString();
        }
        if (obj instanceof JSONArray) {
            return ((JSONArray)obj).toJSONString();
        }
        return obj == null ? "" : obj.toString();
    }
}

