/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class CriticalSectionController
extends GenericController
implements ThreadListener,
TestStateListener {
    private static final long serialVersionUID = 4362876132435968088L;
    private static final Logger logger = LoggingManager.getLoggerForClass();
    private static final String LOCK_NAME = "CriticalSectionController.lockName";
    private static final ConcurrentHashMap<String, ReentrantLock> LOCK_MAP = new ConcurrentHashMap();
    private volatile transient ReentrantLock currentLock;

    public CriticalSectionController() {
    }

    public CriticalSectionController(String name) {
        this.setName(name);
    }

    public void setLockName(String name) {
        this.setProperty((JMeterProperty)new StringProperty(LOCK_NAME, name));
    }

    private ReentrantLock getOrCreateLock() {
        String lockName = this.getLockName();
        ReentrantLock lock = LOCK_MAP.get(lockName);
        ReentrantLock prev = null;
        if (lock != null) {
            return lock;
        }
        lock = new ReentrantLock();
        prev = LOCK_MAP.putIfAbsent(lockName, lock);
        return prev == null ? lock : prev;
    }

    public String getLockName() {
        return this.getPropertyAsString(LOCK_NAME);
    }

    public Sampler next() {
        if (StringUtils.isEmpty((CharSequence)this.getLockName())) {
            logger.warn("Empty lock name in Critical Section Controller:" + this.getName());
            return super.next();
        }
        if (this.isFirst()) {
            long startTime = System.currentTimeMillis();
            if (this.currentLock == null) {
                this.currentLock = this.getOrCreateLock();
            }
            this.currentLock.lock();
            long endTime = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug(Thread.currentThread().getName() + " acquired lock:'" + this.getLockName() + "' in Critical Section Controller " + this.getName() + " in:" + (endTime - startTime) + " ms");
            }
        }
        return super.next();
    }

    protected void reInitialize() {
        if (this.currentLock != null) {
            if (this.currentLock.isHeldByCurrentThread()) {
                this.currentLock.unlock();
            }
            this.currentLock = null;
        }
        super.reInitialize();
    }

    public void threadStarted() {
        this.currentLock = null;
    }

    public void threadFinished() {
        if (this.currentLock != null && this.currentLock.isHeldByCurrentThread()) {
            logger.warn("Lock " + this.getLockName() + " not released in:" + this.getName() + ", releasing in threadFinished");
            this.currentLock.unlock();
        }
        this.currentLock = null;
    }

    public void testStarted() {
    }

    public void testStarted(String host) {
    }

    public void testEnded() {
        LOCK_MAP.clear();
    }

    public void testEnded(String host) {
        this.testEnded();
    }
}

