/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend.graphite;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.jmeter.visualizers.backend.graphite.AbstractGraphiteMetricsSender;
import org.apache.jmeter.visualizers.backend.graphite.GraphiteMetricsSender;
import org.apache.jmeter.visualizers.backend.graphite.SocketConnectionInfos;
import org.apache.jmeter.visualizers.backend.graphite.SocketOutputStream;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

class PickleGraphiteMetricsSender
extends AbstractGraphiteMetricsSender {
    private static final Logger LOG = LoggingManager.getLoggerForClass();
    private static final char APPEND = 'a';
    private static final char LIST = 'l';
    private static final char LONG = 'L';
    private static final char MARK = '(';
    private static final char STOP = '.';
    private static final char STRING = 'S';
    private static final char TUPLE = 't';
    private static final char QUOTE = '\'';
    private static final char LF = '\n';
    private String prefix;
    private List<GraphiteMetricsSender.MetricTuple> metrics = new LinkedList<GraphiteMetricsSender.MetricTuple>();
    private GenericKeyedObjectPool<SocketConnectionInfos, SocketOutputStream> socketOutputStreamPool;
    private SocketConnectionInfos socketConnectionInfos;

    PickleGraphiteMetricsSender() {
    }

    @Override
    public void setup(String graphiteHost, int graphitePort, String prefix) {
        this.prefix = prefix;
        this.socketConnectionInfos = new SocketConnectionInfos(graphiteHost, graphitePort);
        this.socketOutputStreamPool = this.createSocketOutputStreamPool();
        if (LOG.isInfoEnabled()) {
            LOG.info("Created PickleGraphiteMetricsSender with host:" + graphiteHost + ", port:" + graphitePort + ", prefix:" + prefix);
        }
    }

    @Override
    public void addMetric(long timestamp, String contextName, String metricName, String metricValue) {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.prefix).append(contextName).append(".").append(metricName);
        this.metrics.add(new GraphiteMetricsSender.MetricTuple(sb.toString(), timestamp, metricValue));
    }

    @Override
    public void writeAndSendMetrics() {
        if (this.metrics.size() > 0) {
            SocketOutputStream out = null;
            try {
                String payload = PickleGraphiteMetricsSender.convertMetricsToPickleFormat(this.metrics);
                int length = payload.length();
                byte[] header = ByteBuffer.allocate(4).putInt(length).array();
                out = (SocketOutputStream)this.socketOutputStreamPool.borrowObject((Object)this.socketConnectionInfos);
                out.write(header);
                OutputStreamWriter pickleWriter = new OutputStreamWriter((OutputStream)out, "UTF-8");
                pickleWriter.write(payload);
                ((Writer)pickleWriter).flush();
                this.socketOutputStreamPool.returnObject((Object)this.socketConnectionInfos, (Object)out);
            }
            catch (Exception e) {
                if (out != null) {
                    try {
                        this.socketOutputStreamPool.invalidateObject((Object)this.socketConnectionInfos, out);
                    }
                    catch (Exception e1) {
                        LOG.warn("Exception invalidating socketOutputStream connected to graphite server '" + this.socketConnectionInfos.getHost() + "':" + this.socketConnectionInfos.getPort(), (Throwable)e1);
                    }
                }
                LOG.error("Error writing to Graphite:" + e.getMessage());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Wrote " + this.metrics.size() + " metrics");
            }
            this.metrics.clear();
        }
    }

    @Override
    public void destroy() {
        this.socketOutputStreamPool.close();
    }

    private static String convertMetricsToPickleFormat(List<GraphiteMetricsSender.MetricTuple> metrics) {
        StringBuilder pickled = new StringBuilder(metrics.size() * 75);
        pickled.append('(').append('l');
        for (GraphiteMetricsSender.MetricTuple tuple : metrics) {
            pickled.append('(');
            pickled.append('S').append('\'').append(tuple.name).append('\'').append('\n');
            pickled.append('(');
            pickled.append('L').append(tuple.timestamp).append('L').append('\n');
            pickled.append('S').append('\'').append(tuple.value).append('\'').append('\n');
            pickled.append('t').append('t');
            pickled.append('a');
        }
        pickled.append('.');
        return pickled.toString();
    }
}

