/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor.json.jsonpath;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.jmeter.extractor.json.jsonpath.JSONManager;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class JSONPostProcessor
extends AbstractScopedTestElement
implements Serializable,
PostProcessor,
ThreadListener {
    private static final long serialVersionUID = 1320798545214331506L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String JSON_PATH_EXPRESSIONS = "JSONPostProcessor.jsonPathExprs";
    private static final String REFERENCE_NAMES = "JSONPostProcessor.referenceNames";
    private static final String DEFAULT_VALUES = "JSONPostProcessor.defaultValues";
    private static final String MATCH_NUMBERS = "JSONPostProcessor.match_numbers";
    private static final String COMPUTE_CONCATENATION = "JSONPostProcessor.compute_concat";
    private static final String REF_MATCH_NR = "_matchNr";
    private static final String ALL_SUFFIX = "_ALL";
    private static final String JSON_CONCATENATION_SEPARATOR = ",";
    private static final String SEPARATOR = ";";
    public static final boolean COMPUTE_CONCATENATION_DEFAULT_VALUE = false;
    private static final ThreadLocal<JSONManager> localMatcher = new ThreadLocal<JSONManager>(){

        @Override
        protected JSONManager initialValue() {
            return new JSONManager();
        }
    };

    public void process() {
        String jsonResponse;
        JMeterContext context = this.getThreadContext();
        JMeterVariables vars = context.getVariables();
        if (this.isScopeVariable()) {
            jsonResponse = vars.get(this.getVariableName());
            if (log.isDebugEnabled()) {
                log.debug("JSON Extractor is using variable:" + this.getVariableName() + " which content is:" + jsonResponse);
            }
        } else {
            SampleResult previousResult = context.getPreviousResult();
            if (previousResult == null) {
                return;
            }
            jsonResponse = previousResult.getResponseDataAsString();
            if (log.isDebugEnabled()) {
                log.debug("JSON Extractor " + this.getName() + " working on Response:" + jsonResponse);
            }
        }
        String[] refNames = this.getRefNames().split(SEPARATOR);
        String[] jsonPathExpressions = this.getJsonPathExpressions().split(SEPARATOR);
        String[] defaultValues = this.getDefaultValues().split(SEPARATOR);
        int[] matchNumbers = this.getMatchNumbersAsInt(defaultValues.length);
        if (refNames.length != jsonPathExpressions.length || refNames.length != defaultValues.length) {
            log.error("Number of JSON Path variables must match number of default values and json-path expressions, check you use separator ';' if you have many values");
            throw new IllegalArgumentException(JMeterUtils.getResString((String)"jsonpp_error_number_arguments_mismatch_error"));
        }
        for (int i = 0; i < jsonPathExpressions.length; ++i) {
            int matchNumber = matchNumbers[i];
            String currentRefName = refNames[i].trim();
            String currentJsonPath = jsonPathExpressions[i].trim();
            try {
                if (jsonResponse.isEmpty()) {
                    vars.put(currentRefName, defaultValues[i]);
                    continue;
                }
                List<Object> extractedValues = localMatcher.get().extractWithJsonPath(jsonResponse, currentJsonPath);
                if (extractedValues.isEmpty()) {
                    vars.put(currentRefName, defaultValues[i]);
                    vars.put(currentRefName + REF_MATCH_NR, "0");
                    if (matchNumber >= 0 || !this.getComputeConcatenation()) continue;
                    log.debug("No value extracted, storing empty in:" + currentRefName + ALL_SUFFIX);
                    vars.put(currentRefName + ALL_SUFFIX, "");
                    continue;
                }
                if (extractedValues.size() > 1) {
                    if (matchNumber < 0) {
                        int index = 1;
                        StringBuilder concat = new StringBuilder(this.getComputeConcatenation() ? extractedValues.size() * 20 : 1);
                        for (Object stringExtracted : extractedValues) {
                            vars.put(currentRefName + "_" + index, stringExtracted != null ? stringExtracted.toString() : "");
                            if (this.getComputeConcatenation()) {
                                concat.append(stringExtracted).append(JSON_CONCATENATION_SEPARATOR);
                            }
                            ++index;
                        }
                        if (this.getComputeConcatenation()) {
                            concat.setLength(concat.length() - 1);
                            vars.put(currentRefName + ALL_SUFFIX, concat.toString());
                        }
                    } else if (matchNumber == 0) {
                        int matchSize = extractedValues.size();
                        Object obj = extractedValues.get(JMeterUtils.getRandomInt((int)matchSize));
                        vars.put(currentRefName, obj != null ? obj.toString() : "");
                    } else if (matchNumber > extractedValues.size()) {
                        if (log.isDebugEnabled()) {
                            log.debug("matchNumber(" + matchNumber + ") exceeds number of items found(" + extractedValues.size() + "), default value will be used");
                        }
                        vars.put(currentRefName, defaultValues[i]);
                    } else {
                        Object obj = extractedValues.get(matchNumber - 1);
                        vars.put(currentRefName, obj != null ? obj.toString() : "");
                    }
                } else {
                    Object obj = extractedValues.get(0);
                    String objAsString = obj != null ? obj.toString() : "";
                    vars.put(currentRefName, objAsString);
                    if (matchNumber < 0 && this.getComputeConcatenation()) {
                        vars.put(currentRefName + ALL_SUFFIX, objAsString);
                    }
                }
                vars.put(currentRefName + REF_MATCH_NR, Integer.toString(extractedValues.size()));
                continue;
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.error("Error processing JSON content in " + this.getName() + ", message:" + e.getLocalizedMessage(), (Throwable)e);
                } else {
                    log.error("Error processing JSON content in " + this.getName() + ", message:" + e.getLocalizedMessage());
                }
                vars.put(currentRefName, defaultValues[i]);
            }
        }
    }

    public String getJsonPathExpressions() {
        return this.getPropertyAsString(JSON_PATH_EXPRESSIONS);
    }

    public void setJsonPathExpressions(String jsonPath) {
        this.setProperty(JSON_PATH_EXPRESSIONS, jsonPath);
    }

    public String getRefNames() {
        return this.getPropertyAsString(REFERENCE_NAMES);
    }

    public void setRefNames(String refName) {
        this.setProperty(REFERENCE_NAMES, refName);
    }

    public String getDefaultValues() {
        return this.getPropertyAsString(DEFAULT_VALUES);
    }

    public void setDefaultValues(String defaultValue) {
        this.setProperty(DEFAULT_VALUES, defaultValue, "");
    }

    public boolean getComputeConcatenation() {
        return this.getPropertyAsBoolean(COMPUTE_CONCATENATION, false);
    }

    public void setComputeConcatenation(boolean computeConcatenation) {
        this.setProperty(COMPUTE_CONCATENATION, computeConcatenation, false);
    }

    public void threadStarted() {
    }

    public void threadFinished() {
        localMatcher.get().reset();
    }

    public void setMatchNumbers(String matchNumber) {
        this.setProperty(MATCH_NUMBERS, matchNumber);
    }

    public String getMatchNumbers() {
        return this.getPropertyAsString(MATCH_NUMBERS);
    }

    public int[] getMatchNumbersAsInt(int arraySize) {
        String matchNumbersAsString = this.getMatchNumbers();
        int[] result = new int[arraySize];
        if (JOrphanUtils.isBlank((String)matchNumbersAsString)) {
            Arrays.fill(result, 0);
        } else {
            String[] matchNumbersAsStringArray = matchNumbersAsString.split(SEPARATOR);
            for (int i = 0; i < matchNumbersAsStringArray.length; ++i) {
                result[i] = Integer.parseInt(matchNumbersAsStringArray[i].trim());
            }
        }
        return result;
    }
}

