/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.DistributionGraph;
import org.apache.jmeter.visualizers.GraphListener;
import org.apache.jmeter.visualizers.ImageVisualizer;
import org.apache.jmeter.visualizers.Sample;
import org.apache.jmeter.visualizers.SamplingStatCalculator;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;

public class DistributionGraphVisualizer
extends AbstractVisualizer
implements ImageVisualizer,
GraphListener,
Clearable {
    private static final long serialVersionUID = 240L;
    private final SamplingStatCalculator model = new SamplingStatCalculator("Distribution");
    private JPanel graphPanel = null;
    private final DistributionGraph graph = new DistributionGraph(this.model);
    private JTextField noteField;
    private static final int DELAY = 10;
    private int counter = 0;

    public DistributionGraphVisualizer() {
        this.graph.setBackground(Color.white);
        this.init();
    }

    public Image getImage() {
        Image result = this.graph.createImage(this.graph.getWidth(), this.graph.getHeight());
        this.graph.paintComponent(result.getGraphics());
        return result;
    }

    public synchronized void updateGui() {
        if (this.graph.getWidth() < 10) {
            this.graph.setPreferredSize(new Dimension(this.getWidth() - 40, this.getHeight() - 160));
        }
        this.graphPanel.updateUI();
        this.graph.repaint();
    }

    public synchronized void updateGui(Sample s) {
        if (10 == this.counter) {
            this.updateGui();
            this.counter = 0;
        } else {
            ++this.counter;
        }
    }

    public void add(final SampleResult res) {
        JMeterUtils.runSafe((Runnable)new Runnable(){

            public void run() {
                DistributionGraphVisualizer.this.model.addSample(res);
                DistributionGraphVisualizer.this.updateGui(DistributionGraphVisualizer.this.model.getCurrentSample());
            }
        });
    }

    public String getLabelResource() {
        return "distribution_graph_title";
    }

    public synchronized void clearData() {
        this.graph.clearData();
        this.model.clear();
        this.repaint();
    }

    public String toString() {
        return "Show the samples in a distribution graph";
    }

    private void init() {
        this.setLayout(new BorderLayout());
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        this.setBorder(margin);
        JPanel lgraphPanel = new JPanel(new BorderLayout());
        lgraphPanel.add(this.createGraphPanel(), "Center");
        lgraphPanel.add((Component)this.createGraphInfoPanel(), "South");
        this.add(this.makeTitlePanel(), "North");
        this.add(lgraphPanel, "Center");
    }

    private Component createGraphPanel() {
        this.graphPanel = new JPanel();
        this.graphPanel.setBorder(BorderFactory.createBevelBorder(1, Color.lightGray, Color.darkGray));
        this.graphPanel.add(this.graph);
        this.graphPanel.setBackground(Color.white);
        return this.graphPanel;
    }

    private JLabel createInfoLabel(String labelResourceName, JTextField field) {
        JLabel label = new JLabel(JMeterUtils.getResString((String)labelResourceName));
        label.setForeground(field.getForeground());
        label.setLabelFor(field);
        return label;
    }

    private Box createGraphInfoPanel() {
        Box graphInfoPanel = Box.createHorizontalBox();
        this.noteField = new JTextField();
        graphInfoPanel.add(this.createInfoLabel("distribution_note1", this.noteField));
        return graphInfoPanel;
    }

    public JComponent getPrintableComponent() {
        return this.graphPanel;
    }
}

