/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config;

import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.SSLManager;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterStopTestException;
import org.apache.log.Logger;

public class KeystoreConfig
extends ConfigTestElement
implements TestBean,
TestStateListener {
    private static final long serialVersionUID = -5781402012242794890L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String KEY_STORE_START_INDEX = "https.keyStoreStartIndex";
    private static final String KEY_STORE_END_INDEX = "https.keyStoreEndIndex";
    private String startIndex;
    private String endIndex;
    private String preload;

    public void testEnded() {
        this.testEnded(null);
    }

    public void testEnded(String host) {
        log.info("Destroying Keystore");
        SSLManager.getInstance().destroyKeystore();
    }

    public void testStarted() {
        this.testStarted(null);
    }

    public void testStarted(String host) {
        String reuseSSLContext = JMeterUtils.getProperty((String)"https.use.cached.ssl.context");
        if (StringUtils.isEmpty((CharSequence)reuseSSLContext) || "true".equals(reuseSSLContext)) {
            log.warn("https.use.cached.ssl.context property must be set to false to ensure Multiple Certificates are used");
        }
        int startIndexAsInt = JMeterUtils.getPropDefault((String)KEY_STORE_START_INDEX, (int)0);
        int endIndexAsInt = JMeterUtils.getPropDefault((String)KEY_STORE_END_INDEX, (int)0);
        if (!StringUtils.isEmpty((CharSequence)this.startIndex)) {
            try {
                startIndexAsInt = Integer.parseInt(this.startIndex);
            }
            catch (NumberFormatException e) {
                log.warn("Failed parsing startIndex :'" + this.startIndex + "', will default to:'" + startIndexAsInt + "', error message:" + e.getMessage(), (Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)this.endIndex)) {
            try {
                endIndexAsInt = Integer.parseInt(this.endIndex);
            }
            catch (NumberFormatException e) {
                log.warn("Failed parsing endIndex :'" + this.endIndex + "', will default to:'" + endIndexAsInt + "', error message:" + e.getMessage(), (Throwable)e);
            }
        }
        if (startIndexAsInt > endIndexAsInt) {
            throw new JMeterStopTestException("Keystore Config error : Alias start index must be lower than Alias end index");
        }
        log.info("Configuring Keystore with (preload:" + this.preload + ", startIndex:" + startIndexAsInt + ", endIndex:" + endIndexAsInt + ")");
        SSLManager.getInstance().configureKeystore(Boolean.parseBoolean(this.preload), startIndexAsInt, endIndexAsInt);
    }

    public String getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(String endIndex) {
        this.endIndex = endIndex;
    }

    public String getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(String startIndex) {
        this.startIndex = startIndex;
    }

    public String getPreload() {
        return this.preload;
    }

    public void setPreload(String preload) {
        this.preload = preload;
    }
}

